/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.io.File;
import java.util.Map;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.apache.maven.shared.release.exec.MavenExecutor;
import org.apache.maven.shared.release.exec.MavenExecutorException;
import org.apache.maven.shared.release.phase.AbstractReleasePhase;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractRunGoalsPhase
extends AbstractReleasePhase {
    @Requirement(role=MavenExecutor.class)
    private Map<String, MavenExecutor> mavenExecutors;

    public ReleaseResult execute(ReleaseDescriptor releaseDescriptor, ReleaseEnvironment releaseEnvironment, File workingDirectory, String additionalArguments) throws ReleaseExecutionException {
        ReleaseResult result = new ReleaseResult();
        try {
            String goals = this.getGoals(releaseDescriptor);
            if (!StringUtils.isEmpty(goals)) {
                String pomFileName;
                File executionRoot;
                this.logInfo(result, "Executing goals '" + goals + "'...");
                MavenExecutor mavenExecutor = this.mavenExecutors.get(releaseEnvironment.getMavenExecutorId());
                if (mavenExecutor == null) {
                    throw new ReleaseExecutionException("Cannot find Maven executor with id: " + releaseEnvironment.getMavenExecutorId());
                }
                if (releaseDescriptor.getPomFileName() != null) {
                    File rootPom = new File(workingDirectory, releaseDescriptor.getPomFileName());
                    executionRoot = rootPom.getParentFile();
                    pomFileName = rootPom.getName();
                } else {
                    executionRoot = workingDirectory;
                    pomFileName = null;
                }
                mavenExecutor.executeGoals(executionRoot, goals, releaseEnvironment, releaseDescriptor.isInteractive(), additionalArguments, pomFileName, result);
            }
        }
        catch (MavenExecutorException e) {
            throw new ReleaseExecutionException(e.getMessage(), e);
        }
        result.setResultCode(0);
        return result;
    }

    protected abstract String getGoals(ReleaseDescriptor var1);

    protected String getAdditionalArguments(ReleaseDescriptor releaseDescriptor) {
        StringBuilder builder = new StringBuilder();
        if (releaseDescriptor.getAdditionalArguments() != null) {
            builder.append(releaseDescriptor.getAdditionalArguments());
        }
        if (!releaseDescriptor.getActivateProfiles().isEmpty()) {
            builder.append(" -P ").append(StringUtils.join(releaseDescriptor.getActivateProfiles().iterator(), ","));
        }
        return builder.length() > 0 ? builder.toString().trim() : null;
    }

    protected File determineWorkingDirectory(File checkoutDirectory, String relativePathProjectDirectory) {
        File workingDirectory = checkoutDirectory;
        if (StringUtils.isNotEmpty(relativePathProjectDirectory)) {
            workingDirectory = new File(checkoutDirectory, relativePathProjectDirectory);
        }
        return workingDirectory;
    }
}

