/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.settings.Settings;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.session.MavenSessionHandler;
import org.commonjava.maven.ext.common.util.ManifestUtils;
import org.commonjava.maven.ext.core.state.CommonState;
import org.commonjava.maven.ext.core.state.State;

@Named
@Singleton
public class ManipulationSession
implements MavenSessionHandler {
    private static final String MANIPULATIONS_DISABLED_PROP = "manipulation.disable";
    private final Map<Class<?>, State> states = new HashMap();
    private MavenSession mavenSession;
    private List<Project> projects;
    private ManipulationException error;

    public ManipulationSession() {
        try {
            System.out.println("[INFO] Running Maven Manipulation Extension (PME) " + ManifestUtils.getManifestInformation(ManipulationSession.class));
        }
        catch (ManipulationException manipulationException) {
            // empty catch block
        }
    }

    public boolean isEnabled() {
        return !Boolean.parseBoolean(this.getUserProperties().getProperty(MANIPULATIONS_DISABLED_PROP, "false"));
    }

    public void setState(State state) {
        this.states.put(state.getClass(), state);
    }

    public void reinitialiseStates() throws ManipulationException {
        for (State s : this.states.values()) {
            s.initialise(this.getUserProperties());
        }
    }

    public <T extends State> T getState(Class<T> stateType) {
        return (T)((State)stateType.cast(this.states.get(stateType)));
    }

    public void setMavenSession(MavenSession mavenSession) {
        this.mavenSession = mavenSession;
    }

    @Override
    public Properties getUserProperties() {
        return this.mavenSession == null ? new Properties() : this.mavenSession.getRequest().getUserProperties();
    }

    public void setProjects(List<Project> projects) {
        this.projects = projects;
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    @Override
    public List<ArtifactRepository> getRemoteRepositories() {
        return this.mavenSession == null ? null : this.mavenSession.getRequest().getRemoteRepositories();
    }

    @Override
    public File getPom() throws ManipulationException {
        if (this.mavenSession == null) {
            throw new ManipulationException("Invalid session", new Object[0]);
        }
        return this.mavenSession.getRequest().getPom();
    }

    @Override
    public File getTargetDir() {
        if (this.mavenSession == null) {
            return new File("target");
        }
        File pom = this.mavenSession.getRequest().getPom();
        if (pom == null) {
            return new File("target");
        }
        return new File(pom.getParentFile(), "target");
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        return this.mavenSession == null ? null : this.mavenSession.getRequest().getLocalRepository();
    }

    public void setError(ManipulationException error) {
        this.error = error;
    }

    public ManipulationException getError() {
        return this.error;
    }

    @Override
    public List<String> getActiveProfiles() {
        return this.mavenSession == null || this.mavenSession.getRequest() == null ? Collections.emptyList() : this.mavenSession.getRequest().getActiveProfiles();
    }

    @Override
    public Settings getSettings() {
        return this.mavenSession == null ? null : this.mavenSession.getSettings();
    }

    public boolean anyStateEnabled(List<Class<? extends State>> ignoreList) {
        boolean result = false;
        for (Map.Entry<Class<?>, State> entry : this.states.entrySet()) {
            Class<?> c = entry.getKey();
            State state = entry.getValue();
            if (ignoreList.contains(c) || !state.isEnabled()) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public List<String> getExcludedScopes() {
        if (this.states.containsKey(CommonState.class)) {
            return this.getState(CommonState.class).getExcludedScopes();
        }
        return Collections.emptyList();
    }

    MavenSession getSession() {
        return this.mavenSession;
    }
}

