/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import groovy.lang.GroovyShell;
import groovy.lang.MissingMethodException;
import groovy.lang.Script;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.control.CompilationFailedException;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.model.SimpleScopedArtifactRef;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.groovy.BaseScript;
import org.commonjava.maven.ext.core.groovy.InvocationPoint;
import org.commonjava.maven.ext.core.groovy.InvocationStage;
import org.commonjava.maven.ext.io.FileIO;
import org.commonjava.maven.ext.io.ModelIO;
import org.commonjava.maven.ext.io.PomIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseGroovyManipulator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ModelIO modelIO;
    protected FileIO fileIO;
    protected PomIO pomIO;
    protected ManipulationSession session;

    BaseGroovyManipulator(ModelIO modelIO, FileIO fileIO, PomIO pomIO) {
        this.modelIO = modelIO;
        this.fileIO = fileIO;
        this.pomIO = pomIO;
    }

    public abstract int getExecutionIndex();

    List<File> parseGroovyScripts(String value) throws ManipulationException {
        if (StringUtils.isEmpty(value)) {
            return Collections.emptyList();
        }
        String[] scripts = value.split(",");
        ArrayList<File> result = new ArrayList<File>(scripts.length);
        this.logger.debug("Processing groovy scripts {}", (Object)value);
        try {
            for (String script : scripts) {
                File found;
                if (script.startsWith("http") || script.startsWith("file")) {
                    this.logger.info("Attempting to read URL {}", (Object)script);
                    found = this.fileIO.resolveURL(script);
                } else {
                    SimpleScopedArtifactRef ar = SimpleScopedArtifactRef.parse(script);
                    this.logger.info("Attempting to read GAV {} with classifier {} and type {}", ar.asProjectVersionRef(), ar.getClassifier(), ar.getType());
                    found = this.modelIO.resolveRawFile(ar);
                }
                result.add(found);
            }
        }
        catch (IOException e) {
            throw new ManipulationException("Unable to parse groovyScripts", e);
        }
        return result;
    }

    void applyGroovyScript(List<Project> projects, Project project, File groovyScript) throws ManipulationException {
        InvocationStage stage;
        Script script;
        GroovyShell shell = new GroovyShell();
        try {
            script = shell.parse(groovyScript);
            InvocationPoint invocationPoint = script.getClass().getAnnotation(InvocationPoint.class);
            if (invocationPoint != null) {
                this.logger.debug("InvocationPoint is {}", (Object)invocationPoint.invocationPoint());
                stage = invocationPoint.invocationPoint();
            } else {
                stage = null;
            }
            if (stage == null) {
                throw new ManipulationException("Mandatory annotation '@InvocationPoint(invocationPoint = ' not declared", new Object[0]);
            }
            if (!(script instanceof BaseScript)) {
                throw new ManipulationException("Cannot cast {} to a BaseScript to set values", groovyScript);
            }
            InvocationStage currentStage = stage == InvocationStage.ALL ? InvocationStage.valueOf(this.getExecutionIndex()) : stage;
            ((BaseScript)script).setValues(this.pomIO, this.fileIO, this.modelIO, this.session, projects, project, currentStage);
        }
        catch (MissingMethodException e) {
            try {
                this.logger.error("Failure when injecting into script {}", (Object)FileUtils.readFileToString(groovyScript, StandardCharsets.UTF_8), (Object)e);
            }
            catch (IOException e1) {
                this.logger.error("Unable to read script file {} for debugging!", (Object)groovyScript, (Object)e1);
            }
            throw new ManipulationException("Unable to inject values into base script", e);
        }
        catch (CompilationFailedException e) {
            try {
                this.logger.error("Failure when parsing script {}", (Object)FileUtils.readFileToString(groovyScript, StandardCharsets.UTF_8), (Object)e);
            }
            catch (IOException e1) {
                this.logger.error("Unable to read script file {} for debugging!", (Object)groovyScript, (Object)e1);
            }
            throw new ManipulationException("Unable to parse script", e);
        }
        catch (IOException e) {
            throw new ManipulationException("Unable to parse script", e);
        }
        if (this.getExecutionIndex() == stage.getStageValue() || stage == InvocationStage.ALL) {
            try {
                this.logger.info("Executing {} on {} at invocation point {}", new Object[]{groovyScript, project, stage});
                script.run();
                this.logger.info("Completed {}", (Object)groovyScript);
            }
            catch (Exception e) {
                if (e instanceof ManipulationException) {
                    throw (ManipulationException)e;
                }
                throw new ManipulationException("Problem running script", e);
            }
        } else {
            this.logger.debug("Ignoring script {} as invocation point {} does not match index {}", new Object[]{groovyScript, stage, this.getExecutionIndex()});
        }
    }
}

