/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.transport.htcli;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Alternative;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.io.AbstractTransferDecorator;
import org.commonjava.maven.galley.model.SpecialPathInfo;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.spi.io.SpecialPathManager;
import org.commonjava.maven.galley.transport.htcli.model.HttpExchangeMetadataFromRequestHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Alternative
public class UploadMetadataGenTransferDecorator
extends AbstractTransferDecorator {
    private static final Logger logger = LoggerFactory.getLogger(UploadMetadataGenTransferDecorator.class);
    private SpecialPathManager specialPathManager;

    public UploadMetadataGenTransferDecorator(SpecialPathManager specialPathManager) {
        this.specialPathManager = specialPathManager;
    }

    @Override
    public OutputStream decorateWrite(OutputStream stream, Transfer transfer, TransferOperation op, EventMetadata metadata) throws IOException {
        SpecialPathInfo specialPathInfo = this.specialPathManager.getSpecialPathInfo(transfer, metadata.getPackageType());
        Boolean isMetadata = specialPathInfo != null && specialPathInfo.isMetadata();
        Boolean isUpload = op == TransferOperation.UPLOAD;
        Boolean hasRequestHeaders = metadata.get("store-http-headers") != null && metadata.get("store-http-headers") instanceof Map;
        if (isUpload.booleanValue() && !isMetadata.booleanValue() && hasRequestHeaders.booleanValue()) {
            Map storeHttpHeaders = (Map)metadata.get("store-http-headers");
            this.writeMetadata(transfer, new ObjectMapper(), storeHttpHeaders);
        }
        return super.decorateWrite(stream, transfer, op, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMetadata(Transfer target, final ObjectMapper mapper, Map<String, List<String>> requestHeaders) {
        Transfer metaTxfr = target.getSiblingMeta(".http-metadata.json");
        if (metaTxfr == null) {
            if (target.isDirectory()) {
                logger.trace("DIRECTORY. Using HTTP exchange metadata file INSIDE directory called: {}", (Object)".http-metadata.json");
                metaTxfr = target.getChild(".http-metadata.json");
            } else {
                logger.trace("SKIP: Cannot retrieve HTTP exchange metadata Transfer instance for: {}", (Object)target);
                return;
            }
        }
        final HttpExchangeMetadataFromRequestHeader metadata = new HttpExchangeMetadataFromRequestHeader(requestHeaders);
        OutputStream out = null;
        try {
            final Transfer finalMeta = metaTxfr;
            out = metaTxfr.openOutputStream(TransferOperation.GENERATE, false);
            logger.trace("Writing HTTP exchange metadata:\n\n{}\n\n", new Object(){

                public String toString() {
                    try {
                        return mapper.writeValueAsString(metadata);
                    }
                    catch (JsonProcessingException e) {
                        logger.warn(String.format("Failed to write HTTP exchange metadata: %s. Reason: %s", finalMeta, e.getMessage()), e);
                        return "ERROR RENDERING METADATA";
                    }
                }
            });
            out.write(mapper.writeValueAsBytes(metadata));
        }
        catch (IOException e) {
            block8: {
                try {
                    if (logger.isTraceEnabled()) {
                        logger.trace(String.format("Failed to write metadata for HTTP exchange to: %s. Reason: %s", metaTxfr, e.getMessage()), e);
                        break block8;
                    }
                    logger.warn("Failed to write metadata for HTTP exchange to: {}. Reason: {}", (Object)metaTxfr, (Object)e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(out);
        }
        IOUtils.closeQuietly(out);
    }
}

