/*
 * Decompiled with CFR 0.152.
 */
package org.goots.logback.core.util;

import org.goots.logback.core.Context;
import org.goots.logback.core.spi.ContextAwareBase;

public class InterruptUtil
extends ContextAwareBase {
    final boolean previouslyInterrupted;

    public InterruptUtil(Context context) {
        this.setContext(context);
        this.previouslyInterrupted = Thread.currentThread().isInterrupted();
    }

    public void maskInterruptFlag() {
        if (this.previouslyInterrupted) {
            Thread.interrupted();
        }
    }

    public void unmaskInterruptFlag() {
        if (this.previouslyInterrupted) {
            try {
                Thread.currentThread().interrupt();
            }
            catch (SecurityException se) {
                this.addError("Failed to intrreupt current thread", se);
            }
        }
    }
}

