/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.utils.StringChecker;
import java.util.Iterator;

public class JsonNodeUtil {
    private static final String TYPE = "type";
    private static final String ENUM = "enum";
    private static final String REF = "$ref";
    private static final String NULLABLE = "nullable";

    public static boolean isNodeNullable(JsonNode schema) {
        JsonNode nullable = schema.get(NULLABLE);
        return nullable != null && nullable.asBoolean();
    }

    public static boolean isNodeNullable(JsonNode schema, SchemaValidatorsConfig config) {
        if (config.isHandleNullableField()) {
            return JsonNodeUtil.isNodeNullable(schema);
        }
        return false;
    }

    public static boolean isChildNodeNullable(ArrayNode oneOfSchemaNode, SchemaValidatorsConfig config) {
        Iterator<JsonNode> iterator = oneOfSchemaNode.elements();
        while (iterator.hasNext()) {
            if (!JsonNodeUtil.isNodeNullable(iterator.next(), config)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchOneOfTypeNode(JsonNode oneOfSchemaNode, JsonType nodeType) {
        Iterator<JsonNode> iterator = oneOfSchemaNode.elements();
        while (iterator.hasNext()) {
            JsonNode oneOfTypeNode = iterator.next();
            JsonNode typeTextNode = oneOfTypeNode.get(TYPE);
            if (typeTextNode == null || !typeTextNode.asText().equals(nodeType.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean equalsToSchemaType(JsonNode node, JsonSchema schema, SchemaValidatorsConfig config) {
        JsonType schemaType = JsonNodeUtil.getSchemaJsonType(schema);
        return JsonNodeUtil.equalsToSchemaType(node, schemaType, schema.getParentSchema(), config);
    }

    public static JsonType getSchemaJsonType(JsonSchema schema) {
        JsonNode typeNode = schema.getSchemaNode().get(TYPE);
        if (typeNode != null) {
            return JsonType.valueOf(typeNode.asText().toUpperCase());
        }
        return JsonType.UNKNOWN;
    }

    public static boolean equalsToSchemaType(JsonNode node, JsonType schemaType, JsonSchema parentSchema, SchemaValidatorsConfig config) {
        JsonType nodeType = TypeFactory.getValueNodeType(node, config);
        if (nodeType != schemaType) {
            if (schemaType == JsonType.ANY) {
                return true;
            }
            if (schemaType == JsonType.NUMBER && nodeType == JsonType.INTEGER) {
                return true;
            }
            if (JsonType.NULL.equals((Object)nodeType) && parentSchema != null && (parentSchema.getParentSchema() != null && JsonNodeUtil.isNodeNullable(parentSchema.getParentSchema().getSchemaNode(), config) || JsonNodeUtil.isNodeNullable(parentSchema.getSchemaNode()))) {
                return true;
            }
            if (JsonNodeUtil.isEnumObjectSchema(parentSchema)) {
                return true;
            }
            if (config != null && config.isTypeLoose()) {
                if (schemaType == JsonType.ARRAY) {
                    return true;
                }
                if (nodeType == JsonType.STRING && (schemaType == JsonType.INTEGER ? StringChecker.isInteger(node.textValue()) : (schemaType == JsonType.BOOLEAN ? StringChecker.isBoolean(node.textValue()) : schemaType == JsonType.NUMBER && StringChecker.isNumeric(node.textValue())))) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public static boolean isNumber(JsonNode node, SchemaValidatorsConfig config) {
        if (node.isNumber()) {
            return true;
        }
        if (config.isTypeLoose() && TypeFactory.getValueNodeType(node, config) == JsonType.STRING) {
            return StringChecker.isNumeric(node.textValue());
        }
        return false;
    }

    private static boolean isEnumObjectSchema(JsonSchema jsonSchema) {
        JsonNode typeNode = null;
        JsonNode enumNode = null;
        JsonNode refNode = null;
        if (jsonSchema != null) {
            if (jsonSchema.getSchemaNode() != null) {
                typeNode = jsonSchema.getSchemaNode().get(TYPE);
                enumNode = jsonSchema.getSchemaNode().get(ENUM);
            }
            if (jsonSchema.getParentSchema() != null && jsonSchema.getParentSchema().getSchemaNode() != null) {
                refNode = jsonSchema.getParentSchema().getSchemaNode().get(REF);
            }
        }
        if (typeNode != null && enumNode != null && refNode != null) {
            return TypeFactory.getSchemaNodeType(typeNode) == JsonType.OBJECT && enumNode.isArray();
        }
        return false;
    }
}

