/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.maven.shared.release.AbstractReleaseRequest;
import org.apache.maven.shared.release.ReleaseBranchRequest;
import org.apache.maven.shared.release.ReleaseCleanRequest;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseFailureException;
import org.apache.maven.shared.release.ReleaseManager;
import org.apache.maven.shared.release.ReleaseManagerListener;
import org.apache.maven.shared.release.ReleasePerformRequest;
import org.apache.maven.shared.release.ReleasePrepareRequest;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.ReleaseRollbackRequest;
import org.apache.maven.shared.release.ReleaseUpdateVersionsRequest;
import org.apache.maven.shared.release.config.ReleaseDescriptorBuilder;
import org.apache.maven.shared.release.config.ReleaseDescriptorStore;
import org.apache.maven.shared.release.config.ReleaseDescriptorStoreException;
import org.apache.maven.shared.release.config.ReleaseUtils;
import org.apache.maven.shared.release.phase.ReleasePhase;
import org.apache.maven.shared.release.phase.ResourceGenerator;
import org.apache.maven.shared.release.strategy.Strategy;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

@Component(role=ReleaseManager.class)
public class DefaultReleaseManager
extends AbstractLogEnabled
implements ReleaseManager {
    @Requirement
    private Map<String, Strategy> strategies;
    @Requirement
    private Map<String, ReleasePhase> releasePhases;
    @Requirement(hint="properties")
    private ReleaseDescriptorStore configStore;
    private static final int PHASE_SKIP = 0;
    private static final int PHASE_START = 1;
    private static final int PHASE_END = 2;
    private static final int GOAL_END = 12;
    private static final int ERROR = 99;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReleaseResult prepareWithResult(ReleasePrepareRequest prepareRequest) {
        ReleaseResult result = new ReleaseResult();
        result.setStartTime(System.currentTimeMillis());
        try {
            this.prepare(prepareRequest, result);
            result.setResultCode(0);
        }
        catch (ReleaseExecutionException | ReleaseFailureException e) {
            this.captureException(result, prepareRequest.getReleaseManagerListener(), e);
        }
        finally {
            result.setEndTime(System.currentTimeMillis());
        }
        return result;
    }

    @Override
    public void prepare(ReleasePrepareRequest prepareRequest) throws ReleaseExecutionException, ReleaseFailureException {
        this.prepare(prepareRequest, new ReleaseResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepare(ReleasePrepareRequest prepareRequest, ReleaseResult result) throws ReleaseExecutionException, ReleaseFailureException {
        final ReleaseDescriptorBuilder builder = prepareRequest.getReleaseDescriptorBuilder();
        ReleaseUtils.copyPropertiesToReleaseDescriptor(prepareRequest.getUserProperties(), new ReleaseDescriptorBuilder(){

            @Override
            public ReleaseDescriptorBuilder addDevelopmentVersion(String key, String value) {
                builder.addDevelopmentVersion(key, value);
                return this;
            }

            @Override
            public ReleaseDescriptorBuilder addReleaseVersion(String key, String value) {
                builder.addReleaseVersion(key, value);
                return this;
            }

            @Override
            public ReleaseDescriptorBuilder addDependencyReleaseVersion(String dependencyKey, String version) {
                builder.addDependencyReleaseVersion(dependencyKey, version);
                return this;
            }

            @Override
            public ReleaseDescriptorBuilder addDependencyDevelopmentVersion(String dependencyKey, String version) {
                builder.addDependencyDevelopmentVersion(dependencyKey, version);
                return this;
            }
        });
        ReleaseDescriptorBuilder.BuilderReleaseDescriptor config = BooleanUtils.isNotFalse(prepareRequest.getResume()) ? this.loadReleaseDescriptor(builder, prepareRequest.getReleaseManagerListener()) : ReleaseUtils.buildReleaseDescriptor(builder);
        Strategy releaseStrategy = this.getStrategy(config.getReleaseStrategyId());
        List<String> preparePhases = this.getGoalPhases(releaseStrategy, "prepare");
        this.goalStart(prepareRequest.getReleaseManagerListener(), "prepare", preparePhases);
        String completedPhase = config.getCompletedPhase();
        int index = preparePhases.indexOf(completedPhase);
        for (int idx = 0; idx <= index; ++idx) {
            this.updateListener(prepareRequest.getReleaseManagerListener(), preparePhases.get(idx), 0);
        }
        if (index == preparePhases.size() - 1) {
            this.logInfo(result, "Release preparation already completed. You can now continue with release:perform, or start again using the -Dresume=false flag");
        } else if (index >= 0) {
            this.logInfo(result, "Resuming release from phase '" + preparePhases.get(index + 1) + "'");
        }
        for (int i = index + 1; i < preparePhases.size(); ++i) {
            String name = preparePhases.get(i);
            ReleasePhase phase = this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            this.updateListener(prepareRequest.getReleaseManagerListener(), name, 1);
            ReleaseResult phaseResult = null;
            try {
                phaseResult = BooleanUtils.isTrue(prepareRequest.getDryRun()) ? phase.simulate(config, prepareRequest.getReleaseEnvironment(), prepareRequest.getReactorProjects()) : phase.execute(config, prepareRequest.getReleaseEnvironment(), prepareRequest.getReactorProjects());
            }
            finally {
                if (result != null && phaseResult != null) {
                    result.appendOutput(phaseResult.getOutput());
                }
            }
            config.setCompletedPhase(name);
            try {
                this.configStore.write(config);
            }
            catch (ReleaseDescriptorStoreException e) {
                throw new ReleaseExecutionException("Error writing release properties after completing phase", e);
            }
            this.updateListener(prepareRequest.getReleaseManagerListener(), name, 2);
        }
        this.updateListener(prepareRequest.getReleaseManagerListener(), "prepare", 12);
    }

    @Override
    public void rollback(ReleaseRollbackRequest rollbackRequest) throws ReleaseExecutionException, ReleaseFailureException {
        ReleaseDescriptorBuilder.BuilderReleaseDescriptor releaseDescriptor = this.loadReleaseDescriptor(rollbackRequest.getReleaseDescriptorBuilder(), null);
        Strategy releaseStrategy = this.getStrategy(releaseDescriptor.getReleaseStrategyId());
        List<String> rollbackPhases = this.getGoalPhases(releaseStrategy, "rollback");
        this.goalStart(rollbackRequest.getReleaseManagerListener(), "rollback", rollbackPhases);
        for (String name : rollbackPhases) {
            ReleasePhase phase = this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            this.updateListener(rollbackRequest.getReleaseManagerListener(), name, 1);
            phase.execute(releaseDescriptor, rollbackRequest.getReleaseEnvironment(), rollbackRequest.getReactorProjects());
            this.updateListener(rollbackRequest.getReleaseManagerListener(), name, 2);
        }
        this.clean(rollbackRequest);
        this.updateListener(rollbackRequest.getReleaseManagerListener(), "rollback", 12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReleaseResult performWithResult(ReleasePerformRequest performRequest) {
        ReleaseResult result = new ReleaseResult();
        try {
            result.setStartTime(System.currentTimeMillis());
            this.perform(performRequest, result);
            result.setResultCode(0);
        }
        catch (ReleaseExecutionException | ReleaseFailureException e) {
            this.captureException(result, performRequest.getReleaseManagerListener(), e);
        }
        finally {
            result.setEndTime(System.currentTimeMillis());
        }
        return result;
    }

    @Override
    public void perform(ReleasePerformRequest performRequest) throws ReleaseExecutionException, ReleaseFailureException {
        this.perform(performRequest, new ReleaseResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void perform(ReleasePerformRequest performRequest, ReleaseResult result) throws ReleaseExecutionException, ReleaseFailureException {
        List<String> specificProfiles = ReleaseUtils.buildReleaseDescriptor(performRequest.getReleaseDescriptorBuilder()).getActivateProfiles();
        ReleaseDescriptorBuilder builder = this.loadReleaseDescriptorBuilder(performRequest.getReleaseDescriptorBuilder(), performRequest.getReleaseManagerListener());
        if (specificProfiles != null && !specificProfiles.isEmpty()) {
            ArrayList<String> allProfiles = new ArrayList<String>();
            allProfiles.addAll(ReleaseUtils.buildReleaseDescriptor(builder).getActivateProfiles());
            for (String specificProfile : specificProfiles) {
                if (allProfiles.contains(specificProfile)) continue;
                allProfiles.add(specificProfile);
            }
            builder.setActivateProfiles(allProfiles);
        }
        ReleaseDescriptorBuilder.BuilderReleaseDescriptor releaseDescriptor = ReleaseUtils.buildReleaseDescriptor(builder);
        Strategy releaseStrategy = this.getStrategy(releaseDescriptor.getReleaseStrategyId());
        List<String> performPhases = this.getGoalPhases(releaseStrategy, "perform");
        this.goalStart(performRequest.getReleaseManagerListener(), "perform", performPhases);
        for (String name : performPhases) {
            ReleasePhase phase = this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            this.updateListener(performRequest.getReleaseManagerListener(), name, 1);
            ReleaseResult phaseResult = null;
            try {
                phaseResult = BooleanUtils.isTrue(performRequest.getDryRun()) ? phase.simulate(releaseDescriptor, performRequest.getReleaseEnvironment(), performRequest.getReactorProjects()) : phase.execute(releaseDescriptor, performRequest.getReleaseEnvironment(), performRequest.getReactorProjects());
            }
            finally {
                if (result != null && phaseResult != null) {
                    result.appendOutput(phaseResult.getOutput());
                }
            }
            this.updateListener(performRequest.getReleaseManagerListener(), name, 2);
        }
        if (BooleanUtils.isNotFalse(performRequest.getClean())) {
            this.clean(performRequest);
        }
        this.updateListener(performRequest.getReleaseManagerListener(), "perform", 12);
    }

    @Override
    public void branch(ReleaseBranchRequest branchRequest) throws ReleaseExecutionException, ReleaseFailureException {
        final ReleaseDescriptorBuilder builder = branchRequest.getReleaseDescriptorBuilder();
        ReleaseUtils.copyPropertiesToReleaseDescriptor(branchRequest.getUserProperties(), new ReleaseDescriptorBuilder(){

            @Override
            public ReleaseDescriptorBuilder addDevelopmentVersion(String key, String value) {
                builder.addDevelopmentVersion(key, value);
                return this;
            }

            @Override
            public ReleaseDescriptorBuilder addReleaseVersion(String key, String value) {
                builder.addReleaseVersion(key, value);
                return this;
            }
        });
        ReleaseDescriptorBuilder.BuilderReleaseDescriptor releaseDescriptor = this.loadReleaseDescriptor(builder, branchRequest.getReleaseManagerListener());
        boolean dryRun = BooleanUtils.isTrue(branchRequest.getDryRun());
        Strategy releaseStrategy = this.getStrategy(releaseDescriptor.getReleaseStrategyId());
        List<String> branchPhases = this.getGoalPhases(releaseStrategy, "branch");
        this.goalStart(branchRequest.getReleaseManagerListener(), "branch", branchPhases);
        for (String name : branchPhases) {
            ReleasePhase phase = this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            this.updateListener(branchRequest.getReleaseManagerListener(), name, 1);
            if (dryRun) {
                phase.simulate(releaseDescriptor, branchRequest.getReleaseEnvironment(), branchRequest.getReactorProjects());
            } else {
                phase.execute(releaseDescriptor, branchRequest.getReleaseEnvironment(), branchRequest.getReactorProjects());
            }
            this.updateListener(branchRequest.getReleaseManagerListener(), name, 2);
        }
        if (!dryRun) {
            this.clean(branchRequest);
        }
        this.updateListener(branchRequest.getReleaseManagerListener(), "branch", 12);
    }

    @Override
    public void updateVersions(ReleaseUpdateVersionsRequest updateVersionsRequest) throws ReleaseExecutionException, ReleaseFailureException {
        final ReleaseDescriptorBuilder builder = updateVersionsRequest.getReleaseDescriptorBuilder();
        ReleaseUtils.copyPropertiesToReleaseDescriptor(updateVersionsRequest.getUserProperties(), new ReleaseDescriptorBuilder(){

            @Override
            public ReleaseDescriptorBuilder addDevelopmentVersion(String key, String value) {
                builder.addDevelopmentVersion(key, value);
                return this;
            }

            @Override
            public ReleaseDescriptorBuilder addReleaseVersion(String key, String value) {
                builder.addReleaseVersion(key, value);
                return this;
            }
        });
        ReleaseDescriptorBuilder.BuilderReleaseDescriptor releaseDescriptor = this.loadReleaseDescriptor(builder, updateVersionsRequest.getReleaseManagerListener());
        Strategy releaseStrategy = this.getStrategy(releaseDescriptor.getReleaseStrategyId());
        List<String> updateVersionsPhases = this.getGoalPhases(releaseStrategy, "updateVersions");
        this.goalStart(updateVersionsRequest.getReleaseManagerListener(), "updateVersions", updateVersionsPhases);
        for (String name : updateVersionsPhases) {
            ReleasePhase phase = this.releasePhases.get(name);
            if (phase == null) {
                throw new ReleaseExecutionException("Unable to find phase '" + name + "' to execute");
            }
            this.updateListener(updateVersionsRequest.getReleaseManagerListener(), name, 1);
            phase.execute(releaseDescriptor, updateVersionsRequest.getReleaseEnvironment(), updateVersionsRequest.getReactorProjects());
            this.updateListener(updateVersionsRequest.getReleaseManagerListener(), name, 2);
        }
        this.clean(updateVersionsRequest);
        this.updateListener(updateVersionsRequest.getReleaseManagerListener(), "updateVersions", 12);
    }

    protected File determineWorkingDirectory(File checkoutDirectory, String relativePathProjectDirectory) {
        if (StringUtils.isNotEmpty(relativePathProjectDirectory)) {
            return new File(checkoutDirectory, relativePathProjectDirectory);
        }
        return checkoutDirectory;
    }

    private ReleaseDescriptorBuilder.BuilderReleaseDescriptor loadReleaseDescriptor(ReleaseDescriptorBuilder builder, ReleaseManagerListener listener) throws ReleaseExecutionException {
        return ReleaseUtils.buildReleaseDescriptor(this.loadReleaseDescriptorBuilder(builder, listener));
    }

    private ReleaseDescriptorBuilder loadReleaseDescriptorBuilder(ReleaseDescriptorBuilder builder, ReleaseManagerListener listener) throws ReleaseExecutionException {
        try {
            this.updateListener(listener, "verify-release-configuration", 1);
            ReleaseDescriptorBuilder result = this.configStore.read(builder);
            this.updateListener(listener, "verify-release-configuration", 2);
            return result;
        }
        catch (ReleaseDescriptorStoreException e) {
            this.updateListener(listener, e.getMessage(), 99);
            throw new ReleaseExecutionException("Error reading stored configuration: " + e.getMessage(), e);
        }
    }

    protected void clean(AbstractReleaseRequest releaseRequest) throws ReleaseFailureException {
        ReleaseCleanRequest cleanRequest = new ReleaseCleanRequest();
        cleanRequest.setReleaseDescriptorBuilder(releaseRequest.getReleaseDescriptorBuilder());
        cleanRequest.setReleaseManagerListener(releaseRequest.getReleaseManagerListener());
        cleanRequest.setReactorProjects(releaseRequest.getReactorProjects());
        this.clean(cleanRequest);
    }

    @Override
    public void clean(ReleaseCleanRequest cleanRequest) throws ReleaseFailureException {
        this.updateListener(cleanRequest.getReleaseManagerListener(), "cleanup", 1);
        this.getLogger().info("Cleaning up after release...");
        ReleaseDescriptorBuilder.BuilderReleaseDescriptor releaseDescriptor = ReleaseUtils.buildReleaseDescriptor(cleanRequest.getReleaseDescriptorBuilder());
        this.configStore.delete(releaseDescriptor);
        Strategy releaseStrategy = this.getStrategy(releaseDescriptor.getReleaseStrategyId());
        LinkedHashSet<String> phases = new LinkedHashSet<String>();
        phases.addAll(this.getGoalPhases(releaseStrategy, "prepare"));
        phases.addAll(this.getGoalPhases(releaseStrategy, "branch"));
        for (String name : phases) {
            ReleasePhase phase = this.releasePhases.get(name);
            if (!(phase instanceof ResourceGenerator)) continue;
            ((ResourceGenerator)((Object)phase)).clean(cleanRequest.getReactorProjects());
        }
        this.updateListener(cleanRequest.getReleaseManagerListener(), "cleanup", 2);
    }

    void setConfigStore(ReleaseDescriptorStore configStore) {
        this.configStore = configStore;
    }

    void goalStart(ReleaseManagerListener listener, String goal, List<String> phases) {
        if (listener != null) {
            listener.goalStart(goal, phases);
        }
    }

    void updateListener(ReleaseManagerListener listener, String name, int state) {
        if (listener != null) {
            switch (state) {
                case 12: {
                    listener.goalEnd();
                    break;
                }
                case 0: {
                    listener.phaseSkip(name);
                    break;
                }
                case 1: {
                    listener.phaseStart(name);
                    break;
                }
                case 2: {
                    listener.phaseEnd();
                    break;
                }
                default: {
                    listener.error(name);
                }
            }
        }
    }

    private Strategy getStrategy(String strategyId) throws ReleaseFailureException {
        Strategy strategy = this.strategies.get(strategyId);
        if (strategy == null) {
            throw new ReleaseFailureException("Unknown strategy: " + strategyId);
        }
        return strategy;
    }

    private List<String> getGoalPhases(Strategy strategy, String goal) {
        List<String> phases;
        if ("prepare".equals(goal)) {
            phases = strategy.getPreparePhases();
            if (phases == null) {
                phases = this.strategies.get("default").getPreparePhases();
            }
        } else if ("perform".equals(goal)) {
            phases = strategy.getPerformPhases();
            if (phases == null) {
                phases = this.strategies.get("default").getPerformPhases();
            }
        } else if ("rollback".equals(goal)) {
            phases = strategy.getRollbackPhases();
            if (phases == null) {
                phases = this.strategies.get("default").getRollbackPhases();
            }
        } else if ("branch".equals(goal)) {
            phases = strategy.getBranchPhases();
            if (phases == null) {
                phases = this.strategies.get("default").getBranchPhases();
            }
        } else if ("updateVersions".equals(goal)) {
            phases = strategy.getUpdateVersionsPhases();
            if (phases == null) {
                phases = this.strategies.get("default").getUpdateVersionsPhases();
            }
        } else {
            phases = null;
        }
        return Collections.unmodifiableList(phases);
    }

    private void logInfo(ReleaseResult result, String message) {
        if (result != null) {
            result.appendInfo(message);
        }
        this.getLogger().info(message);
    }

    private void captureException(ReleaseResult result, ReleaseManagerListener listener, Exception e) {
        this.updateListener(listener, e.getMessage(), 99);
        result.appendError(e);
        result.setResultCode(1);
    }
}

