/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.ext.core.impl;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Profile;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.commonjava.maven.atlas.ident.ref.ArtifactRef;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.ext.common.ManipulationException;
import org.commonjava.maven.ext.common.model.Project;
import org.commonjava.maven.ext.common.model.SimpleScopedArtifactRef;
import org.commonjava.maven.ext.common.util.ProfileUtils;
import org.commonjava.maven.ext.common.util.WildcardMap;
import org.commonjava.maven.ext.core.ManipulationSession;
import org.commonjava.maven.ext.core.impl.Manipulator;
import org.commonjava.maven.ext.core.state.RelocationState;
import org.commonjava.maven.ext.core.util.PropertiesUtils;
import org.commonjava.maven.ext.io.resolver.GalleyAPIWrapper;
import org.commonjava.maven.galley.maven.parse.GalleyMavenXMLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Named(value="relocations-manipulator")
@Singleton
public class RelocationManipulator
implements Manipulator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final GalleyAPIWrapper galleyWrapper;
    private ManipulationSession session;

    @Inject
    public RelocationManipulator(GalleyAPIWrapper galleyWrapper) {
        this.galleyWrapper = galleyWrapper;
    }

    @Override
    public void init(ManipulationSession session) throws ManipulationException {
        this.session = session;
        session.setState(new RelocationState(session.getUserProperties()));
    }

    @Override
    public Set<Project> applyChanges(List<Project> projects) throws ManipulationException {
        RelocationState state = this.session.getState(RelocationState.class);
        if (!this.session.isEnabled() || !state.isEnabled()) {
            this.logger.debug("{}: Nothing to do!", (Object)this.getClass().getSimpleName());
            return Collections.emptySet();
        }
        HashSet<Project> changed = new HashSet<Project>();
        for (Project project : projects) {
            Model model;
            if (!this.apply(project, model = project.getModel())) continue;
            changed.add(project);
        }
        return changed;
    }

    private boolean apply(Project project, Model model) throws ManipulationException {
        boolean result = false;
        RelocationState state = this.session.getState(RelocationState.class);
        WildcardMap<ProjectVersionRef> dependencyRelocations = state.getDependencyRelocations();
        WildcardMap<ProjectVersionRef> pluginRelocations = state.getPluginRelocations();
        this.logger.debug("Applying relocation changes for dependencies ({}) and for plugins ({}) to: {}:{}", dependencyRelocations, pluginRelocations, project.getGroupId(), project.getArtifactId());
        DependencyManagement dependencyManagement = model.getDependencyManagement();
        if (dependencyManagement != null) {
            result = this.updateDependencies(project, dependencyRelocations, project.getResolvedManagedDependencies(this.session));
        }
        result |= this.updateDependencies(project, dependencyRelocations, project.getAllResolvedDependencies(this.session));
        for (Profile profile : ProfileUtils.getProfiles(this.session, model)) {
            dependencyManagement = profile.getDependencyManagement();
            if (dependencyManagement != null) {
                result |= this.updateDependencies(project, dependencyRelocations, project.getResolvedProfileManagedDependencies(this.session).get(profile));
            }
            result |= this.updateDependencies(project, dependencyRelocations, project.getAllResolvedProfileDependencies(this.session).get(profile));
        }
        result |= this.updatePlugins(pluginRelocations, dependencyRelocations, project, project.getResolvedManagedPlugins(this.session));
        result |= this.updatePlugins(pluginRelocations, dependencyRelocations, project, project.getAllResolvedPlugins(this.session));
        for (Profile profile : project.getAllResolvedProfilePlugins(this.session).keySet()) {
            result |= this.updatePlugins(pluginRelocations, dependencyRelocations, project, project.getAllResolvedProfilePlugins(this.session).get(profile));
        }
        for (Profile profile : project.getResolvedProfileManagedPlugins(this.session).keySet()) {
            result |= this.updatePlugins(pluginRelocations, dependencyRelocations, project, project.getResolvedProfileManagedPlugins(this.session).get(profile));
        }
        return result;
    }

    private boolean updateDependencies(Project project, WildcardMap<ProjectVersionRef> relocations, Map<ArtifactRef, Dependency> dependencies) throws ManipulationException {
        HashMap<SimpleScopedArtifactRef, Dependency> postFixUp = new HashMap<SimpleScopedArtifactRef, Dependency>();
        boolean result = false;
        for (int i = 0; i < relocations.size(); ++i) {
            Iterator<ArtifactRef> it = dependencies.keySet().iterator();
            while (it.hasNext()) {
                ArtifactRef pvr = it.next();
                if (!relocations.containsKey(pvr.asProjectRef())) continue;
                ProjectVersionRef relocation = relocations.get(pvr.asProjectRef());
                Dependency dependency = dependencies.get(pvr);
                this.logger.info("For dependency {}, replacing groupId {} by {} and artifactId {} with {}", dependency, dependency.getGroupId(), relocation.getGroupId(), dependency.getArtifactId(), relocation.getArtifactId());
                if (!relocation.getArtifactId().equals("*")) {
                    this.updateString(project, dependency.getArtifactId(), relocation, relocation.getArtifactId(), d -> dependency.setArtifactId(relocation.getArtifactId()));
                }
                if (relocation.getVersionString().equals("*")) {
                    this.logger.debug("No version alignment to perform for relocation {}", (Object)relocation);
                } else {
                    this.updateString(project, dependency.getVersion(), relocation, relocation.getVersionString(), d -> dependency.setVersion(relocation.getVersionString()));
                }
                this.updateString(project, dependency.getGroupId(), relocation, relocation.getGroupId(), d -> dependency.setGroupId(relocation.getGroupId()));
                postFixUp.put(new SimpleScopedArtifactRef(dependency), dependency);
                it.remove();
                result = true;
            }
            dependencies.putAll(postFixUp);
            postFixUp.clear();
        }
        return result;
    }

    private boolean updatePlugins(WildcardMap<ProjectVersionRef> pluginRelocations, WildcardMap<ProjectVersionRef> dependencyRelocations, Project project, Map<ProjectVersionRef, Plugin> pluginMap) throws ManipulationException {
        ProjectVersionRef relocation;
        int i;
        HashMap<SimpleProjectVersionRef, Plugin> postFixUp = new HashMap<SimpleProjectVersionRef, Plugin>();
        boolean result = false;
        List<PluginReference> refs = this.findPluginReferences(project, pluginMap);
        int size = dependencyRelocations.size();
        for (i = 0; i < size; ++i) {
            for (PluginReference pluginReference : refs) {
                Dependency dependency = new Dependency();
                dependency.setGroupId(pluginReference.groupIdNode.getTextContent());
                dependency.setArtifactId(pluginReference.artifactIdNode.getTextContent());
                relocation = dependencyRelocations.get(dependency);
                if (relocation == null) continue;
                this.updateString(project, pluginReference.groupIdNode.getTextContent(), relocation, relocation.getGroupId(), d -> pluginReference.groupIdNode.setTextContent(relocation.getGroupId()));
                if (!relocation.getArtifactId().equals("*")) {
                    this.updateString(project, pluginReference.artifactIdNode.getTextContent(), relocation, relocation.getArtifactId(), d -> pluginReference.artifactIdNode.setTextContent(relocation.getArtifactId()));
                }
                if (pluginReference.versionNode != null) {
                    if (relocation.getVersionString().equals("*")) {
                        this.logger.debug("No version alignment to perform for relocation {}", (Object)relocation);
                    } else {
                        this.updateString(project, pluginReference.versionNode.getTextContent(), relocation, relocation.getVersionString(), d -> pluginReference.versionNode.setTextContent(relocation.getVersionString()));
                    }
                }
                pluginReference.container.setConfiguration(this.getConfigXml(pluginReference.groupIdNode));
                this.logger.debug("Update plugin: set {} to {}", (Object)relocation, (Object)pluginReference);
                result = true;
            }
        }
        for (i = 0; i < pluginRelocations.size(); ++i) {
            Iterator<ProjectVersionRef> it = pluginMap.keySet().iterator();
            while (it.hasNext()) {
                ProjectVersionRef pvr = it.next();
                if (!pluginRelocations.containsKey(pvr.asProjectRef())) continue;
                Plugin plugin = pluginMap.get(pvr);
                relocation = pluginRelocations.get(pvr.asProjectRef());
                this.logger.info("For plugin {}, replacing groupId {} by {} and artifactId {} with {}", plugin.getId(), plugin.getGroupId(), relocation.getGroupId(), plugin.getArtifactId(), relocation.getArtifactId());
                if (!relocation.getArtifactId().equals("*")) {
                    this.updateString(project, plugin.getArtifactId(), relocation, relocation.getArtifactId(), d -> plugin.setArtifactId(relocation.getArtifactId()));
                }
                if (relocation.getVersionString().equals("*")) {
                    this.logger.debug("No version alignment to perform for relocation {}", (Object)relocation);
                } else {
                    this.updateString(project, plugin.getVersion(), relocation, relocation.getVersionString(), d -> plugin.setVersion(relocation.getVersionString()));
                }
                this.updateString(project, plugin.getGroupId(), relocation, relocation.getGroupId(), d -> plugin.setGroupId(relocation.getGroupId()));
                postFixUp.put(new SimpleProjectVersionRef(plugin.getGroupId(), plugin.getArtifactId(), StringUtils.isEmpty(plugin.getVersion()) ? "*" : plugin.getVersion()), plugin);
                it.remove();
                result = true;
            }
            pluginMap.putAll(postFixUp);
            postFixUp.clear();
        }
        return result;
    }

    private void updateString(Project project, String originalValue, ProjectVersionRef originalRelocation, String relocation, Consumer<String> c) throws ManipulationException {
        if (StringUtils.contains(originalValue, "$")) {
            if (StringUtils.countMatches(originalValue = originalValue.substring(2, originalValue.length() - 1), "${") > 1) {
                throw new ManipulationException("Relocations with multiple embedded version properties not supported", new Object[0]);
            }
            this.logger.debug("Updating relocation for {} with property {} to new value {}", originalRelocation, originalValue, relocation);
            PropertiesUtils.updateProperties(this.session, project, true, originalValue, relocation);
        } else {
            c.accept(relocation);
        }
    }

    private PluginReference findPluginReference(ConfigurationContainer container, Node parent) {
        if (parent == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        int length = children.getLength();
        this.logger.debug("Update child nodes for {} with {} children", (Object)parent.getNodeName(), (Object)length);
        Node groupIdNode = null;
        Node artifactIdNode = null;
        Node versionNode = null;
        block10: for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            switch (node.getNodeName()) {
                case "groupId": {
                    groupIdNode = node;
                    continue block10;
                }
                case "artifactId": {
                    artifactIdNode = node;
                    continue block10;
                }
                case "version": {
                    versionNode = node;
                }
            }
        }
        if (groupIdNode != null && artifactIdNode != null) {
            PluginReference ref = new PluginReference(container, groupIdNode, artifactIdNode, versionNode);
            this.logger.debug("Found plugin reference: {}", (Object)ref);
            return ref;
        }
        return null;
    }

    private List<PluginReference> findPluginReferences(Map.Entry<ConfigurationContainer, String> entry, NodeList children) {
        int length = children.getLength();
        this.logger.debug("Got {} children to update plugin GAVs", (Object)length);
        ArrayList<PluginReference> refs = new ArrayList<PluginReference>(length);
        for (int i = 0; i < length; ++i) {
            Node node = children.item(i);
            this.logger.debug("Child name is {} and text content is {}", (Object)node.getNodeName(), (Object)node.getTextContent());
            PluginReference ref = this.findPluginReference(entry.getKey(), node);
            if (ref == null) continue;
            refs.add(ref);
        }
        return refs;
    }

    private List<PluginReference> findPluginReferences(Project project, Map<ProjectVersionRef, Plugin> pluginMap) throws ManipulationException {
        Collection<Plugin> plugins = pluginMap.values();
        ArrayList<PluginReference> refs = new ArrayList<PluginReference>();
        for (Plugin plugin : plugins) {
            Map<ConfigurationContainer, String> configs = this.findConfigurations(plugin);
            this.logger.debug("Found {} configs for plugin {}:{}:{}", configs.size(), plugin.getGroupId(), plugin.getArtifactId(), plugin.getVersion());
            for (Map.Entry<ConfigurationContainer, String> entry : configs.entrySet()) {
                try {
                    Document doc = this.galleyWrapper.parseXml(entry.getValue());
                    XPath xPath = XPathFactory.newInstance().newXPath();
                    PluginReference ref = this.findPluginReference(entry.getKey(), doc.getFirstChild());
                    if (ref != null) {
                        refs.add(ref);
                    }
                    NodeList artifactItems = (NodeList)xPath.evaluate(".//artifactItems/*", doc, XPathConstants.NODESET);
                    List<PluginReference> artifactItemRefs = this.findPluginReferences(entry, artifactItems);
                    refs.addAll(artifactItemRefs);
                }
                catch (GalleyMavenXMLException e) {
                    throw new ManipulationException("Unable to parse config for plugin {} in {}", plugin.getId(), project.getKey(), e);
                }
                catch (XPathExpressionException e) {
                    throw new ManipulationException("Invalid XPath expression for plugin {} in {}", plugin.getId(), project.getKey(), e);
                }
            }
        }
        return refs;
    }

    private Map<ConfigurationContainer, String> findConfigurations(Plugin plugin) {
        List<PluginExecution> executions;
        if (plugin == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<ConfigurationContainer, String> configs = new LinkedHashMap<ConfigurationContainer, String>();
        Object pluginConfiguration = plugin.getConfiguration();
        if (pluginConfiguration != null) {
            configs.put(plugin, pluginConfiguration.toString());
        }
        if ((executions = plugin.getExecutions()) != null) {
            for (PluginExecution execution : executions) {
                Object executionConfiguration = execution.getConfiguration();
                if (executionConfiguration == null) continue;
                configs.put(execution, executionConfiguration.toString());
            }
        }
        return configs;
    }

    private Xpp3Dom getConfigXml(Node node) throws ManipulationException {
        String config = this.galleyWrapper.toXML(node.getOwnerDocument(), false).trim();
        try {
            return Xpp3DomBuilder.build(new StringReader(config));
        }
        catch (IOException | XmlPullParserException e) {
            throw new ManipulationException("Failed to re-parse plugin configuration into Xpp3Dom: {}. Config was: {}", e.getMessage(), config, e);
        }
    }

    @Override
    public int getExecutionIndex() {
        return 7;
    }

    private static final class PluginReference {
        private final ConfigurationContainer container;
        private final Node groupIdNode;
        private final Node artifactIdNode;
        private final Node versionNode;

        PluginReference(ConfigurationContainer container, Node groupIdNode, Node artifactIdNode, Node versionNode) {
            this.container = container;
            this.groupIdNode = groupIdNode;
            this.artifactIdNode = artifactIdNode;
            this.versionNode = versionNode;
        }

        public String toString() {
            return "PluginReference{container=" + this.container + this.nodeToString(this.groupIdNode) + this.nodeToString(this.artifactIdNode) + this.nodeToString(this.versionNode) + '}';
        }

        private String nodeToString(Node node) {
            return node == null ? "" : ", [" + node.getNodeName() + "=" + node.getTextContent() + "]";
        }
    }
}

