/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.util.jhttpc.INTERNAL.conn;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpClientConnection;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.commonjava.util.jhttpc.INTERNAL.conn.SiteConnectionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseBlockingConnectionManager
implements HttpClientConnectionManager,
Closeable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SiteConnectionConfig config;
    private final PoolingHttpClientConnectionManager connectionManager;

    public CloseBlockingConnectionManager(SiteConnectionConfig config, PoolingHttpClientConnectionManager connectionManager) {
        this.config = config;
        this.connectionManager = connectionManager;
    }

    @Override
    public ConnectionRequest requestConnection(HttpRoute route, Object state) {
        this.logger.trace("Requesting connection to: {} with state: {}", (Object)route, state);
        ConnectionRequest request = this.connectionManager.requestConnection(route, state);
        this.logger.trace("Connection request is: {}", (Object)request);
        return request;
    }

    @Override
    public void releaseConnection(HttpClientConnection conn, Object newState, long validDuration, TimeUnit timeUnit) {
        this.logger.trace("Releasing connection: {} with new state: {}", (Object)conn, newState);
        this.connectionManager.releaseConnection(conn, newState, validDuration, timeUnit);
    }

    @Override
    public void connect(HttpClientConnection conn, HttpRoute route, int connectTimeout, HttpContext context) throws IOException {
        this.logger.trace("Connecting: {} via route: {}", (Object)conn, (Object)route);
        this.connectionManager.connect(conn, route, connectTimeout, context);
    }

    @Override
    public void upgrade(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
        this.logger.trace("Upgrading: {} via route: {}", (Object)conn, (Object)route);
        this.connectionManager.upgrade(conn, route, context);
    }

    @Override
    public void routeComplete(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
        this.logger.trace("Route complete: {} with route: {}", (Object)conn, (Object)route);
        this.connectionManager.routeComplete(conn, route, context);
    }

    @Override
    public void closeIdleConnections(long idletime, TimeUnit tunit) {
        this.logger.trace("Closing idle connections");
        this.connectionManager.closeIdleConnections(idletime, tunit);
    }

    @Override
    public void closeExpiredConnections() {
        this.logger.trace("Closing expired connections");
        this.connectionManager.closeExpiredConnections();
    }

    @Override
    public void shutdown() {
        this.logger.trace("BLOCKED connection-manager shutdown; connection pool is reusable.\n\n{}\n\n", (Object)this);
    }

    public void reallyShutdown() {
        this.logger.trace("REALLY shutting down connection manager");
        this.connectionManager.shutdown();
    }

    @Override
    public void close() throws IOException {
        this.reallyShutdown();
    }

    public String toString() {
        return "CloseBlockingConnectionManager{\nconfig=" + this.config + "\nconnectionManager=" + this.connectionManager + "\ninstance=" + super.hashCode() + "\nstats=" + this.connectionManager == null ? "NONE" : this.connectionManager.getTotalStats() + "\n}";
    }
}

