/*
 * Decompiled with CFR 0.152.
 */
package org.goots.logback.classic.pattern;

import org.goots.logback.classic.LoggerContext;
import org.goots.logback.classic.pattern.ExtendedThrowableProxyConverter;
import org.goots.logback.classic.pattern.ThrowableHandlingConverter;
import org.goots.logback.classic.pattern.ThrowableProxyConverter;
import org.goots.logback.classic.spi.ILoggingEvent;
import org.goots.logback.core.Context;
import org.goots.logback.core.pattern.Converter;
import org.goots.logback.core.pattern.ConverterUtil;
import org.goots.logback.core.pattern.PostCompileProcessor;

public class EnsureExceptionHandling
implements PostCompileProcessor<ILoggingEvent> {
    @Override
    public void process(Context context, Converter<ILoggingEvent> head) {
        if (head == null) {
            throw new IllegalArgumentException("cannot process empty chain");
        }
        if (!this.chainHandlesThrowable(head)) {
            Converter<ILoggingEvent> tail = ConverterUtil.findTail(head);
            ThrowableProxyConverter exConverter = null;
            LoggerContext loggerContext = (LoggerContext)context;
            exConverter = loggerContext.isPackagingDataEnabled() ? new ExtendedThrowableProxyConverter() : new ThrowableProxyConverter();
            tail.setNext(exConverter);
        }
    }

    public boolean chainHandlesThrowable(Converter<ILoggingEvent> head) {
        for (Converter<ILoggingEvent> c = head; c != null; c = c.getNext()) {
            if (!(c instanceof ThrowableHandlingConverter)) continue;
            return true;
        }
        return false;
    }
}

