/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channeltools.resolver;

import java.io.File;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.ssl.SSLContexts;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.AuthenticationDigest;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.version.Version;
import org.jboss.logging.Logger;
import org.wildfly.channel.ArtifactCoordinate;
import org.wildfly.channel.UnresolvedMavenArtifactException;
import org.wildfly.channel.spi.MavenVersionsResolver;

public class DefaultMavenVersionsResolver
implements MavenVersionsResolver {
    public static final Logger logger = Logger.getLogger(DefaultMavenVersionsResolver.class);
    private static final File NULL_FILE = new File("/dev/null");
    private static final String LOCAL_MAVEN_REPO = System.getProperty("user.home") + "/.m2/repository";
    private final RepositorySystem system;
    private final DefaultRepositorySystemSession session;
    private final List<RemoteRepository> remoteRepositories;
    private final String localRepositoryPath;
    private final boolean disableTlsVerification;

    DefaultMavenVersionsResolver(List<String> remoteRepositoryUrls, String localRepositoryPath, boolean disableTlsVerification) {
        this.disableTlsVerification = disableTlsVerification;
        this.localRepositoryPath = Objects.requireNonNullElse(localRepositoryPath, LOCAL_MAVEN_REPO);
        this.remoteRepositories = new ArrayList<RemoteRepository>(remoteRepositoryUrls.size());
        for (int i = 0; i < remoteRepositoryUrls.size(); ++i) {
            SSLContext sslcontext;
            logger.debugf("Adding remote repository %s", (Object)remoteRepositoryUrls.get(i));
            try {
                sslcontext = SSLContexts.custom().loadTrustMaterial(null, (chain, authType) -> true).build();
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException("Couldn't build SSLContext", e);
            }
            RemoteRepository.Builder remoteRepositoryBuilder = new RemoteRepository.Builder("repo-" + i, "default", remoteRepositoryUrls.get(i));
            if (this.disableTlsVerification) {
                remoteRepositoryBuilder.setAuthentication(new AuthenticationBuilder().addHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).addCustom(new Authentication(){

                    public void fill(AuthenticationContext context, String key, Map<String, String> data) {
                        context.put("ssl.context", (Object)sslcontext);
                    }

                    public void digest(AuthenticationDigest digest) {
                        digest.update(new String[]{"ssl.context", sslcontext.getClass().getName()});
                    }
                }).build());
            }
            this.remoteRepositories.add(remoteRepositoryBuilder.build());
        }
        this.system = this.newRepositorySystem();
        this.session = this.newRepositorySystemSession();
    }

    public Set<String> getAllVersions(String groupId, String artifactId, String extension, String classifier) {
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
        logger.debugf("Resolving the latest version of %s:%s in repositories: %s", (Object)groupId, (Object)artifactId, (Object)this.remoteRepositories.stream().map(RemoteRepository::getUrl).collect(Collectors.joining(",")));
        DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, extension, "[0,)");
        VersionRangeRequest versionRangeRequest = new VersionRangeRequest();
        versionRangeRequest.setArtifact((Artifact)artifact);
        versionRangeRequest.setRepositories(this.remoteRepositories);
        try {
            VersionRangeResult versionRangeResult = this.system.resolveVersionRange((RepositorySystemSession)this.session, versionRangeRequest);
            Set<String> versions = versionRangeResult.getVersions().stream().map(Version::toString).collect(Collectors.toSet());
            DefaultMavenVersionsResolver.reportExceptions(versionRangeResult);
            logger.debugf("All versions in the repositories: %s", versions);
            return versions;
        }
        catch (VersionRangeResolutionException e) {
            return Collections.emptySet();
        }
    }

    public File resolveArtifact(String groupId, String artifactId, String extension, String classifier, String version) {
        return NULL_FILE;
    }

    public List<File> resolveArtifacts(List<ArtifactCoordinate> list) throws UnresolvedMavenArtifactException {
        throw new NotImplementedException("Not implemented");
    }

    private static void reportExceptions(VersionRangeResult versionRangeResult) {
        List exceptions;
        if (versionRangeResult.getExceptions() != null && (exceptions = versionRangeResult.getExceptions().stream().filter(e -> !(e instanceof MetadataNotFoundException)).collect(Collectors.toList())).size() > 0) {
            Artifact artifact = versionRangeResult.getRequest().getArtifact();
            logger.warnf("Error when resolving %s:%s versions, printing exceptions bellow:", (Object)artifact.getGroupId(), (Object)artifact.getArtifactId());
            for (Exception e2 : exceptions) {
                logger.warn((Object)e2);
            }
        }
    }

    private DefaultRepositorySystemSession newRepositorySystemSession() {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(this.localRepositoryPath);
        session.setLocalRepositoryManager(this.system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setOffline(false);
        return session;
    }

    public RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                throw new RuntimeException("Failed to initiate maven repository system");
            }
        });
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }
}

