/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui;

import com.sun.tools.jconsole.JConsoleContext;
import com.sun.tools.jconsole.JConsolePlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServerConnection;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.GuiMain;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.impl.ExistingChannelModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.Connection;
import org.jboss.remotingjmx.RemotingMBeanServerConnection;
import org.jboss.threads.JBossThreadFactory;
import org.wildfly.security.manager.GetAccessControlContextAction;
import org.xnio.IoFuture;
import org.xnio.OptionMap;

public class JConsoleCLIPlugin
extends JConsolePlugin {
    private static final int DEFAULT_MAX_THREADS = 6;
    private static final AtomicInteger executorCount = new AtomicInteger();
    CliGuiContext cliGuiCtx;
    private JPanel jconsolePanel;
    private boolean initComplete = false;
    private boolean isConnected = false;

    @Override
    public Map<String, JPanel> getTabs() {
        CommandContext cmdCtx;
        HashMap<String, JPanel> panelMap = new HashMap<String, JPanel>();
        try {
            cmdCtx = CommandContextFactory.getInstance().newCommandContext();
            this.isConnected = this.connectCommandContext(cmdCtx);
            if (!this.isConnected) {
                return panelMap;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error connecting to JBoss AS.", e);
        }
        this.cliGuiCtx = GuiMain.startEmbedded(cmdCtx);
        JPanel cliGuiPanel = this.cliGuiCtx.getMainPanel();
        this.jconsolePanel = new JPanel(new BorderLayout());
        this.jconsolePanel.add((Component)GuiMain.makeMenuBar(this.cliGuiCtx), "North");
        this.jconsolePanel.add((Component)cliGuiPanel, "Center");
        panelMap.put(this.getJBossServerName(), this.jconsolePanel);
        return panelMap;
    }

    private boolean connectCommandContext(CommandContext cmdCtx) throws Exception {
        JConsoleContext jcCtx = this.getContext();
        MBeanServerConnection mbeanServerConn = jcCtx.getMBeanServerConnection();
        if (mbeanServerConn instanceof RemotingMBeanServerConnection) {
            return this.connectUsingRemoting(cmdCtx, (RemotingMBeanServerConnection)mbeanServerConn);
        }
        try {
            cmdCtx.connectController("http-remoting", "localhost", 9990);
        }
        catch (Exception e) {
            String message = "CLI GUI unable to connect to JBoss AS with localhost:9999 \n";
            message = message + "Go to Connection -> New Connection and enter a Remote Process \n";
            message = message + "of the form service:jmx:remoting-jmx://{host_name}:{port}  where \n";
            message = message + "{host_name} and {port} are the address of the native management \n";
            message = message + "interface of the AS7 installation being monitored.";
            JOptionPane.showMessageDialog(null, message);
            return false;
        }
        return true;
    }

    private boolean connectUsingRemoting(CommandContext cmdCtx, RemotingMBeanServerConnection rmtMBeanSvrConn) throws IOException, CliInitializationException {
        Connection conn = rmtMBeanSvrConn.getConnection();
        IoFuture<Channel> futureChannel = conn.openChannel("management", OptionMap.EMPTY);
        IoFuture.Status result = futureChannel.await(5L, TimeUnit.SECONDS);
        if (result != IoFuture.Status.DONE) {
            return false;
        }
        Channel channel = futureChannel.get();
        ModelControllerClient modelCtlrClient = ExistingChannelModelControllerClient.createReceiving(channel, this.createExecutor());
        cmdCtx.bindClient(modelCtlrClient);
        return true;
    }

    private ExecutorService createExecutor() {
        ThreadGroup group = new ThreadGroup("management-client-thread");
        JBossThreadFactory threadFactory = new JBossThreadFactory(group, Boolean.FALSE, null, "%G " + executorCount.incrementAndGet() + "-%t", null, null, AccessController.doPrivileged(GetAccessControlContextAction.getInstance()));
        return new ThreadPoolExecutor(2, 6, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    @Override
    public SwingWorker<?, ?> newSwingWorker() {
        if (!this.initComplete && this.isConnected) {
            this.initComplete = true;
            this.configureMyJInternalFrame();
        }
        return null;
    }

    private void configureMyJInternalFrame() {
        ImageIcon icon = new ImageIcon(GuiMain.getJBossIcon());
        Container component = this.jconsolePanel;
        while (component != null) {
            if (!((component = component.getParent()) instanceof JInternalFrame)) continue;
            JInternalFrame frame = (JInternalFrame)component;
            frame.setFrameIcon(icon);
            return;
        }
    }

    private String getJBossServerName() {
        String serverNamePrefix = "JBoss CLI / ";
        String serverNameCommand = "/:read-attribute(name=name,include-defaults=true)";
        if (!this.cliGuiCtx.isStandalone()) {
            serverNameCommand = "/host=*" + serverNameCommand;
        }
        try {
            ModelNode result = this.cliGuiCtx.getExecutor().doCommand(serverNameCommand);
            String outcome = result.get("outcome").asString();
            if (outcome.equals("success") && this.cliGuiCtx.isStandalone()) {
                return serverNamePrefix + result.get("result").asString();
            }
            if (outcome.equals("success")) {
                return serverNamePrefix + result.get("result").asList().get(0).get("result").asString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serverNamePrefix + "<unknown>";
    }
}

