/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.jboss.logging.Logger;
import org.xnio.Buffers;
import org.xnio.IoUtils;
import org.xnio.Pooled;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.TranslatingSuspendableChannel;

public class FramedMessageChannel
extends TranslatingSuspendableChannel<ConnectedMessageChannel, ConnectedStreamChannel>
implements ConnectedMessageChannel {
    private static final Logger log = Logger.getLogger("org.xnio.channels.framed");
    private final Pooled<ByteBuffer> receiveBuffer;
    private final Pooled<ByteBuffer> transmitBuffer;

    public FramedMessageChannel(ConnectedStreamChannel channel, ByteBuffer receiveBuffer, ByteBuffer transmitBuffer) {
        super(channel);
        this.receiveBuffer = Buffers.pooledWrapper(receiveBuffer);
        this.transmitBuffer = Buffers.pooledWrapper(transmitBuffer);
        log.tracef("Created new framed message channel around %s, receive buffer %s, transmit buffer %s", (Object)channel, (Object)receiveBuffer, (Object)transmitBuffer);
    }

    public FramedMessageChannel(ConnectedStreamChannel channel, Pooled<ByteBuffer> receiveBuffer, Pooled<ByteBuffer> transmitBuffer) {
        super(channel);
        this.receiveBuffer = receiveBuffer;
        this.transmitBuffer = transmitBuffer;
        log.tracef("Created new framed message channel around %s, receive buffer %s, transmit buffer %s", (Object)channel, (Object)receiveBuffer, (Object)transmitBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int receive(ByteBuffer buffer) throws IOException {
        Pooled<ByteBuffer> pooled = this.receiveBuffer;
        synchronized (pooled) {
            int res;
            if (this.isReadShutDown()) {
                return -1;
            }
            ByteBuffer receiveBuffer = this.receiveBuffer.getResource();
            ConnectedStreamChannel channel = (ConnectedStreamChannel)this.channel;
            while ((res = channel.read(receiveBuffer)) > 0) {
            }
            if (receiveBuffer.position() < 4) {
                if (res == -1) {
                    receiveBuffer.clear();
                }
                log.tracef("Did not read a length", new Object[0]);
                this.clearReadReady();
                return res;
            }
            receiveBuffer.flip();
            try {
                int length = receiveBuffer.getInt();
                if (length < 0 || length > receiveBuffer.capacity() - 4) {
                    Buffers.unget(receiveBuffer, 4);
                    throw new IOException("Received an invalid message length of " + length);
                }
                if (receiveBuffer.remaining() < length) {
                    if (res == -1) {
                        receiveBuffer.clear();
                    } else {
                        Buffers.unget(receiveBuffer, 4);
                        receiveBuffer.compact();
                    }
                    log.tracef("Did not read enough bytes for a full message", new Object[0]);
                    this.clearReadReady();
                    int n = res;
                    return n;
                }
                if (buffer.hasRemaining()) {
                    log.tracef("Copying message from %s into %s", (Object)receiveBuffer, (Object)buffer);
                    Buffers.copy(buffer, Buffers.slice(receiveBuffer, length));
                } else {
                    log.tracef("Not copying message from %s into full buffer %s", (Object)receiveBuffer, (Object)buffer);
                    Buffers.skip(receiveBuffer, length);
                }
                receiveBuffer.compact();
                int n = length;
                return n;
            }
            finally {
                if (res != -1 && receiveBuffer.position() >= 4 && receiveBuffer.position() >= 4 + receiveBuffer.getInt(0)) {
                    this.setReadReady();
                }
            }
        }
    }

    @Override
    public long receive(ByteBuffer[] buffers) throws IOException {
        return this.receive(buffers, 0, buffers.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long receive(ByteBuffer[] buffers, int offs, int len) throws IOException {
        Pooled<ByteBuffer> pooled = this.receiveBuffer;
        synchronized (pooled) {
            int res;
            if (this.isReadShutDown()) {
                return -1L;
            }
            ByteBuffer receiveBuffer = this.receiveBuffer.getResource();
            ConnectedStreamChannel channel = (ConnectedStreamChannel)this.channel;
            while ((res = channel.read(receiveBuffer)) > 0) {
            }
            if (receiveBuffer.position() < 4) {
                if (res == -1) {
                    receiveBuffer.clear();
                }
                log.tracef("Did not read a length", new Object[0]);
                this.clearReadReady();
                return res;
            }
            receiveBuffer.flip();
            try {
                int length = receiveBuffer.getInt();
                if (length < 0 || length > receiveBuffer.capacity() - 4) {
                    Buffers.unget(receiveBuffer, 4);
                    throw new IOException("Received an invalid message length of " + length);
                }
                if (receiveBuffer.remaining() < length) {
                    if (res == -1) {
                        receiveBuffer.clear();
                    } else {
                        Buffers.unget(receiveBuffer, 4);
                        receiveBuffer.compact();
                    }
                    log.tracef("Did not read enough bytes for a full message", new Object[0]);
                    this.clearReadReady();
                    long l = res;
                    return l;
                }
                if (Buffers.hasRemaining(buffers)) {
                    log.tracef("Copying message from %s into multiple buffers", (Object)receiveBuffer);
                    Buffers.copy(buffers, offs, len, Buffers.slice(receiveBuffer, length));
                } else {
                    log.tracef("Not copying message from %s into multiple full buffers", (Object)receiveBuffer);
                    Buffers.skip(receiveBuffer, length);
                }
                receiveBuffer.compact();
                long l = length;
                return l;
            }
            finally {
                if (res != -1 && receiveBuffer.position() >= 4 && receiveBuffer.position() >= 4 + receiveBuffer.getInt(0)) {
                    this.setReadReady();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void shutdownReadsAction(boolean writeComplete) throws IOException {
        Pooled<ByteBuffer> pooled = this.receiveBuffer;
        synchronized (pooled) {
            log.tracef("Shutting down reads on %s", (Object)this);
            try {
                this.receiveBuffer.getResource().clear();
            }
            catch (Throwable t) {
                // empty catch block
            }
            try {
                this.receiveBuffer.free();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ((ConnectedStreamChannel)this.channel).shutdownReads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(ByteBuffer buffer) throws IOException {
        Pooled<ByteBuffer> pooled = this.transmitBuffer;
        synchronized (pooled) {
            if (this.isWriteShutDown()) {
                throw new EOFException("Writes have been shut down");
            }
            if (!buffer.hasRemaining()) {
                return true;
            }
            ByteBuffer transmitBuffer = this.transmitBuffer.getResource();
            int remaining = buffer.remaining();
            if (remaining > transmitBuffer.capacity() - 4) {
                throw new IOException("Transmitted message is too large");
            }
            log.tracef("Accepting %s into %s", (Object)buffer, (Object)transmitBuffer);
            if (transmitBuffer.remaining() < 4 + remaining && !this.doFlushBuffer()) {
                log.tracef("Insufficient room to accept %s into %s", (Object)buffer, (Object)transmitBuffer);
                return false;
            }
            transmitBuffer.putInt(remaining);
            transmitBuffer.put(buffer);
            log.tracef("Accepted a message into %s", (Object)transmitBuffer);
            this.doFlush();
            return true;
        }
    }

    @Override
    public boolean send(ByteBuffer[] buffers) throws IOException {
        return this.send(buffers, 0, buffers.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(ByteBuffer[] buffers, int offs, int len) throws IOException {
        Pooled<ByteBuffer> pooled = this.transmitBuffer;
        synchronized (pooled) {
            if (this.isWriteShutDown()) {
                throw new EOFException("Writes have been shut down");
            }
            if (!Buffers.hasRemaining(buffers, offs, len)) {
                return true;
            }
            ByteBuffer transmitBuffer = this.transmitBuffer.getResource();
            long remaining = Buffers.remaining(buffers, offs, len);
            if (remaining > (long)transmitBuffer.capacity() - 4L) {
                throw new IOException("Transmitted message is too large");
            }
            log.tracef("Accepting multiple buffers into %s", (Object)transmitBuffer);
            if ((long)transmitBuffer.remaining() < 4L + remaining && !this.doFlushBuffer()) {
                log.tracef("Insufficient room to accept multiple buffers into %s", (Object)transmitBuffer);
                return false;
            }
            transmitBuffer.putInt((int)remaining);
            Buffers.copy(transmitBuffer, buffers, offs, len);
            log.tracef("Accepted a message into %s", (Object)transmitBuffer);
            this.doFlush();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean flushAction(boolean shutDown) throws IOException {
        Pooled<ByteBuffer> pooled = this.transmitBuffer;
        synchronized (pooled) {
            return this.doFlushBuffer() && ((ConnectedStreamChannel)this.channel).flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void shutdownWritesComplete(boolean readShutDown) throws IOException {
        Pooled<ByteBuffer> pooled = this.transmitBuffer;
        synchronized (pooled) {
            log.tracef("Finished shutting down writes on %s", (Object)this);
            try {
                this.transmitBuffer.free();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        ((ConnectedStreamChannel)this.channel).shutdownWrites();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doFlushBuffer() throws IOException {
        assert (Thread.holdsLock(this.transmitBuffer));
        ByteBuffer buffer = this.transmitBuffer.getResource();
        buffer.flip();
        try {
            while (buffer.hasRemaining()) {
                int res = ((ConnectedStreamChannel)this.channel).write(buffer);
                if (res != 0) continue;
                log.tracef("Did not fully flush %s", (Object)this);
                boolean bl = false;
                return bl;
            }
            log.tracef("Fully flushed %s", (Object)this);
            boolean bl = true;
            return bl;
        }
        finally {
            buffer.compact();
        }
    }

    private boolean doFlush() throws IOException {
        return this.doFlushBuffer() && ((ConnectedStreamChannel)this.channel).flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeAction(boolean readShutDown, boolean writeShutDown) throws IOException {
        Pooled<ByteBuffer> pooled;
        boolean error = false;
        if (!writeShutDown) {
            pooled = this.transmitBuffer;
            synchronized (pooled) {
                try {
                    if (!this.doFlush()) {
                        error = true;
                    }
                }
                catch (Throwable t) {
                    error = true;
                }
                try {
                    this.transmitBuffer.free();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        if (!readShutDown) {
            pooled = this.receiveBuffer;
            synchronized (pooled) {
                try {
                    this.receiveBuffer.free();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        try {
            if (error) {
                throw new IOException("Unflushed data truncated");
            }
            ((ConnectedStreamChannel)this.channel).close();
        }
        finally {
            IoUtils.safeClose((Closeable)this.channel);
        }
    }

    @Override
    public SocketAddress getPeerAddress() {
        return ((ConnectedStreamChannel)this.channel).getPeerAddress();
    }

    @Override
    public <A extends SocketAddress> A getPeerAddress(Class<A> type) {
        return ((ConnectedStreamChannel)this.channel).getPeerAddress(type);
    }

    @Override
    public SocketAddress getLocalAddress() {
        return ((ConnectedStreamChannel)this.channel).getLocalAddress();
    }

    @Override
    public <A extends SocketAddress> A getLocalAddress(Class<A> type) {
        return ((ConnectedStreamChannel)this.channel).getLocalAddress(type);
    }

    @Override
    public ConnectedStreamChannel getChannel() {
        return (ConnectedStreamChannel)this.channel;
    }
}

