/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.cli.impl.CLIModelControllerClient;
import org.jboss.as.controller.client.ModelControllerClient;

public interface ModelControllerClientFactory {
    public static final String SASL_DISALLOWED_MECHANISMS = "SASL_DISALLOWED_MECHANISMS";
    public static final String JBOSS_LOCAL_USER = "JBOSS-LOCAL-USER";
    public static final Map<String, String> DISABLED_LOCAL_AUTH = Collections.singletonMap("SASL_DISALLOWED_MECHANISMS", "JBOSS-LOCAL-USER");
    public static final Map<String, String> ENABLED_LOCAL_AUTH = Collections.emptyMap();
    public static final ModelControllerClientFactory DEFAULT = new ModelControllerClientFactory(){

        @Override
        public ModelControllerClient getClient(String protocol, String hostName, int port, CallbackHandler handler, boolean disableLocalAuth, SSLContext sslContext, int connectionTimeout, ConnectionCloseHandler closeHandler) throws IOException {
            Map saslOptions = disableLocalAuth ? DISABLED_LOCAL_AUTH : ENABLED_LOCAL_AUTH;
            return ModelControllerClient.Factory.create(protocol, hostName, port, handler, sslContext, connectionTimeout, saslOptions);
        }
    };
    public static final ModelControllerClientFactory CUSTOM = new ModelControllerClientFactory(){

        @Override
        public ModelControllerClient getClient(String protocol, String hostName, int port, CallbackHandler handler, boolean disableLocalAuth, SSLContext sslContext, int connectionTimeout, ConnectionCloseHandler closeHandler) throws IOException {
            Map saslOptions = disableLocalAuth ? DISABLED_LOCAL_AUTH : ENABLED_LOCAL_AUTH;
            return new CLIModelControllerClient(protocol, handler, hostName, connectionTimeout, closeHandler, port, saslOptions, sslContext);
        }
    };

    public ModelControllerClient getClient(String var1, String var2, int var3, CallbackHandler var4, boolean var5, SSLContext var6, int var7, ConnectionCloseHandler var8) throws IOException;

    public static interface ConnectionCloseHandler {
        public void handleClose();
    }
}

