/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import java.util.logging.Formatter;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.handlers.SslTcpOutputStream;
import org.jboss.logmanager.handlers.TcpOutputStream;
import org.jboss.logmanager.handlers.UdpOutputStream;

public class SyslogHandler
extends ExtHandler {
    public static final InetAddress DEFAULT_ADDRESS;
    public static final int DEFAULT_PORT = 514;
    public static final int DEFAULT_SECURE_PORT = 6514;
    public static final String DEFAULT_ENCODING = "UTF-8";
    public static final Facility DEFAULT_FACILITY;
    public static final String NILVALUE_SP = "- ";
    private static final byte[] UTF_8_BOM;
    private final Object outputLock = new Object();
    private InetAddress serverAddress;
    private int port;
    private String appName;
    private String hostname;
    private Facility facility;
    private SyslogType syslogType;
    private final String pid;
    private OutputStream out;
    private Protocol protocol;
    private boolean useCountingFraming;
    private boolean initializeConnection;
    private boolean outputStreamSet;
    private String delimiter;
    private boolean useDelimiter;
    private boolean escapeEnabled;
    private boolean truncate;
    private int maxLen;

    public SyslogHandler() throws IOException {
        this(DEFAULT_ADDRESS, 514);
    }

    public SyslogHandler(String serverHostname, int port) throws IOException {
        this(serverHostname, port, DEFAULT_FACILITY, null);
    }

    public SyslogHandler(InetAddress serverAddress, int port) throws IOException {
        this(serverAddress, port, DEFAULT_FACILITY, null);
    }

    public SyslogHandler(String serverHostname, int port, Facility facility, String hostname) throws IOException {
        this(serverHostname, port, facility, null, hostname);
    }

    public SyslogHandler(InetAddress serverAddress, int port, Facility facility, String hostname) throws IOException {
        this(serverAddress, port, facility, null, hostname);
    }

    public SyslogHandler(String serverHostname, int port, Facility facility, SyslogType syslogType, String hostname) throws IOException {
        this(InetAddress.getByName(serverHostname), port, facility, syslogType, hostname);
    }

    public SyslogHandler(InetAddress serverAddress, int port, Facility facility, SyslogType syslogType, String hostname) throws IOException {
        this(serverAddress, port, facility, syslogType, null, hostname);
    }

    public SyslogHandler(String serverHostname, int port, Facility facility, SyslogType syslogType, Protocol protocol, String hostname) throws IOException {
        this(InetAddress.getByName(serverHostname), port, facility, syslogType, protocol, hostname);
    }

    public SyslogHandler(InetAddress serverAddress, int port, Facility facility, SyslogType syslogType, Protocol protocol, String hostname) throws IOException {
        this.serverAddress = serverAddress;
        this.port = port;
        this.facility = facility;
        this.pid = SyslogHandler.findPid();
        this.appName = "java";
        this.hostname = hostname;
        SyslogType syslogType2 = this.syslogType = syslogType == null ? SyslogType.RFC5424 : syslogType;
        if (protocol == null) {
            this.protocol = Protocol.UDP;
            this.delimiter = null;
            this.useDelimiter = false;
        } else {
            this.protocol = protocol;
            if (protocol == Protocol.UDP) {
                this.delimiter = null;
                this.useDelimiter = false;
            } else if (protocol == Protocol.TCP || protocol == Protocol.SSL_TCP) {
                this.delimiter = "\n";
                this.useDelimiter = true;
            }
        }
        this.useCountingFraming = false;
        this.initializeConnection = true;
        this.outputStreamSet = false;
        this.escapeEnabled = true;
        this.truncate = true;
        if (this.syslogType == SyslogType.RFC3164) {
            this.maxLen = 1024;
        } else if (this.syslogType == SyslogType.RFC5424) {
            this.maxLen = 2048;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void doPublish(ExtLogRecord record) {
        if (record.getMessage() == null || record.getMessage().isEmpty()) {
            return;
        }
        Object object = this.outputLock;
        synchronized (object) {
            block16: {
                this.init();
                if (this.out == null) {
                    throw new IllegalStateException("The syslog handler has been closed.");
                }
                try {
                    byte[] byArray;
                    byte[] header;
                    if (this.syslogType == SyslogType.RFC3164) {
                        header = this.createRFC3164Header(record);
                    } else if (this.syslogType == SyslogType.RFC5424) {
                        header = this.createRFC5424Header(record);
                    } else {
                        throw new IllegalStateException("The syslog type of '" + (Object)((Object)this.syslogType) + "' is invalid.");
                    }
                    if (this.delimiter == null) {
                        byte[] byArray2 = new byte[1];
                        byArray = byArray2;
                        byArray2[0] = 0;
                    } else {
                        byArray = this.delimiter.getBytes();
                    }
                    byte[] trailer = byArray;
                    int maxMsgLen = this.maxLen - (header.length + (this.useDelimiter ? trailer.length : 0));
                    if (maxMsgLen < 1) {
                        throw new IOException(String.format("The header and delimiter length, %d, is greater than the message length, %d, allows.", header.length + (this.useDelimiter ? trailer.length : 0), this.maxLen));
                    }
                    Formatter formatter = this.getFormatter();
                    String logMsg = formatter != null ? formatter.format(record) : record.getFormattedMessage();
                    ByteOutputStream message = new ByteOutputStream();
                    int offset = message.writeString(logMsg, this.escapeEnabled, maxMsgLen);
                    this.sendMessage(header, message.toByteArray(), trailer);
                    if (this.truncate || offset <= 0) break block16;
                    while (offset > 0) {
                        message.reset();
                        logMsg = logMsg.substring(offset);
                        if (!logMsg.isEmpty()) {
                            offset = message.writeString(logMsg, this.escapeEnabled, maxMsgLen);
                            this.sendMessage(header, message.toByteArray(), trailer);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    this.reportError("Could not write to syslog", e, 1);
                }
            }
        }
        super.doPublish(record);
    }

    private void sendMessage(byte[] header, byte[] message, byte[] trailer) throws IOException {
        ByteOutputStream payload = new ByteOutputStream();
        if (this.useCountingFraming) {
            int len = header.length + message.length + (this.useDelimiter ? trailer.length : 0);
            payload.writeInt(len).writeChar(' ');
        }
        payload.write(header);
        payload.write(message);
        if (this.useDelimiter) {
            payload.write(trailer);
        }
        this.out.write(payload.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.outputLock;
        synchronized (object) {
            SyslogHandler.safeClose(this.out);
            this.out = null;
        }
        super.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.outputLock;
        synchronized (object) {
            SyslogHandler.safeFlush(this.out);
        }
        super.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAppName() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.appName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAppName(String appName) {
        SyslogHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.appName = appName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEscapeEnabled() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.escapeEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEscapeEnabled(boolean escapeEnabled) {
        SyslogHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.escapeEnabled = escapeEnabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPid() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.pid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPort() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.port;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(int port) {
        SyslogHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.port = port;
            this.initializeConnection = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Facility getFacility() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.facility;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFacility(Facility facility) {
        SyslogHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.facility = facility;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHostname() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.hostname;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaxLength() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.maxLen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxLength(int maxLen) {
        SyslogHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.maxLen = maxLen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessageDelimiter() {
        SyslogHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            return this.delimiter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageDelimiter(String delimiter) {
        SyslogHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.delimiter = delimiter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUseMessageDelimiter() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.useDelimiter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseMessageDelimiter(boolean useDelimiter) {
        SyslogHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.useDelimiter = useDelimiter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHostname(String hostname) {
        SyslogHandler.checkAccess(this);
        if (hostname != null && hostname.contains(" ")) {
            throw new IllegalArgumentException(String.format("Host name '%s' is invalid. Whitespace is now allowed in the host name.", hostname));
        }
        Object object = this.outputLock;
        synchronized (object) {
            this.hostname = hostname;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUseCountingFraming() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.useCountingFraming;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUseCountingFraming(boolean useCountingFraming) {
        SyslogHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.useCountingFraming = useCountingFraming;
        }
    }

    public void setServerHostname(String hostname) throws UnknownHostException {
        SyslogHandler.checkAccess(this);
        this.setServerAddress(InetAddress.getByName(hostname));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress getServerAddress() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.serverAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerAddress(InetAddress serverAddress) {
        SyslogHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.serverAddress = serverAddress;
            this.initializeConnection = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyslogType getSyslogType() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.syslogType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSyslogType(SyslogType syslogType) {
        SyslogHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.syslogType = syslogType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Protocol getProtocol() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.protocol;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProtocol(Protocol type) {
        SyslogHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.protocol = type;
            this.initializeConnection = true;
        }
    }

    public void setOutputStream(OutputStream out) {
        this.setOutputStream(out, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTruncate() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.truncate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTruncate(boolean truncate) {
        SyslogHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.truncate = truncate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setOutputStream(OutputStream out, boolean outputStreamSet) {
        SyslogHandler.checkAccess(this);
        OutputStream oldOut = null;
        boolean ok = false;
        try {
            Object object = this.outputLock;
            synchronized (object) {
                this.initializeConnection = false;
                oldOut = this.out;
                if (oldOut != null) {
                    SyslogHandler.safeFlush(oldOut);
                }
                this.out = out;
                ok = true;
                this.outputStreamSet = out != null && outputStreamSet;
            }
        }
        catch (Throwable throwable) {
            SyslogHandler.safeClose(oldOut);
            if (!ok) {
                SyslogHandler.safeClose(out);
            }
            throw throwable;
        }
        SyslogHandler.safeClose(oldOut);
        if (!ok) {
            SyslogHandler.safeClose(out);
        }
    }

    static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void safeFlush(Flushable flushable) {
        if (flushable != null) {
            try {
                flushable.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String findPid() {
        String name;
        String result = name = ManagementFactory.getRuntimeMXBean().getName();
        int index = name.indexOf("@");
        if (index > -1) {
            try {
                result = Integer.toString(Integer.valueOf(name.substring(0, index - 1)));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private void init() {
        if (this.initializeConnection && !this.outputStreamSet) {
            if (this.serverAddress == null || this.port < 0 || this.protocol == null) {
                throw new IllegalStateException("Invalid connection parameters. The port, server address and protocol must be set.");
            }
            this.initializeConnection = false;
            try {
                OutputStream out;
                if (this.protocol == Protocol.TCP) {
                    out = new TcpOutputStream(this.serverAddress, this.port);
                } else if (this.protocol == Protocol.UDP) {
                    out = new UdpOutputStream(this.serverAddress, this.port);
                } else if (this.protocol == Protocol.SSL_TCP) {
                    out = new SslTcpOutputStream(this.serverAddress, this.port);
                } else {
                    throw new IllegalStateException("Invalid protocol: " + (Object)((Object)this.protocol));
                }
                this.setOutputStream(out, false);
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not set " + (Object)((Object)this.protocol) + " output stream.", e);
            }
        }
    }

    protected int calculatePriority(java.util.logging.Level level, Facility facility) {
        Severity severity = Severity.fromLevel(level);
        return facility.octal | severity.code;
    }

    protected byte[] createRFC5424Header(ExtLogRecord record) throws IOException {
        ByteOutputStream buffer = new ByteOutputStream();
        buffer.writeChar('<').writeInt(this.calculatePriority(record.getLevel(), this.facility)).writeChar('>');
        buffer.writeString("1 ");
        long millis = record.getMillis();
        if (millis <= 0L) {
            buffer.writeString(NILVALUE_SP);
        } else {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(millis);
            int month = cal.get(2);
            int day = cal.get(5);
            int hours = cal.get(11);
            int minutes = cal.get(12);
            int seconds = cal.get(13);
            buffer.writeInt(cal.get(1)).writeChar('-');
            if (month < 10) {
                buffer.writeInt(0);
            }
            buffer.writeInt(month + 1).writeChar('-');
            if (day < 10) {
                buffer.writeInt(0);
            }
            buffer.writeInt(day).writeChar('T');
            if (hours < 10) {
                buffer.writeInt(0);
            }
            buffer.writeInt(hours).writeChar(':');
            if (minutes < 10) {
                buffer.writeInt(0);
            }
            buffer.writeInt(minutes).writeChar(':');
            if (seconds < 10) {
                buffer.writeInt(0);
            }
            buffer.writeInt(seconds).writeChar('.');
            int milliseconds = cal.get(14);
            if (milliseconds < 10) {
                buffer.writeInt(0).writeInt(0);
            } else if (milliseconds < 100) {
                buffer.writeInt(0);
            }
            buffer.writeInt(milliseconds);
            int tz = cal.get(15) + cal.get(16);
            if (tz == 0) {
                buffer.writeString("+00:00");
            } else {
                int tzMinutes = tz / 60000;
                if (tzMinutes < 0) {
                    tzMinutes = -tzMinutes;
                    buffer.writeChar('-');
                } else {
                    buffer.writeChar('+');
                }
                int tzHour = tzMinutes / 60;
                tzMinutes -= tzHour * 60;
                if (tzHour < 10) {
                    buffer.writeInt(0);
                }
                buffer.writeInt(tzHour).writeChar(':');
                if (tzMinutes < 10) {
                    buffer.writeInt(0);
                }
                buffer.writeInt(tzMinutes);
            }
            buffer.writeChar(' ');
        }
        if (this.hostname == null) {
            buffer.writeString(NILVALUE_SP);
        } else {
            buffer.writeUSASCII(this.hostname, 255).writeChar(' ');
        }
        if (this.appName == null) {
            buffer.writeString(NILVALUE_SP);
        } else {
            buffer.writeUSASCII(this.appName, 48);
            buffer.writeChar(' ');
        }
        if (this.pid == null) {
            buffer.writeString(NILVALUE_SP);
        } else {
            buffer.writeUSASCII(this.pid, 128);
            buffer.writeChar(' ');
        }
        String msgid = record.getLoggerName();
        if (msgid == null) {
            buffer.writeString(NILVALUE_SP);
        } else if (msgid.isEmpty()) {
            buffer.writeUSASCII("root-logger");
            buffer.writeChar(' ');
        } else {
            buffer.writeUSASCII(msgid, 32);
            buffer.writeChar(' ');
        }
        buffer.writeString(NILVALUE_SP);
        String encoding = this.getEncoding();
        if (encoding == null || DEFAULT_ENCODING.equalsIgnoreCase(encoding)) {
            buffer.write(UTF_8_BOM);
        }
        return buffer.toByteArray();
    }

    protected byte[] createRFC3164Header(ExtLogRecord record) throws IOException {
        ByteOutputStream buffer = new ByteOutputStream();
        buffer.writeChar('<').writeInt(this.calculatePriority(record.getLevel(), this.facility)).writeChar('>');
        long millis = record.getMillis();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis <= 0L ? System.currentTimeMillis() : millis);
        int month = cal.get(2);
        int day = cal.get(5);
        int hours = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        DateFormatSymbols formatSymbols = DateFormatSymbols.getInstance(Locale.ENGLISH);
        buffer.writeString(formatSymbols.getShortMonths()[month]).writeChar(' ');
        if (day < 10) {
            buffer.writeChar(' ');
        }
        buffer.writeInt(day).writeChar(' ');
        if (hours < 10) {
            buffer.writeInt(0);
        }
        buffer.writeInt(hours).writeChar(':');
        if (minutes < 10) {
            buffer.writeInt(0);
        }
        buffer.writeInt(minutes).writeChar(':');
        if (seconds < 10) {
            buffer.writeInt(0);
        }
        buffer.writeInt(seconds);
        buffer.writeChar(' ');
        if (this.hostname == null) {
            buffer.writeString("UNKNOWN_HOSTNAME").writeChar(' ');
        } else {
            buffer.writeString(this.hostname).writeChar(' ');
        }
        if (this.appName != null && this.pid != null) {
            buffer.writeString(this.appName).writeChar('[').writeString(this.pid).writeChar(']').writeString(": ");
        } else if (this.appName != null) {
            buffer.writeString(this.appName).writeString(": ");
        } else if (this.pid != null) {
            buffer.writeChar('[').writeString(this.pid).writeChar(']').writeString(": ");
        }
        return buffer.toByteArray();
    }

    static {
        DEFAULT_FACILITY = Facility.USER_LEVEL;
        try {
            DEFAULT_ADDRESS = InetAddress.getByName("localhost");
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Could not create address to localhost");
        }
        UTF_8_BOM = new byte[]{-17, -69, -65};
    }

    static class ByteOutputStream
    extends ByteArrayOutputStream {
        static final Charset US_ASCII_CHARSET = Charset.forName("US-ASCII");

        ByteOutputStream() {
        }

        public ByteOutputStream writeUSASCII(String s, int maxLen) throws IOException {
            byte[] bytes = s.getBytes(US_ASCII_CHARSET);
            this.write(bytes, 0, Math.min(maxLen, bytes.length));
            return this;
        }

        public ByteOutputStream writeUSASCII(String s) throws IOException {
            this.write(s.getBytes(US_ASCII_CHARSET));
            return this;
        }

        public int writeString(String s, boolean escape, int maxLen) throws IOException {
            int offset = 0;
            int count = 0;
            for (char c : s.toCharArray()) {
                byte[] b = ByteOutputStream.encode(c, escape);
                if ((count += b.length) <= maxLen) {
                    this.write(b);
                    ++offset;
                    continue;
                }
                return offset;
            }
            return -1;
        }

        public ByteOutputStream writeString(String s) throws IOException {
            this.writeString(s, false, s.length());
            return this;
        }

        public ByteOutputStream writeInt(int i) throws IOException {
            return this.writeString(Integer.toString(i));
        }

        public ByteOutputStream writeChar(char c) throws IOException {
            this.write(ByteOutputStream.encode(c, false));
            return this;
        }

        private static byte[] encode(char c, boolean escape) {
            byte[] result;
            if (c >= '\u0000' && c <= '\u007f') {
                if (escape && c >= '\u0000' && c < ' ') {
                    result = new byte[4];
                    result[0] = 35;
                    result[1] = 48;
                    if (c < '\b') {
                        result[2] = 48;
                        result[3] = (byte)((c & 0xFF) + 48);
                    } else {
                        result[2] = (byte)((c >> 3) + 48);
                        result[3] = (byte)((c & 7) + 48);
                    }
                } else {
                    result = new byte[]{(byte)c};
                }
            } else {
                result = c <= '\u07ff' ? new byte[]{(byte)(0xC0 | 0x1F & c >> 6), (byte)(0x80 | 0x3F & c)} : new byte[]{(byte)(0xE0 | 0xF & c >> 12), (byte)(0xC0 | 0x1F & c >> 6), (byte)(0x80 | 0x3F & c)};
            }
            return result;
        }
    }

    public static enum SyslogType {
        RFC5424,
        RFC3164;

    }

    public static enum Facility {
        KERNEL(0, "kernel messages"),
        USER_LEVEL(1, "user-level messages"),
        MAIL_SYSTEM(2, "mail system"),
        SYSTEM_DAEMONS(3, "system daemons"),
        SECURITY(4, "security/authorization messages"),
        SYSLOGD(5, "messages generated internally by syslogd"),
        LINE_PRINTER(6, "line printer subsystem"),
        NETWORK_NEWS(7, "network news subsystem"),
        UUCP(8, "UUCP subsystem"),
        CLOCK_DAEMON(9, "clock daemon"),
        SECURITY2(10, "security/authorization messages"),
        FTP_DAEMON(11, "FTP daemon"),
        NTP(12, "NTP subsystem"),
        LOG_AUDIT(13, "log audit"),
        LOG_ALERT(14, "log alert"),
        CLOCK_DAEMON2(15, "clock daemon (note 2)"),
        LOCAL_USE_0(16, "local use 0  (local0)"),
        LOCAL_USE_1(17, "local use 1  (local1)"),
        LOCAL_USE_2(18, "local use 2  (local2)"),
        LOCAL_USE_3(19, "local use 3  (local3)"),
        LOCAL_USE_4(20, "local use 4  (local4)"),
        LOCAL_USE_5(21, "local use 5  (local5)"),
        LOCAL_USE_6(22, "local use 6  (local6)"),
        LOCAL_USE_7(23, "local use 7  (local7)");

        final int code;
        final String desc;
        final int octal;

        private Facility(int code, String desc) {
            this.code = code;
            this.desc = desc;
            this.octal = code * 8;
        }

        public String toString() {
            return String.format("%s[%d,%s]", this.name(), this.code, this.desc);
        }
    }

    public static enum Severity {
        EMERGENCY(0, "Emergency: system is unusable"),
        ALERT(1, "Alert: action must be taken immediately"),
        CRITICAL(2, "Critical: critical conditions"),
        ERROR(3, "Error: error conditions"),
        WARNING(4, "Warning: warning conditions"),
        NOTICE(5, "Notice: normal but significant condition"),
        INFORMATIONAL(6, "Informational: informational messages"),
        DEBUG(7, "Debug: debug-level messages");

        final int code;
        final String desc;

        private Severity(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String toString() {
            return String.format("%s[%d,%s]", this.name(), this.code, this.desc);
        }

        public static Severity fromLevel(java.util.logging.Level level) {
            if (level == null) {
                throw new IllegalArgumentException("Level cannot be null");
            }
            int levelValue = level.intValue();
            if (levelValue >= Level.FATAL.intValue()) {
                return EMERGENCY;
            }
            if (levelValue >= Level.SEVERE.intValue() || levelValue >= Level.ERROR.intValue()) {
                return ERROR;
            }
            if (levelValue >= Level.WARN.intValue() || levelValue >= java.util.logging.Level.WARNING.intValue()) {
                return WARNING;
            }
            if (levelValue >= Level.INFO.intValue()) {
                return INFORMATIONAL;
            }
            if (levelValue >= Level.TRACE.intValue() || levelValue >= java.util.logging.Level.FINEST.intValue()) {
                return DEBUG;
            }
            return INFORMATIONAL;
        }
    }

    public static enum Protocol {
        TCP,
        UDP,
        SSL_TCP;

    }
}

