/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.cli.CliConfig;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.SSLConfig;
import org.jboss.as.cli.impl.Namespace;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLMapper;
import org.wildfly.security.manager.WildFlySecurityManager;

class CliConfigImpl
implements CliConfig {
    private static final String JBOSS_XML_CONFIG = "jboss.cli.config";
    private static final String CURRENT_WORKING_DIRECTORY = "user.dir";
    private static final String JBOSS_CLI_FILE = "jboss-cli.xml";
    private static final String DEFAULT_CONTROLLER = "default-controller";
    private static final String ENABLED = "enabled";
    private static final String FILE_DIR = "file-dir";
    private static final String FILE_NAME = "file-name";
    private static final String JBOSS_CLI = "jboss-cli";
    private static final String HISTORY = "history";
    private static final String HOST = "host";
    private static final String MAX_SIZE = "max-size";
    private static final String PORT = "port";
    private static final String PROTOCOL = "protocol";
    private static final String CONNECTION_TIMEOUT = "connection-timeout";
    private static final String RESOLVE_PARAMETER_VALUES = "resolve-parameter-values";
    private static final String SILENT = "silent";
    private static final String VALIDATE_OPERATION_REQUESTS = "validate-operation-requests";
    private String defaultControllerProtocol = "http-remoting";
    private String defaultControllerHost = "localhost";
    private int defaultControllerPort = 9990;
    private boolean historyEnabled = true;
    private String historyFileName = ".jboss-cli-history";
    private String historyFileDir = WildFlySecurityManager.getPropertyPrivileged((String)"user.home", null);
    private int historyMaxSize = 500;
    private int connectionTimeout = 5000;
    private boolean validateOperationRequests = true;
    private boolean resolveParameterValues = false;
    private SSLConfig sslConfig;
    private boolean silent;

    static CliConfig load(CommandContext ctx) throws CliInitializationException {
        File jbossCliFile = CliConfigImpl.findCLIFileFromSystemProperty();
        if (jbossCliFile == null) {
            jbossCliFile = CliConfigImpl.findCLIFileInCurrentDirectory();
        }
        if (jbossCliFile == null) {
            jbossCliFile = CliConfigImpl.findCLIFileInJBossHome();
        }
        if (jbossCliFile == null) {
            System.err.println("WARN: can't find jboss-cli.xml. Using default configuration values.");
            return new CliConfigImpl();
        }
        return CliConfigImpl.parse(ctx, jbossCliFile);
    }

    private static File findCLIFileFromSystemProperty() {
        String jbossCliConfig = WildFlySecurityManager.getPropertyPrivileged((String)JBOSS_XML_CONFIG, null);
        if (jbossCliConfig == null) {
            return null;
        }
        return new File(jbossCliConfig);
    }

    private static File findCLIFileInCurrentDirectory() {
        String currentDir = WildFlySecurityManager.getPropertyPrivileged((String)CURRENT_WORKING_DIRECTORY, null);
        if (currentDir == null) {
            return null;
        }
        File jbossCliFile = new File(currentDir, JBOSS_CLI_FILE);
        if (!jbossCliFile.exists()) {
            return null;
        }
        return jbossCliFile;
    }

    private static File findCLIFileInJBossHome() {
        String jbossHome = WildFlySecurityManager.getEnvPropertyPrivileged((String)"JBOSS_HOME", null);
        if (jbossHome == null) {
            return null;
        }
        File jbossCliFile = new File(jbossHome + File.separatorChar + "bin", JBOSS_CLI_FILE);
        if (!jbossCliFile.exists()) {
            return null;
        }
        return jbossCliFile;
    }

    static CliConfig parse(CommandContext ctx, File f) throws CliInitializationException {
        if (f == null) {
            throw new CliInitializationException("The file argument is null.");
        }
        if (!f.exists()) {
            return new CliConfigImpl();
        }
        CliConfigImpl config = new CliConfigImpl();
        BufferedInputStream input = null;
        try {
            XMLMapper mapper = XMLMapper.Factory.create();
            CliConfigReader reader = new CliConfigReader();
            for (Namespace current : Namespace.cliValues()) {
                mapper.registerRootElement(new QName(current.getUriString(), JBOSS_CLI), (XMLElementReader)reader);
            }
            FileInputStream is = new FileInputStream(f);
            input = new BufferedInputStream(is);
            XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(input);
            mapper.parseDocument((Object)config, streamReader);
            streamReader.close();
        }
        catch (Throwable t) {
            try {
                throw new CliInitializationException("Failed to parse " + f.getAbsolutePath(), t);
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(input);
                throw throwable;
            }
        }
        StreamUtils.safeClose((Closeable)input);
        return config;
    }

    private static String resolveString(String str) throws XMLStreamException {
        if (str == null) {
            return null;
        }
        if (str.startsWith("${") && str.endsWith("}")) {
            String resolved = WildFlySecurityManager.getPropertyPrivileged((String)(str = str.substring(2, str.length() - 1)), null);
            if (resolved == null) {
                throw new XMLStreamException("Failed to resolve '" + str + "' to a non-null value.");
            }
            str = resolved;
        }
        return str;
    }

    private static boolean resolveBoolean(String str) throws XMLStreamException {
        return Boolean.parseBoolean(CliConfigImpl.resolveString(str));
    }

    private CliConfigImpl() {
    }

    @Override
    public String getDefaultControllerProtocol() {
        return this.defaultControllerProtocol;
    }

    @Override
    public String getDefaultControllerHost() {
        return this.defaultControllerHost;
    }

    @Override
    public int getDefaultControllerPort() {
        return this.defaultControllerPort;
    }

    @Override
    public boolean isHistoryEnabled() {
        return this.historyEnabled;
    }

    @Override
    public String getHistoryFileName() {
        return this.historyFileName;
    }

    @Override
    public String getHistoryFileDir() {
        return this.historyFileDir;
    }

    @Override
    public int getHistoryMaxSize() {
        return this.historyMaxSize;
    }

    @Override
    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    @Override
    public boolean isValidateOperationRequests() {
        return this.validateOperationRequests;
    }

    @Override
    public boolean isResolveParameterValues() {
        return this.resolveParameterValues;
    }

    @Override
    public SSLConfig getSslConfig() {
        return this.sslConfig;
    }

    @Override
    public boolean isSilent() {
        return this.silent;
    }

    static class CliConfigReader
    implements XMLElementReader<CliConfigImpl> {
        CliConfigReader() {
        }

        public void readElement(XMLExtendedStreamReader reader, CliConfigImpl config) throws XMLStreamException {
            String localName = reader.getLocalName();
            if (!CliConfigImpl.JBOSS_CLI.equals(localName)) {
                throw new XMLStreamException("Unexpected element: " + localName);
            }
            Namespace readerNS = Namespace.forUri(reader.getNamespaceURI());
            for (Namespace current : Namespace.cliValues()) {
                if (!readerNS.equals((Object)current)) continue;
                this.readCLIElement_1_0(reader, readerNS, config);
                return;
            }
            throw new XMLStreamException("Unexpected element: " + localName);
        }

        public void readCLIElement_1_0(XMLExtendedStreamReader reader, Namespace expectedNs, CliConfigImpl config) throws XMLStreamException {
            boolean jbossCliEnded = false;
            while (reader.hasNext() && !jbossCliEnded) {
                String localName;
                int tag = reader.nextTag();
                this.assertExpectedNamespace(reader, expectedNs);
                if (tag == 1) {
                    localName = reader.getLocalName();
                    if (localName.equals(CliConfigImpl.DEFAULT_CONTROLLER)) {
                        switch (expectedNs) {
                            case CLI_1_0: 
                            case CLI_1_1: 
                            case CLI_1_2: {
                                this.readDefaultController_1_0(reader, expectedNs, config);
                                break;
                            }
                            default: {
                                this.readDefaultController_2_0(reader, expectedNs, config);
                                break;
                            }
                        }
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.HISTORY)) {
                        this.readHistory(reader, expectedNs, config);
                        continue;
                    }
                    if (localName.equals("ssl")) {
                        SslConfig sslConfig = new SslConfig();
                        switch (expectedNs) {
                            case CLI_1_0: {
                                this.readSSLElement_1_0(reader, expectedNs, sslConfig);
                                break;
                            }
                            default: {
                                this.readSSLElement_1_1(reader, expectedNs, sslConfig);
                            }
                        }
                        config.sslConfig = sslConfig;
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.VALIDATE_OPERATION_REQUESTS)) {
                        config.validateOperationRequests = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (localName.equals(CliConfigImpl.RESOLVE_PARAMETER_VALUES)) {
                        config.resolveParameterValues = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    if (CliConfigImpl.CONNECTION_TIMEOUT.equals(localName)) {
                        String text = reader.getElementText();
                        try {
                            config.connectionTimeout = Integer.parseInt(text);
                            continue;
                        }
                        catch (NumberFormatException e) {
                            throw new XMLStreamException("Failed to parse jboss-cli connection-timeout value '" + text + "'", e);
                        }
                    }
                    if (localName.equals(CliConfigImpl.SILENT)) {
                        config.silent = CliConfigImpl.resolveBoolean(reader.getElementText());
                        continue;
                    }
                    throw new XMLStreamException("Unexpected element: " + localName);
                }
                if (tag != 2 || !(localName = reader.getLocalName()).equals(CliConfigImpl.JBOSS_CLI)) continue;
                jbossCliEnded = true;
            }
        }

        private void readDefaultController_1_0(XMLExtendedStreamReader reader, Namespace expectedNs, CliConfigImpl config) throws XMLStreamException {
            while (reader.hasNext() && reader.nextTag() != 2) {
                this.assertExpectedNamespace(reader, expectedNs);
                String localName = reader.getLocalName();
                String resolved = CliConfigImpl.resolveString(reader.getElementText());
                if (CliConfigImpl.HOST.equals(localName)) {
                    config.defaultControllerHost = resolved;
                    continue;
                }
                if (CliConfigImpl.PORT.equals(localName)) {
                    try {
                        config.defaultControllerPort = Integer.parseInt(resolved);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new XMLStreamException("Failed to parse default-controller port value '" + resolved + "'", e);
                    }
                }
                throw new XMLStreamException("Unexpected child of default-controller: " + localName);
            }
        }

        private void readDefaultController_2_0(XMLExtendedStreamReader reader, Namespace expectedNs, CliConfigImpl config) throws XMLStreamException {
            while (reader.hasNext() && reader.nextTag() != 2) {
                this.assertExpectedNamespace(reader, expectedNs);
                String localName = reader.getLocalName();
                String resolved = CliConfigImpl.resolveString(reader.getElementText());
                if (CliConfigImpl.HOST.equals(localName)) {
                    config.defaultControllerHost = resolved;
                    continue;
                }
                if (CliConfigImpl.PROTOCOL.equals(localName)) {
                    config.defaultControllerProtocol = resolved;
                    continue;
                }
                if (CliConfigImpl.PORT.equals(localName)) {
                    try {
                        config.defaultControllerPort = Integer.parseInt(resolved);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new XMLStreamException("Failed to parse default-controller port value '" + resolved + "'", e);
                    }
                }
                throw new XMLStreamException("Unexpected child of default-controller: " + localName);
            }
        }

        private void readHistory(XMLExtendedStreamReader reader, Namespace expectedNs, CliConfigImpl config) throws XMLStreamException {
            while (reader.hasNext() && reader.nextTag() != 2) {
                this.assertExpectedNamespace(reader, expectedNs);
                String localName = reader.getLocalName();
                String resolved = CliConfigImpl.resolveString(reader.getElementText());
                if (CliConfigImpl.ENABLED.equals(localName)) {
                    config.historyEnabled = Boolean.parseBoolean(resolved);
                    continue;
                }
                if (CliConfigImpl.FILE_NAME.equals(localName)) {
                    config.historyFileName = resolved;
                    continue;
                }
                if (CliConfigImpl.FILE_DIR.equals(localName)) {
                    config.historyFileDir = resolved;
                    continue;
                }
                if (CliConfigImpl.MAX_SIZE.equals(localName)) {
                    try {
                        config.historyMaxSize = Integer.parseInt(resolved);
                        continue;
                    }
                    catch (NumberFormatException e) {
                        throw new XMLStreamException("Failed to parse history max-size value '" + resolved + "'", e);
                    }
                }
                throw new XMLStreamException("Unexpected child of default-controller: " + localName);
            }
        }

        public void readSSLElement_1_0(XMLExtendedStreamReader reader, Namespace expectedNs, SslConfig config) throws XMLStreamException {
            while (reader.hasNext() && reader.nextTag() != 2) {
                this.assertExpectedNamespace(reader, expectedNs);
                String localName = reader.getLocalName();
                if ("keyStore".equals(localName)) {
                    config.setKeyStore(reader.getElementText());
                    continue;
                }
                if ("keyStorePassword".equals(localName)) {
                    config.setKeyStorePassword(reader.getElementText());
                    continue;
                }
                if ("trustStore".equals(localName)) {
                    config.setTrustStore(reader.getElementText());
                    continue;
                }
                if ("trustStorePassword".equals(localName)) {
                    config.setTrustStorePassword(reader.getElementText());
                    continue;
                }
                if ("modifyTrustStore".equals(localName)) {
                    config.setModifyTrustStore(CliConfigImpl.resolveBoolean(reader.getElementText()));
                    continue;
                }
                throw new XMLStreamException("Unexpected child of ssl : " + localName);
            }
        }

        public void readSSLElement_1_1(XMLExtendedStreamReader reader, Namespace expectedNs, SslConfig config) throws XMLStreamException {
            while (reader.hasNext() && reader.nextTag() != 2) {
                this.assertExpectedNamespace(reader, expectedNs);
                String localName = reader.getLocalName();
                if ("alias".equals(localName)) {
                    config.setAlias(reader.getElementText());
                    continue;
                }
                if ("key-store".equals(localName) || "keyStore".equals(localName)) {
                    config.setKeyStore(reader.getElementText());
                    continue;
                }
                if ("key-store-password".equals(localName) || "keyStorePassword".equals(localName)) {
                    config.setKeyStorePassword(reader.getElementText());
                    continue;
                }
                if ("key-password".equals(localName) || "keyPassword".equals(localName)) {
                    config.setKeyPassword(reader.getElementText());
                    continue;
                }
                if ("trust-store".equals(localName) || "trustStore".equals(localName)) {
                    config.setTrustStore(reader.getElementText());
                    continue;
                }
                if ("trust-store-password".equals(localName) || "trustStorePassword".equals(localName)) {
                    config.setTrustStorePassword(reader.getElementText());
                    continue;
                }
                if ("modify-trust-store".equals(localName) || "modifyTrustStore".equals(localName)) {
                    config.setModifyTrustStore(CliConfigImpl.resolveBoolean(reader.getElementText()));
                    continue;
                }
                throw new XMLStreamException("Unexpected child of ssl : " + localName);
            }
        }

        private void assertExpectedNamespace(XMLExtendedStreamReader reader, Namespace expectedNs) throws XMLStreamException {
            if (!expectedNs.equals((Object)Namespace.forUri(reader.getNamespaceURI()))) {
                throw new XMLStreamException("Unexpected element: " + reader.getLocalName());
            }
        }
    }

    static class SslConfig
    implements SSLConfig {
        private String alias = null;
        private String keyStore = null;
        private String keyStorePassword = null;
        private String keyPassword = null;
        private String trustStore = null;
        private String trustStorePassword = null;
        private boolean modifyTrustStore = true;

        SslConfig() {
        }

        @Override
        public String getKeyStore() {
            return this.keyStore;
        }

        void setKeyStore(String keyStore) {
            this.keyStore = keyStore;
        }

        @Override
        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        void setKeyStorePassword(String keyStorePassword) {
            this.keyStorePassword = keyStorePassword;
        }

        @Override
        public String getAlias() {
            return this.alias;
        }

        void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public String getKeyPassword() {
            return this.keyPassword;
        }

        void setKeyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
        }

        @Override
        public String getTrustStore() {
            return this.trustStore;
        }

        void setTrustStore(String trustStore) {
            this.trustStore = trustStore;
        }

        @Override
        public String getTrustStorePassword() {
            return this.trustStorePassword;
        }

        void setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
        }

        @Override
        public boolean isModifyTrustStore() {
            return this.modifyTrustStore;
        }

        void setModifyTrustStore(boolean modifyTrustStore) {
            this.modifyTrustStore = modifyTrustStore;
        }
    }
}

