/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.nio.charset.Charset;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.jboss.security.vault.SecurityVault;
import org.jboss.security.vault.SecurityVaultException;
import org.picketbox.plugins.vault.PicketBoxSecurityVault;

class CLIVaultReader {
    private static final Pattern VAULT_PATTERN = Pattern.compile("VAULT::.*::.*::.*");
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private volatile SecurityVault vault;

    CLIVaultReader() {
    }

    void init(Map<String, Object> options) throws SecurityVaultException {
        this.vault = new PicketBoxSecurityVault();
        this.vault.init(options);
    }

    String retrieve(String password) throws SecurityVaultException {
        if (this.isVaultFormat(password)) {
            char[] retrieved = this.getValue(password);
            return retrieved != null ? new String(retrieved) : null;
        }
        return password;
    }

    boolean isVaultFormat(String str) {
        return str != null && VAULT_PATTERN.matcher(str).matches();
    }

    private char[] getValue(String vaultString) throws SecurityVaultException {
        if (this.vault == null) {
            throw new SecurityVaultException("Vault has not been initialized.");
        }
        String[] tokens = this.tokens(vaultString);
        byte[] sharedKey = null;
        if (tokens.length > 2) {
            sharedKey = tokens[3].getBytes(CHARSET);
        }
        return this.vault.retrieve(tokens[1], tokens[2], sharedKey);
    }

    private String[] tokens(String vaultString) {
        StringTokenizer tokenizer = new StringTokenizer(vaultString, "::");
        int length = tokenizer.countTokens();
        String[] tokens = new String[length];
        int index = 0;
        while (tokenizer != null && tokenizer.hasMoreTokens()) {
            tokens[index++] = tokenizer.nextToken();
        }
        return tokens;
    }
}

