package org.jgroups.tests;

import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.util.Util;

import java.io.Serializable;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla {
    protected static final String[] stocks={"rht", "appl", "orcl", "sun", "ibm", "amzn", "ubs"};

    public static void main(String[] args) throws Exception {
        bla.start(args[0]);
    }

    protected static void start(String name) throws Exception {
        JChannel ch=new JChannel("/home/bela/fast.xml").name(name);
        ch.setReceiver(new ReceiverAdapter() {
            public void viewAccepted(View view) {
                System.out.printf("-- view: %s\n", view);
            }

            public void receive(Message msg) {
                Update update=(Update)msg.getObject();
                System.out.printf("%s: %.2f\n", update.name, update.val);
            }


        });
        ch.connect("stock-ticker");
        for(;;) {
            String ticker=stocks[((int)Util.random(stocks.length - 1))];
            ch.send(null, new Update(ticker, Util.random(200)));
            Util.sleep(3000);
        }
    }

    protected static class Update implements Serializable {
        private static final long serialVersionUID=-1651000832768886682L;
        protected String name;
        protected double val;
        public Update(String name, double val) {this.name=name;this.val=val;}
    }


}
