package org.jgroups.tests;

import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla2 {
    public static void main(String[] args) throws Exception {
        Selector sel=Selector.open();
        ServerSocketChannel srv_ch=ServerSocketChannel.open();
        srv_ch.bind(new InetSocketAddress(7500));
        srv_ch.configureBlocking(false);
        SelectionKey key=srv_ch.register(sel, SelectionKey.OP_ACCEPT);
        SocketChannel ch=null;

        sel.select();
        Set<SelectionKey> keys=sel.selectedKeys();
        for(Iterator<SelectionKey> it=keys.iterator(); it.hasNext();) {
            SelectionKey k=it.next();
            it.remove();
            if(!k.isValid())
                continue;
            if(k.isAcceptable())
                ch=srv_ch.accept();
        }

        ch.configureBlocking(false);
        int interest_ops=key.interestOps() | SelectionKey.OP_WRITE;
        key.interestOps(interest_ops);

        // key=ch.register(sel, SelectionKey.OP_WRITE);

        int valid_ops=ch.validOps();
        System.out.println("valid_ops = " + valid_ops);

        interest_ops=key.interestOps();
        System.out.println("interest_ops = " + interest_ops);


        interest_ops=key.interestOps() & ~SelectionKey.OP_CONNECT | SelectionKey.OP_READ;
        key.interestOps(interest_ops);

        interest_ops=key.interestOps() | SelectionKey.OP_WRITE;
        key.interestOps(interest_ops);

        interest_ops=key.interestOps() & ~SelectionKey.OP_WRITE;
        key.interestOps(interest_ops);

    }
}
