package org.jgroups.tests;

import org.jgroups.util.Util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla5 {
    protected AsynchronousServerSocketChannel ch;

    protected void start() throws Exception {
        ch=AsynchronousServerSocketChannel.open();
        ch.bind(new InetSocketAddress("0.0.0.0", 7500));

        ch.accept(null, new AcceptHandler());

        Util.sleep(60000);
    }


    protected static class AcceptHandler implements CompletionHandler<AsynchronousSocketChannel,Object> {

        public void completed(AsynchronousSocketChannel result, Object attachment) {
            System.out.printf("accept(): sock is %s attachment is %s\n", result, attachment);
            Request req=new Request(ByteBuffer.allocate(1024), result);
            result.read(req.buf, req, new ReadHandler());
        }

        public void failed(Throwable exc, Object attachment) {
            System.err.println("accept() failed: " + exc);
        }
    }


    protected static class ReadHandler implements CompletionHandler<Integer,Request> {


        public void completed(Integer result, Request req) {
            if(result < 0) {
                try {
                    req.ch.close();
                }
                catch(IOException e) {
                    e.printStackTrace();
                }
            }
            else {
                System.out.printf("read %d bytes\n", result);
                req.buf.clear();
                req.ch.read(req.buf,req, this);
            }
        }

        public void failed(Throwable exc, Request attachment) {
            System.err.printf("read(): failed: %s\n", exc);
        }
    }





    public static void main(String[] args) throws Exception {
        new bla5().start();
    }

    protected static class Request {
        protected final ByteBuffer                buf;
        protected final AsynchronousSocketChannel ch;

        public Request(ByteBuffer buf, AsynchronousSocketChannel ch) {
            this.buf=buf;
            this.ch=ch;
        }
    }

}
