/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;

public class BufferHelper {
    public static int sizeOfNullableSimpleString(String str) {
        if (str == null) {
            return 1;
        }
        return 1 + BufferHelper.sizeOfSimpleString(str);
    }

    public static int sizeOfSimpleString(String str) {
        return 4 + str.length() * 2;
    }

    public static void writeAsNullableSimpleString(ActiveMQBuffer buffer, String str) {
        buffer.writeNullableSimpleString(SimpleString.toSimpleString(str));
    }

    public static String readNullableSimpleStringAsString(ActiveMQBuffer buffer) {
        SimpleString str = buffer.readNullableSimpleString();
        return str != null ? str.toString() : null;
    }

    public static void writeAsSimpleString(ActiveMQBuffer buffer, String str) {
        buffer.writeSimpleString(new SimpleString(str));
    }

    public static void writeNullableBoolean(ActiveMQBuffer buffer, Boolean value) {
        buffer.writeBoolean(value != null);
        if (value != null) {
            buffer.writeBoolean(value);
        }
    }

    public static int sizeOfNullableBoolean(Boolean value) {
        return 1 + (value != null ? 1 : 0);
    }

    public static Boolean readNullableBoolean(ActiveMQBuffer buffer) {
        boolean isNotNull = buffer.readBoolean();
        if (isNotNull) {
            return buffer.readBoolean();
        }
        return null;
    }

    public static void writeNullableLong(ActiveMQBuffer buffer, Long value) {
        buffer.writeBoolean(value != null);
        if (value != null) {
            buffer.writeLong(value);
        }
    }

    public static void writeNullableDouble(ActiveMQBuffer buffer, Double value) {
        buffer.writeBoolean(value != null);
        if (value != null) {
            buffer.writeDouble(value);
        }
    }

    public static int sizeOfNullableLong(Long value) {
        return 1 + (value != null ? 8 : 0);
    }

    public static int sizeOfNullableDouble(Double value) {
        return 1 + (value != null ? 8 : 0);
    }

    public static Long readNullableLong(ActiveMQBuffer buffer) {
        boolean isNotNull = buffer.readBoolean();
        if (isNotNull) {
            return buffer.readLong();
        }
        return null;
    }

    public static void writeNullableInteger(ActiveMQBuffer buffer, Integer value) {
        buffer.writeBoolean(value != null);
        if (value != null) {
            buffer.writeInt(value);
        }
    }

    public static int sizeOfNullableInteger(Integer value) {
        return 1 + (value != null ? 4 : 0);
    }

    public static Integer readNullableInteger(ActiveMQBuffer buffer) {
        boolean isNotNull = buffer.readBoolean();
        if (isNotNull) {
            return buffer.readInt();
        }
        return null;
    }

    public static Double readNullableDouble(ActiveMQBuffer buffer) {
        boolean isNotNull = buffer.readBoolean();
        if (isNotNull) {
            return buffer.readDouble();
        }
        return null;
    }
}

