/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.transaction;

import org.wildfly.common.Assert;
import org.wildfly.security.permission.AbstractNameSetOnlyPermission;
import org.wildfly.security.util.StringEnumeration;
import org.wildfly.security.util.StringMapping;

public final class TransactionPermission
extends AbstractNameSetOnlyPermission<TransactionPermission> {
    private static final StringEnumeration NAMES = StringEnumeration.of("getRecoveryInterface", "getTransactionResolver", "getProviderInterface", "registerAssociationListener", "registerCreationListener", "suspendRequests", "resumeRequests", "modifyUserTransactionAvailability", "getXATerminator", "setGlobalDefaultTransactionTimeout");
    static final StringMapping<TransactionPermission> mapping = new StringMapping<TransactionPermission>(NAMES, TransactionPermission::new);
    private static final TransactionPermission allPermission = new TransactionPermission("*");

    public TransactionPermission(String name) {
        super(name, NAMES);
    }

    public TransactionPermission(String name, String action) {
        this(name);
    }

    @Override
    public TransactionPermission withName(String name) {
        return new TransactionPermission(name);
    }

    public static TransactionPermission forName(String name) {
        Assert.checkNotNullParam("name", name);
        return "*".equals(name) ? allPermission : mapping.getItemByString(name);
    }
}

