package org.jgroups.tests;

import org.jgroups.*;
import org.jgroups.util.*;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla extends ReceiverAdapter {
    protected JChannel            ch;
    protected static final String props="/home/bela/fast.xml";
    protected int cnt=1;
    protected final byte[] PL=new byte[10000];

    protected void start(String name) throws Exception {
        ch=new JChannel(props).name(name);
        ch.setReceiver(this); // useless receiver won't get called!
        ch.connect("demo");
        int num=1;
        for(;;) {
            Util.keyPress(">>");


             Message msg=new Message(null, "hello world");
            //Message msg=new ObjectMessage(null, new Person("Bela", 52, num++, PL));
            // Message msg=new BytesMessage(null, PL);
            ch.send(msg);
        }
    }




    public static void main(String[] args) throws Exception {
        new bla().start(args[0]);
    }

    public void receive(Message msg) {
        //if(msg.hasArray())
            System.out.printf("received %d bytes from %s\n", msg.getLength(), msg.getSrc());
        //else {
          //  String tmp=msg.getObject().toString();
            //System.out.printf("msg from %s: %s\n", msg.getSrc(), tmp);
        //}
    }

    public void receive(MessageBatch batch) {
        System.out.printf("%d msg(s) from %s:\n", batch.size(), batch.sender());
        for(Message msg: batch) {
          //  if(msg.hasArray())
                System.out.printf("received %d bytes from %s\n", msg.getLength(), msg.getSrc());
            //else {
              //  String tmp=msg.getObject().toString();
                //System.out.printf("%s\n", tmp);
           // }
        }
    }

    public void viewAccepted(View view) {
        System.out.printf("-- view: %s\n", view);
    }



    protected static class Person implements SizeStreamable {
        protected String name;
        protected int    age, counter;
        protected byte[] payload;

        public Person() {
        }

        public Person(String name, int age, int counter, byte[] pl) {
            this.name=name;
            this.age=age;
            this.counter=counter;
            this.payload=pl;
        }


        public int serializedSize() {
            return Bits.size(name) + Bits.size(age) + Bits.size(counter) + payload.length + Global.INT_SIZE;
        }

        public void writeTo(DataOutput out) throws Exception {
            Bits.writeString(name, out);
            Bits.writeInt(age, out);
            Bits.writeInt(counter, out);
            out.writeInt(payload.length);
            out.write(payload);
        }

        public void readFrom(DataInput in) throws Exception {
            name=Bits.readString(in);
            age=Bits.readInt(in);
            counter=Bits.readInt(in);
            payload=new byte[in.readInt()];
            in.readFully(payload);
        }

        public String toString() {
            return String.format("name: %s, age: %d, counter: %s (payload: %s bytes)\n", name, age, counter, payload.length);
        }
    }
}



