package org.jgroups.tests;

import org.jgroups.*;
import org.jgroups.util.Util;

import java.util.stream.Stream;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla4 {

    protected JChannel a,b,c,d;


    protected void start() throws Exception {
        a=new JChannel().name("A").connect("demo");
        b=new JChannel().name("B").connect("demo");
        c=new JChannel().name("C").connect("demo");
        d=new JChannel().name("D").connect("demo");
        Util.waitUntilAllChannelsHaveSameView(10000, 1000, a,b,c,d);

        Stream.of(a, b, c, d).forEach(ch -> {
            View v=ch.getView();
            Address[] mbrs=v.getMembersRaw();
            StringBuilder sb=new StringBuilder(ch.getAddress() + ":\n");
            for(Address mbr: mbrs) {
                PhysicalAddress physical_addr=(PhysicalAddress)ch.down(new Event(Event.GET_PHYSICAL_ADDRESS, mbr));
                sb.append(mbr + " -> " + physical_addr + "\n");
            }
            System.out.printf("%s\n", sb.toString());
        });
        Util.close(d,c,b,a);
    }



    public static void main(String[] args) throws Exception {
        new bla4().start();
    }
}
