/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.LocalAddress;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

@MBean(description="Double-checks suspicions reports")
public class VERIFY_SUSPECT
extends Protocol
implements Runnable {
    @Property(description="Number of millisecs to wait for a response from a suspected member")
    protected long timeout = 2000L;
    @Property(description="Number of verify heartbeats sent to a suspected member")
    protected int num_msgs = 1;
    @Property(description="Use InetAddress.isReachable() to verify suspected member instead of regular messages")
    protected boolean use_icmp;
    @Property(description="Send the I_AM_NOT_DEAD message back as a multicast rather than as multiple unicasts (default is false)")
    protected boolean use_mcast_rsps;
    @LocalAddress
    @Property(description="Interface for ICMP pings. Used if use_icmp is true The following special values are also recognized: GLOBAL, SITE_LOCAL, LINK_LOCAL and NON_LOOPBACK", systemProperty={"jgroups.bind_addr"})
    protected InetAddress bind_addr;
    protected NetworkInterface intf;
    protected Address local_addr;
    protected final DelayQueue<Entry> suspects = new DelayQueue();
    protected volatile Thread timer;
    protected volatile boolean running;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagedAttribute(description="List of currently suspected members")
    public String getSuspects() {
        DelayQueue<Entry> delayQueue = this.suspects;
        synchronized (delayQueue) {
            return this.suspects.toString();
        }
    }

    public VERIFY_SUSPECT setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 8: {
                this.local_addr = (Address)evt.getArg();
                break;
            }
            case 6: {
                View v = (View)evt.getArg();
                this.adjustSuspectedMembers(v.getMembers());
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 9: {
                List<Address> s;
                List<Address> list = s = evt.arg() instanceof Address ? Collections.singletonList((Address)evt.arg()) : (List<Address>)evt.arg();
                if (s == null) {
                    return null;
                }
                s.remove(this.local_addr);
                if (this.use_icmp) {
                    s.forEach(this::verifySuspectWithICMP);
                } else {
                    this.verifySuspect(s);
                }
                return null;
            }
            case 56: {
                if (this.bind_addr != null) break;
                Map config = (Map)evt.getArg();
                this.bind_addr = (InetAddress)config.get("bind_addr");
            }
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object up(Message msg) {
        VerifyHeader hdr = (VerifyHeader)msg.getHeader(this.id);
        if (hdr == null) {
            return this.up_prot.up(msg);
        }
        switch (hdr.type) {
            case 1: {
                if (hdr.from == null) {
                    this.log.error(Util.getMessage("AREYOUDEADHdrFromIsNull"));
                    return null;
                }
                Address target = this.use_mcast_rsps ? null : hdr.from;
                for (int i = 0; i < this.num_msgs; ++i) {
                    Message rsp = new Message(target).setFlag(Message.Flag.INTERNAL).putHeader(this.id, new VerifyHeader(2, this.local_addr));
                    this.down_prot.down(rsp);
                }
                return null;
            }
            case 2: {
                if (hdr.from == null) {
                    this.log.error(Util.getMessage("IAMNOTDEADHdrFromIsNull"));
                    return null;
                }
                this.unsuspect(hdr.from);
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustSuspectedMembers(List<Address> new_mbrship) {
        DelayQueue<Entry> delayQueue = this.suspects;
        synchronized (delayQueue) {
            this.suspects.removeIf(entry -> !new_mbrship.contains(entry.suspect));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (true) {
            DelayQueue<Entry> delayQueue = this.suspects;
            synchronized (delayQueue) {
                if (this.suspects.isEmpty()) {
                    this.running = false;
                    return;
                }
            }
            try {
                Entry entry = (Entry)this.suspects.poll(this.timeout, TimeUnit.MILLISECONDS);
                if (entry == null) continue;
                ArrayList expired = new ArrayList(this.suspects.size());
                this.suspects.drainTo(expired);
                LinkedHashSet<Address> suspect_list = new LinkedHashSet<Address>();
                suspect_list.add(entry.suspect);
                expired.forEach(e -> suspect_list.add(e.suspect));
                this.log.debug("%s %s dead (passing up SUSPECT event)", suspect_list, suspect_list.size() > 1 ? "are" : "is");
                this.up_prot.up(new Event(9, suspect_list));
                continue;
            }
            catch (InterruptedException e2) {
                if (!this.running) return;
                continue;
            }
            break;
        }
    }

    protected void verifySuspect(Collection<Address> mbrs) {
        if (mbrs == null || mbrs.isEmpty()) {
            return;
        }
        if (this.addSuspects(mbrs)) {
            this.startTimer();
            this.log.trace("verifying that %s %s dead", mbrs, mbrs.size() == 1 ? "is" : "are");
        }
        for (Address mbr : mbrs) {
            for (int i = 0; i < this.num_msgs; ++i) {
                Message msg = new Message(mbr).setFlag(Message.Flag.INTERNAL).putHeader(this.id, new VerifyHeader(1, this.local_addr));
                this.down_prot.down(msg);
            }
        }
    }

    protected void verifySuspectWithICMP(Address suspected_mbr) {
        InetAddress host;
        InetAddress inetAddress = host = suspected_mbr instanceof IpAddress ? ((IpAddress)suspected_mbr).getIpAddress() : null;
        if (host == null) {
            throw new IllegalArgumentException("suspected_mbr is not of type IpAddress - FD_ICMP only works with these");
        }
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("pinging host " + suspected_mbr + " using interface " + this.intf);
            }
            long start = VERIFY_SUSPECT.getCurrentTimeMillis();
            boolean rc = host.isReachable(this.intf, 0, (int)this.timeout);
            long stop = VERIFY_SUSPECT.getCurrentTimeMillis();
            if (rc) {
                this.log.trace("successfully received response from " + host + " (after " + (stop - start) + "ms)");
            } else {
                this.log.debug("failed pinging " + suspected_mbr + " after " + (stop - start) + "ms; passing up SUSPECT event");
                this.removeSuspect(suspected_mbr);
                this.up_prot.up(new Event(9, Collections.singletonList(suspected_mbr)));
            }
        }
        catch (Exception ex) {
            this.log.error(Util.getMessage("FailedPinging"), suspected_mbr, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean addSuspects(Collection<Address> list) {
        if (list == null) return false;
        if (list.isEmpty()) {
            return false;
        }
        boolean added = false;
        DelayQueue<Entry> delayQueue = this.suspects;
        synchronized (delayQueue) {
            for (Address suspected_mbr : list) {
                boolean found_dupe = this.suspects.stream().anyMatch(e -> e.suspect.equals(suspected_mbr));
                if (found_dupe) continue;
                this.suspects.add(new Entry(suspected_mbr, VERIFY_SUSPECT.getCurrentTimeMillis() + this.timeout));
                added = true;
            }
            if (!added) return false;
            if (this.running) return false;
            this.running = true;
            if (!true) return false;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeSuspect(Address suspect) {
        if (suspect == null) {
            return false;
        }
        DelayQueue<Entry> delayQueue = this.suspects;
        synchronized (delayQueue) {
            return this.suspects.removeIf(e -> Objects.equals(e.suspect, suspect));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearSuspects() {
        DelayQueue<Entry> delayQueue = this.suspects;
        synchronized (delayQueue) {
            this.suspects.clear();
        }
    }

    public void unsuspect(Address mbr) {
        boolean removed;
        boolean bl = removed = mbr != null && this.removeSuspect(mbr);
        if (removed) {
            this.log.trace("member " + mbr + " was unsuspected");
            this.down_prot.down(new Event(51, mbr));
            this.up_prot.up(new Event(51, mbr));
        }
    }

    protected synchronized void startTimer() {
        this.timer = this.getThreadFactory().newThread(this, "VERIFY_SUSPECT.TimerThread");
        this.timer.setDaemon(true);
        this.timer.start();
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.bind_addr != null) {
            this.intf = NetworkInterface.getByInetAddress(this.bind_addr);
        }
    }

    @Override
    public synchronized void stop() {
        this.clearSuspects();
        this.running = false;
        if (this.timer != null && this.timer.isAlive()) {
            Thread tmp = this.timer;
            this.timer = null;
            tmp.interrupt();
        }
        this.timer = null;
    }

    private static long getCurrentTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    }

    public static class VerifyHeader
    extends Header {
        static final short ARE_YOU_DEAD = 1;
        static final short I_AM_NOT_DEAD = 2;
        short type = 1;
        Address from;

        public VerifyHeader() {
        }

        VerifyHeader(short type) {
            this.type = type;
        }

        VerifyHeader(short type, Address from) {
            this(type);
            this.from = from;
        }

        @Override
        public short getMagicId() {
            return 54;
        }

        @Override
        public Supplier<? extends Header> create() {
            return VerifyHeader::new;
        }

        @Override
        public String toString() {
            switch (this.type) {
                case 1: {
                    return "[VERIFY_SUSPECT: ARE_YOU_DEAD]";
                }
                case 2: {
                    return "[VERIFY_SUSPECT: I_AM_NOT_DEAD]";
                }
            }
            return "[VERIFY_SUSPECT: unknown type (" + this.type + ")]";
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.writeShort(this.type);
            Util.writeAddress(this.from, out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.type = in.readShort();
            this.from = Util.readAddress(in);
        }

        @Override
        public int serializedSize() {
            return 2 + Util.size(this.from);
        }
    }

    protected static class Entry
    implements Delayed {
        protected final Address suspect;
        protected final long target_time;

        public Entry(Address suspect, long target_time) {
            this.suspect = suspect;
            this.target_time = target_time;
        }

        @Override
        public int compareTo(Delayed o) {
            Entry other = (Entry)o;
            long my_delay = this.getDelay(TimeUnit.MILLISECONDS);
            long other_delay = other.getDelay(TimeUnit.MILLISECONDS);
            return Long.compare(my_delay, other_delay);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long delay = this.target_time - VERIFY_SUSPECT.getCurrentTimeMillis();
            return unit.convert(delay, TimeUnit.MILLISECONDS);
        }

        public String toString() {
            return this.suspect + ": " + this.target_time;
        }
    }
}

