package org.apache.activemq.artemis.jms.client;

import java.util.Locale;
import javax.jms.IllegalStateException;
import java.io.Serializable;
import org.apache.activemq.artemis.api.core.ActiveMQInvalidFilterExpressionException;
import javax.annotation.Generated;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import javax.jms.MessageNotReadableException;
import org.apache.activemq.artemis.api.core.SimpleString;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import java.lang.String;
import javax.jms.MessageNotWriteableException;
import javax.jms.IllegalStateRuntimeException;
import java.lang.Throwable;
import java.util.Arrays;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import java.lang.IllegalArgumentException;
import javax.jms.JMSRuntimeException;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2021-10-11T13:52:11-0500")
public class ActiveMQJMSClientBundle_$bundle implements ActiveMQJMSClientBundle, Serializable {
    private static final long serialVersionUID = 1L;
    protected ActiveMQJMSClientBundle_$bundle() {}
    public static final ActiveMQJMSClientBundle_$bundle INSTANCE = new ActiveMQJMSClientBundle_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String invalidFilter$str() {
        return "AMQ139000: Invalid filter: {0}";
    }
    @Override
    public final ActiveMQInvalidFilterExpressionException invalidFilter(final Throwable e, final SimpleString filter) {
        final ActiveMQInvalidFilterExpressionException result = new ActiveMQInvalidFilterExpressionException(_formatMessage(invalidFilter$str(), filter));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String invalidSubscriptionName$str() {
        return "AMQ139001: Invalid Subscription Name. It is required to set the subscription name";
    }
    @Override
    public final ActiveMQIllegalStateException invalidSubscriptionName() {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(getLoggingLocale(), invalidSubscriptionName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String destinationDoesNotExist$str() {
        return "AMQ139002: Destination {0} does not exist";
    }
    @Override
    public final ActiveMQNonExistentQueueException destinationDoesNotExist(final SimpleString destination) {
        final ActiveMQNonExistentQueueException result = new ActiveMQNonExistentQueueException(_formatMessage(destinationDoesNotExist$str(), destination));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nameCannotBeNull$str() {
        return "AMQ139003: name cannot be null";
    }
    @Override
    public final IllegalArgumentException nameCannotBeNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nameCannotBeNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nameCannotBeEmpty$str() {
        return "AMQ139004: name cannot be empty";
    }
    @Override
    public final IllegalArgumentException nameCannotBeEmpty() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nameCannotBeEmpty$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String callingMethodFromListenerRuntime$str() {
        return "AMQ139005: It is illegal to call this method from within a Message Listener";
    }
    @Override
    public final IllegalStateRuntimeException callingMethodFromListenerRuntime() {
        final IllegalStateRuntimeException result = new IllegalStateRuntimeException(String.format(getLoggingLocale(), callingMethodFromListenerRuntime$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String callingMethodFromListener$str() {
        return "AMQ139006: It is illegal to call this method from within a Message Listener";
    }
    @Override
    public final IllegalStateException callingMethodFromListener() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), callingMethodFromListener$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String callingMethodFromCompletionListenerRuntime$str() {
        return "AMQ139007: It is illegal to call this method from within a Completion Listener";
    }
    @Override
    public final IllegalStateRuntimeException callingMethodFromCompletionListenerRuntime() {
        final IllegalStateRuntimeException result = new IllegalStateRuntimeException(String.format(getLoggingLocale(), callingMethodFromCompletionListenerRuntime$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String callingMethodFromCompletionListener$str() {
        return "AMQ139008: It is illegal to call this method from within a Completion Listener";
    }
    @Override
    public final IllegalStateException callingMethodFromCompletionListener() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), callingMethodFromCompletionListener$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullArgumentNotAllowed$str() {
        return "AMQ139009: Null {0} is not allowed";
    }
    @Override
    public final IllegalArgumentException nullArgumentNotAllowed(final String type) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(nullArgumentNotAllowed$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullTopic$str() {
        return "AMQ139010: Topic (Destination) cannot be null";
    }
    @Override
    public final InvalidDestinationException nullTopic() {
        final InvalidDestinationException result = new InvalidDestinationException(String.format(getLoggingLocale(), nullTopic$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String onlyValidForByteOrStreamMessages$str() {
        return "AMQ139011: LargeMessage streaming is only possible on ByteMessage or StreamMessage";
    }
    @Override
    public final IllegalStateException onlyValidForByteOrStreamMessages() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), onlyValidForByteOrStreamMessages$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidJavaIdentifier$str() {
        return "AMQ139012: The property name ''{0}'' is not a valid java identifier.";
    }
    @Override
    public final JMSRuntimeException invalidJavaIdentifier(final String propertyName) {
        final JMSRuntimeException result = new JMSRuntimeException(_formatMessage(invalidJavaIdentifier$str(), propertyName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String messageNotWritable$str() {
        return "AMQ139013: Message is read-only";
    }
    @Override
    public final MessageNotWriteableException messageNotWritable() {
        final MessageNotWriteableException result = new MessageNotWriteableException(String.format(getLoggingLocale(), messageNotWritable$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String messageNotReadable$str() {
        return "AMQ139014: Message is write-only";
    }
    @Override
    public final MessageNotReadableException messageNotReadable() {
        final MessageNotReadableException result = new MessageNotReadableException(String.format(getLoggingLocale(), messageNotReadable$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalDeliveryMode$str() {
        return "AMQ139015: Illegal deliveryMode value: {0}";
    }
    @Override
    public final JMSException illegalDeliveryMode(final int deliveryMode) {
        final JMSException result = new JMSException(_formatMessage(illegalDeliveryMode$str(), deliveryMode));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
