package org.apache.activemq.artemis.core.client;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.w3c.dom.Node;
import org.apache.activemq.artemis.api.core.ActiveMQInternalErrorException;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import java.lang.String;
import org.apache.activemq.artemis.api.core.ActiveMQLargeMessageException;
import java.lang.RuntimeException;
import org.apache.activemq.artemis.api.core.ActiveMQTransactionRolledBackException;
import java.lang.IllegalArgumentException;
import org.apache.activemq.artemis.api.core.ActiveMQTransactionOutcomeUnknownException;
import javax.annotation.processing.Generated;
import org.apache.activemq.artemis.api.core.ActiveMQIllegalStateException;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.api.core.ActiveMQDisconnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQInterceptorRejectedPacketException;
import java.lang.Exception;
import java.lang.Integer;
import org.apache.activemq.artemis.core.cluster.DiscoveryGroup;
import org.apache.activemq.artemis.api.core.ActiveMQUnBlockedException;
import org.apache.activemq.artemis.api.core.ActiveMQRoutingException;
import org.apache.activemq.artemis.api.core.ActiveMQLargeMessageInterruptedException;
import org.apache.activemq.artemis.api.core.ActiveMQAddressFullException;
import java.lang.Byte;
import org.apache.activemq.artemis.api.core.ActiveMQObjectClosedException;
import org.apache.activemq.artemis.api.core.ActiveMQConnectionTimedOutException;
import java.lang.Long;
import java.lang.Throwable;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import java.lang.Object;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2022-09-21T13:33:29-0400")
public class ActiveMQClientMessageBundle_$bundle implements ActiveMQClientMessageBundle, Serializable {
    private static final long serialVersionUID = 1L;
    protected ActiveMQClientMessageBundle_$bundle() {}
    public static final ActiveMQClientMessageBundle_$bundle INSTANCE = new ActiveMQClientMessageBundle_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String clientSessionClosed$str() {
        return "AMQ219000: ClientSession closed while creating session";
    }
    @Override
    public final ActiveMQInternalErrorException clientSessionClosed() {
        final ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(getLoggingLocale(), clientSessionClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String failedToCreateSession$str() {
        return "AMQ219001: Failed to create session";
    }
    @Override
    public final ActiveMQInternalErrorException failedToCreateSession(final Throwable t) {
        final ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(getLoggingLocale(), failedToCreateSession$str()), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String queueMisConfigured$str() {
        return "AMQ219003: Queue can not be both durable and temporary";
    }
    @Override
    public final ActiveMQInternalErrorException queueMisConfigured() {
        final ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(getLoggingLocale(), queueMisConfigured$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToInitialiseSessionFactory$str() {
        return "AMQ219004: Failed to initialise session factory";
    }
    @Override
    public final ActiveMQInternalErrorException failedToInitialiseSessionFactory(final Exception e) {
        final ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(getLoggingLocale(), failedToInitialiseSessionFactory$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nettyError$str() {
        return "AMQ219005: Exception in Netty transport";
    }
    @Override
    public final ActiveMQInternalErrorException nettyError() {
        final ActiveMQInternalErrorException result = new ActiveMQInternalErrorException(String.format(getLoggingLocale(), nettyError$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String channelDisconnected$str() {
        return "AMQ219006: Channel disconnected";
    }
    @Override
    public final ActiveMQNotConnectedException channelDisconnected() {
        final ActiveMQNotConnectedException result = new ActiveMQNotConnectedException(String.format(getLoggingLocale(), channelDisconnected$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotConnectToServers$str() {
        return "AMQ219007: Cannot connect to server(s). Tried with all available servers.";
    }
    @Override
    public final ActiveMQNotConnectedException cannotConnectToServers() {
        final ActiveMQNotConnectedException result = new ActiveMQNotConnectedException(String.format(getLoggingLocale(), cannotConnectToServers$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotConnectToStaticConnectors$str() {
        return "AMQ219008: Failed to connect to any static connectors";
    }
    @Override
    public final ActiveMQNotConnectedException cannotConnectToStaticConnectors(final Exception e) {
        final ActiveMQNotConnectedException result = new ActiveMQNotConnectedException(String.format(getLoggingLocale(), cannotConnectToStaticConnectors$str()));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotConnectToStaticConnectors2$str() {
        return "AMQ219009: Failed to connect to any static connectors";
    }
    @Override
    public final ActiveMQNotConnectedException cannotConnectToStaticConnectors2() {
        final ActiveMQNotConnectedException result = new ActiveMQNotConnectedException(String.format(getLoggingLocale(), cannotConnectToStaticConnectors2$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String connectionDestroyed$str() {
        return "AMQ219010: Connection is destroyed";
    }
    @Override
    public final ActiveMQNotConnectedException connectionDestroyed() {
        final ActiveMQNotConnectedException result = new ActiveMQNotConnectedException(String.format(getLoggingLocale(), connectionDestroyed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String connectionTimedOut$str() {
        return "AMQ219011: Did not receive data from server for {0}";
    }
    @Override
    public final ActiveMQConnectionTimedOutException connectionTimedOut(final Connection transportConnection) {
        final ActiveMQConnectionTimedOutException result = new ActiveMQConnectionTimedOutException(_formatMessage(connectionTimedOut$str(), transportConnection));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private String _formatMessage(final String format, final Object... args) {
        final java.text.MessageFormat formatter = new java.text.MessageFormat(format, getLoggingLocale());
        return formatter.format(args, new StringBuffer(), new java.text.FieldPosition(0)).toString();
    }
    protected String connectionTimedOutInInitialBroadcast$str() {
        return "AMQ219012: Timed out waiting to receive initial broadcast from cluster";
    }
    @Override
    public final ActiveMQConnectionTimedOutException connectionTimedOutInInitialBroadcast() {
        final ActiveMQConnectionTimedOutException result = new ActiveMQConnectionTimedOutException(String.format(getLoggingLocale(), connectionTimedOutInInitialBroadcast$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String connectionTimedOutOnReceiveTopology$str() {
        return "AMQ219013: Timed out waiting to receive cluster topology. Group:{0}";
    }
    @Override
    public final ActiveMQConnectionTimedOutException connectionTimedOutOnReceiveTopology(final DiscoveryGroup discoveryGroup) {
        final ActiveMQConnectionTimedOutException result = new ActiveMQConnectionTimedOutException(_formatMessage(connectionTimedOutOnReceiveTopology$str(), discoveryGroup));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String timedOutSendingPacket$str() {
        return "AMQ219014: Timed out after waiting {0} ms for response when sending packet {1}";
    }
    @Override
    public final ActiveMQConnectionTimedOutException timedOutSendingPacket(final long timeout, final Byte type) {
        final ActiveMQConnectionTimedOutException result = new ActiveMQConnectionTimedOutException(_formatMessage(timedOutSendingPacket$str(), timeout, type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String disconnected$str() {
        return "AMQ219015: The connection was disconnected because of server shutdown";
    }
    @Override
    public final ActiveMQDisconnectedException disconnected() {
        final ActiveMQDisconnectedException result = new ActiveMQDisconnectedException(String.format(getLoggingLocale(), disconnected$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unblockingACall$str() {
        return "AMQ219016: Connection failure detected. Unblocking a blocking call that will never get a response";
    }
    @Override
    public final ActiveMQUnBlockedException unblockingACall(final Throwable t) {
        final ActiveMQUnBlockedException result = new ActiveMQUnBlockedException(String.format(getLoggingLocale(), unblockingACall$str()));
        result.initCause(t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String consumerClosed$str() {
        return "AMQ219017: Consumer is closed";
    }
    @Override
    public final ActiveMQObjectClosedException consumerClosed() {
        final ActiveMQObjectClosedException result = new ActiveMQObjectClosedException(String.format(getLoggingLocale(), consumerClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String producerClosed$str() {
        return "AMQ219018: Producer is closed";
    }
    @Override
    public final ActiveMQObjectClosedException producerClosed() {
        final ActiveMQObjectClosedException result = new ActiveMQObjectClosedException(String.format(getLoggingLocale(), producerClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sessionClosed$str() {
        return "AMQ219019: Session is closed";
    }
    @Override
    public final ActiveMQObjectClosedException sessionClosed() {
        final ActiveMQObjectClosedException result = new ActiveMQObjectClosedException(String.format(getLoggingLocale(), sessionClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String messageHandlerSet$str() {
        return "AMQ219020: Cannot call receive(...) - a MessageHandler is set";
    }
    @Override
    public final ActiveMQIllegalStateException messageHandlerSet() {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(getLoggingLocale(), messageHandlerSet$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String inReceive$str() {
        return "AMQ219021: Cannot set MessageHandler - consumer is in receive(...)";
    }
    @Override
    public final ActiveMQIllegalStateException inReceive() {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(getLoggingLocale(), inReceive$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String headerSizeTooBig$str() {
        return "AMQ219022: Header size ({0}) is too big, use the messageBody for large data, or increase minLargeMessageSize";
    }
    @Override
    public final ActiveMQIllegalStateException headerSizeTooBig(final Integer headerSize) {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(_formatMessage(headerSizeTooBig$str(), headerSize));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String largeMessageLostSession$str() {
        return "AMQ219023: The large message lost connection with its session, either because of a rollback or a closed session";
    }
    @Override
    public final ActiveMQIllegalStateException largeMessageLostSession() {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(getLoggingLocale(), largeMessageLostSession$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noTCForSessionFactory$str() {
        return "AMQ219024: Could not select a TransportConfiguration to create SessionFactory";
    }
    @Override
    public final ActiveMQIllegalStateException noTCForSessionFactory() {
        final ActiveMQIllegalStateException result = new ActiveMQIllegalStateException(String.format(getLoggingLocale(), noTCForSessionFactory$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorSavingBody$str() {
        return "AMQ219025: Error saving the message body";
    }
    @Override
    public final ActiveMQLargeMessageException errorSavingBody(final Exception e) {
        final ActiveMQLargeMessageException result = new ActiveMQLargeMessageException(String.format(getLoggingLocale(), errorSavingBody$str()));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorReadingBody$str() {
        return "AMQ219026: Error reading the LargeMessageBody";
    }
    @Override
    public final ActiveMQLargeMessageException errorReadingBody(final Exception e) {
        final ActiveMQLargeMessageException result = new ActiveMQLargeMessageException(String.format(getLoggingLocale(), errorReadingBody$str()));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorClosingLargeMessage$str() {
        return "AMQ219027: Error closing stream from LargeMessageBody";
    }
    @Override
    public final ActiveMQLargeMessageException errorClosingLargeMessage(final Exception e) {
        final ActiveMQLargeMessageException result = new ActiveMQLargeMessageException(String.format(getLoggingLocale(), errorClosingLargeMessage$str()));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String timeoutOnLargeMessage$str() {
        return "AMQ219028: Timeout waiting for LargeMessage Body";
    }
    @Override
    public final ActiveMQLargeMessageException timeoutOnLargeMessage() {
        final ActiveMQLargeMessageException result = new ActiveMQLargeMessageException(String.format(getLoggingLocale(), timeoutOnLargeMessage$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorWritingLargeMessage$str() {
        return "AMQ219029: Error writing body of message";
    }
    @Override
    public final ActiveMQLargeMessageException errorWritingLargeMessage(final Exception e) {
        final ActiveMQLargeMessageException result = new ActiveMQLargeMessageException(String.format(getLoggingLocale(), errorWritingLargeMessage$str()));
        result.initCause(e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String txRolledBack$str() {
        return "AMQ219030: The transaction was rolled back on failover to a backup server";
    }
    @Override
    public final ActiveMQTransactionRolledBackException txRolledBack() {
        final ActiveMQTransactionRolledBackException result = new ActiveMQTransactionRolledBackException(String.format(getLoggingLocale(), txRolledBack$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String txOutcomeUnknown$str() {
        return "AMQ219031: The transaction was rolled back on failover however commit may have been successful";
    }
    @Override
    public final ActiveMQTransactionOutcomeUnknownException txOutcomeUnknown() {
        final ActiveMQTransactionOutcomeUnknownException result = new ActiveMQTransactionOutcomeUnknownException(String.format(getLoggingLocale(), txOutcomeUnknown$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidType$str() {
        return "AMQ219032: Invalid type: {0}";
    }
    @Override
    public final IllegalArgumentException invalidType(final Object type) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidType$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidEncodeType$str() {
        return "AMQ219033: Invalid type: {0}";
    }
    @Override
    public final IllegalArgumentException invalidEncodeType(final Object type) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidEncodeType$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidManagementParam$str() {
        return "AMQ219034: Params for management operations must be of the following type: int long double String boolean Map or array thereof but found {0}";
    }
    @Override
    public final IllegalArgumentException invalidManagementParam(final Object type) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidManagementParam$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidWindowSize$str() {
        return "AMQ219035: Invalid window size {0}";
    }
    @Override
    public final IllegalArgumentException invalidWindowSize(final Integer size) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidWindowSize$str(), size));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidCommandID$str() {
        return "AMQ219037: Invalid last Received Command ID: {0}";
    }
    @Override
    public final IllegalArgumentException invalidCommandID(final Integer lastReceivedCommandID) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(invalidCommandID$str(), lastReceivedCommandID));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noChannelToClose$str() {
        return "AMQ219038: Cannot find channel with id {0} to close";
    }
    @Override
    public final IllegalArgumentException noChannelToClose(final Long id) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(noChannelToClose$str(), id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String closeListenerCannotBeNull$str() {
        return "AMQ219039: Close Listener cannot be null";
    }
    @Override
    public final IllegalArgumentException closeListenerCannotBeNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), closeListenerCannotBeNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failListenerCannotBeNull$str() {
        return "AMQ219040: Fail Listener cannot be null";
    }
    @Override
    public final IllegalArgumentException failListenerCannotBeNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), failListenerCannotBeNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String connectionExists$str() {
        return "AMQ219041: Connection already exists with id {0}";
    }
    @Override
    public final IllegalArgumentException connectionExists(final Object id) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(connectionExists$str(), id));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullListener$str() {
        return "AMQ219042: Invalid argument null listener";
    }
    @Override
    public final IllegalArgumentException nullListener() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullListener$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nullHandler$str() {
        return "AMQ219043: Invalid argument null handler";
    }
    @Override
    public final IllegalArgumentException nullHandler() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nullHandler$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String firstNodeNull$str() {
        return "AMQ219045: the first node to be compared is null";
    }
    @Override
    public final IllegalArgumentException firstNodeNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), firstNodeNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String secondNodeNull$str() {
        return "AMQ219046: the second node to be compared is null";
    }
    @Override
    public final IllegalArgumentException secondNodeNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), secondNodeNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nodeHaveDifferentNames$str() {
        return "AMQ219047: nodes have different node names";
    }
    @Override
    public final IllegalArgumentException nodeHaveDifferentNames() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nodeHaveDifferentNames$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nodeHaveDifferentAttNumber$str() {
        return "AMQ219048: nodes have a different number of attributes";
    }
    @Override
    public final IllegalArgumentException nodeHaveDifferentAttNumber() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nodeHaveDifferentAttNumber$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String attsDontMatch$str() {
        return "AMQ219049: attribute {0}={1} does not match";
    }
    @Override
    public final IllegalArgumentException attsDontMatch(final String name, final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(attsDontMatch$str(), name, value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String oneNodeHasChildren$str() {
        return "AMQ219050: one node has children and the other does not";
    }
    @Override
    public final IllegalArgumentException oneNodeHasChildren() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), oneNodeHasChildren$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nodeHasDifferentChildNumber$str() {
        return "AMQ219051: nodes have a different number of children";
    }
    @Override
    public final IllegalArgumentException nodeHasDifferentChildNumber() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), nodeHasDifferentChildNumber$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mustBeBoolean$str() {
        return "AMQ219052: Element {0} requires a valid Boolean value, but ''{1}'' cannot be parsed as a Boolean";
    }
    @Override
    public final IllegalArgumentException mustBeBoolean(final Node elem, final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(mustBeBoolean$str(), elem, value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mustBeDouble$str() {
        return "AMQ219053: Element {0} requires a valid Double value, but ''{1}'' cannot be parsed as a Double";
    }
    @Override
    public final IllegalArgumentException mustBeDouble(final Node elem, final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(mustBeDouble$str(), elem, value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mustBeInteger$str() {
        return "AMQ219054: Element {0} requires a valid Integer value, but ''{1}'' cannot be parsed as an Integer";
    }
    @Override
    public final IllegalArgumentException mustBeInteger(final Node elem, final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(mustBeInteger$str(), elem, value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mustBeLong$str() {
        return "AMQ219055: Element {0} requires a valid Long value, but ''{1}'' cannot be parsed as a Long";
    }
    @Override
    public final IllegalArgumentException mustBeLong(final Node element, final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(mustBeLong$str(), element, value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errordecodingPassword$str() {
        return "AMQ219057: Error decoding password";
    }
    @Override
    public final IllegalArgumentException errordecodingPassword(final Exception e) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), errordecodingPassword$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String addressIsFull$str() {
        return "AMQ219058: Address \"{0}\" is full. Message encode size = {1}B";
    }
    @Override
    public final ActiveMQAddressFullException addressIsFull(final String addressName, final int size) {
        final ActiveMQAddressFullException result = new ActiveMQAddressFullException(_formatMessage(addressIsFull$str(), addressName, size));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String interceptorRejectedPacket$str() {
        return "AMQ219059: Interceptor {0} rejected packet in a blocking call. This call will never complete.";
    }
    @Override
    public final ActiveMQInterceptorRejectedPacketException interceptorRejectedPacket(final String interceptionResult) {
        final ActiveMQInterceptorRejectedPacketException result = new ActiveMQInterceptorRejectedPacketException(_formatMessage(interceptorRejectedPacket$str(), interceptionResult));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String largeMessageInterrupted$str() {
        return "AMQ219060: Large Message Transmission interrupted on consumer shutdown.";
    }
    @Override
    public final ActiveMQLargeMessageInterruptedException largeMessageInterrupted() {
        final ActiveMQLargeMessageInterruptedException result = new ActiveMQLargeMessageInterruptedException(String.format(getLoggingLocale(), largeMessageInterrupted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotSendPacketDuringFailover$str() {
        return "AMQ219061: Cannot send a packet while channel is failing over.";
    }
    @Override
    public final IllegalStateException cannotSendPacketDuringFailover() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotSendPacketDuringFailover$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String packetTransmissionInterrupted$str() {
        return "AMQ219062: Multi-packet transmission (e.g. Large Messages) interrupted because of a reconnection.";
    }
    @Override
    public final ActiveMQInterruptedException packetTransmissionInterrupted() {
        final ActiveMQInterruptedException result = new ActiveMQInterruptedException(String.format(getLoggingLocale(), packetTransmissionInterrupted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotSendPacketWhilstResponseCacheFull$str() {
        return "AMQ219063: Cannot send a packet while response cache is full.";
    }
    @Override
    public final IllegalStateException cannotSendPacketWhilstResponseCacheFull() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotSendPacketWhilstResponseCacheFull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPacket$str() {
        return "AMQ219064: Invalide packet: {0}";
    }
    @Override
    public final IllegalStateException invalidPacket(final byte type) {
        final IllegalStateException result = new IllegalStateException(_formatMessage(invalidPacket$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToHandlePacket$str() {
        return "AMQ219065: Failed to handle packet.";
    }
    @Override
    public final RuntimeException failedToHandlePacket(final Exception e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToHandlePacket$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String redirected$str() {
        return "AMQ219066: The connection was redirected";
    }
    @Override
    public final ActiveMQRoutingException redirected() {
        final ActiveMQRoutingException result = new ActiveMQRoutingException(String.format(getLoggingLocale(), redirected$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String keystoreAliasNotFound$str() {
        return "AMQ219067: Keystore alias {0} not found in {1}";
    }
    @Override
    public final IllegalArgumentException keystoreAliasNotFound(final String keystoreAlias, final String keystorePath) {
        final IllegalArgumentException result = new IllegalArgumentException(_formatMessage(keystoreAliasNotFound$str(), keystoreAlias, keystorePath));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
