package io.undertow;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import io.undertow.util.ParameterLimitException;
import io.undertow.protocols.http2.HpackException;
import org.xnio.channels.ReadTimeoutException;
import java.lang.String;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.xnio.channels.WriteTimeoutException;
import java.lang.RuntimeException;
import java.lang.NullPointerException;
import io.undertow.server.handlers.form.MultiPartParserDefinition.FileTooLargeException;
import io.undertow.util.UrlDecodeException;
import java.lang.IllegalArgumentException;
import java.nio.file.Path;
import java.nio.channels.ClosedChannelException;
import javax.annotation.processing.Generated;
import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.server.RequestTooBigException;
import javax.net.ssl.SSLPeerUnverifiedException;
import java.io.IOException;
import java.lang.Exception;
import java.lang.Long;
import io.undertow.util.BadRequestException;
import java.lang.Throwable;
import java.lang.Class;
import java.lang.Object;
import java.util.Arrays;
import io.undertow.util.HttpString;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageBundleImplementor", date = "2024-02-21T04:11:51-0300")
public class UndertowMessages_$bundle implements UndertowMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected UndertowMessages_$bundle() {}
    public static final UndertowMessages_$bundle INSTANCE = new UndertowMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String maximumConcurrentRequestsMustBeLargerThanZero$str() {
        return "UT000001: Maximum concurrent requests must be larger than zero.";
    }
    @Override
    public final IllegalArgumentException maximumConcurrentRequestsMustBeLargerThanZero() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), maximumConcurrentRequestsMustBeLargerThanZero$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String responseAlreadyStarted$str() {
        return "UT000002: The response has already been started";
    }
    @Override
    public final IllegalStateException responseAlreadyStarted() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), responseAlreadyStarted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String responseChannelAlreadyProvided$str() {
        return "UT000004: getResponseChannel() has already been called";
    }
    @Override
    public final IllegalStateException responseChannelAlreadyProvided() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), responseChannelAlreadyProvided$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requestChannelAlreadyProvided$str() {
        return "UT000005: getRequestChannel() has already been called";
    }
    @Override
    public final IllegalStateException requestChannelAlreadyProvided() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), requestChannelAlreadyProvided$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String handlerCannotBeNull$str() {
        return "UT000008: Handler cannot be null";
    }
    @Override
    public final IllegalArgumentException handlerCannotBeNull() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), handlerCannotBeNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String pathMustBeSpecified$str() {
        return "UT000009: Path must be specified";
    }
    @Override
    public final IllegalArgumentException pathMustBeSpecified() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), pathMustBeSpecified$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sessionIsInvalid$str() {
        return "UT000010: Session is invalid %s";
    }
    @Override
    public final IllegalStateException sessionIsInvalid(final String sessionId) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), sessionIsInvalid$str(), sessionId));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sessionManagerMustNotBeNull$str() {
        return "UT000011: Session manager must not be null";
    }
    @Override
    public final IllegalStateException sessionManagerMustNotBeNull() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), sessionManagerMustNotBeNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sessionManagerNotFound$str() {
        return "UT000012: Session manager was not attached to the request. Make sure that the SessionAttachmentHandler is installed in the handler chain";
    }
    @Override
    public final IllegalStateException sessionManagerNotFound() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), sessionManagerNotFound$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String argumentCannotBeNull$str() {
        return "UT000013: Argument %s cannot be null";
    }
    @Override
    public final IllegalArgumentException argumentCannotBeNull(final String argument) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), argumentCannotBeNull$str(), argument));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String formValueIsAFile$str() {
        return "UT000017: Form value is a file, use getFileItem() instead";
    }
    @Override
    public final IllegalStateException formValueIsAFile() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), formValueIsAFile$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String formValueIsAString$str() {
        return "UT000018: Form value is a String, use getValue() instead";
    }
    @Override
    public final IllegalStateException formValueIsAString() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), formValueIsAString$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requestEntityWasTooLarge$str() {
        return "UT000020: Connection terminated as request was larger than %s";
    }
    @Override
    public final RequestTooBigException requestEntityWasTooLarge(final long size) {
        final RequestTooBigException result = new RequestTooBigException(String.format(getLoggingLocale(), requestEntityWasTooLarge$str(), size));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sessionAlreadyInvalidated$str() {
        return "UT000021: Session already invalidated";
    }
    @Override
    public final IllegalStateException sessionAlreadyInvalidated() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), sessionAlreadyInvalidated$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String hashAlgorithmNotFound$str() {
        return "UT000022: The specified hash algorithm '%s' can not be found.";
    }
    @Override
    public final IllegalArgumentException hashAlgorithmNotFound(final String algorithmName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), hashAlgorithmNotFound$str(), algorithmName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidBase64Token$str() {
        return "UT000023: An invalid Base64 token has been received.";
    }
    @Override
    public final IllegalArgumentException invalidBase64Token(final IOException cause) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidBase64Token$str()), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidNonceReceived$str() {
        return "UT000024: An invalidly formatted nonce has been received.";
    }
    @Override
    public final IllegalArgumentException invalidNonceReceived() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidNonceReceived$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedTokenInHeader$str() {
        return "UT000025: Unexpected token '%s' within header.";
    }
    @Override
    public final IllegalArgumentException unexpectedTokenInHeader(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unexpectedTokenInHeader$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidHeader$str() {
        return "UT000026: Invalid header received.";
    }
    @Override
    public final IllegalArgumentException invalidHeader() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidHeader$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotFindSessionCookieConfig$str() {
        return "UT000027: Could not find session cookie config in the request";
    }
    @Override
    public final IllegalStateException couldNotFindSessionCookieConfig() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), couldNotFindSessionCookieConfig$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String chunkedChannelClosedMidChunk$str() {
        return "UT000029: Channel was closed mid chunk, if you have attempted to write chunked data you cannot shutdown the channel until after it has all been written.";
    }
    @Override
    public final IOException chunkedChannelClosedMidChunk() {
        final IOException result = new IOException(String.format(getLoggingLocale(), chunkedChannelClosedMidChunk$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String userAuthenticated$str() {
        return "UT000030: User %s successfully authenticated.";
    }
    @Override
    public final String userAuthenticated(final String userName) {
        return String.format(getLoggingLocale(), userAuthenticated$str(), userName);
    }
    protected String userLoggedOut$str() {
        return "UT000031: User %s has logged out.";
    }
    @Override
    public final String userLoggedOut(final String userName) {
        return String.format(getLoggingLocale(), userLoggedOut$str(), userName);
    }
    protected String streamIsClosed$str() {
        return "UT000034: Stream is closed";
    }
    @Override
    public final IOException streamIsClosed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), streamIsClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String startBlockingHasNotBeenCalled$str() {
        return "UT000035: Cannot get stream as startBlocking has not been invoked";
    }
    @Override
    public final IllegalStateException startBlockingHasNotBeenCalled() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), startBlockingHasNotBeenCalled$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String connectionTerminatedReadingMultiPartData$str() {
        return "UT000036: Connection terminated parsing multipart data";
    }
    @Override
    public final IOException connectionTerminatedReadingMultiPartData() {
        final IOException result = new IOException(String.format(getLoggingLocale(), connectionTerminatedReadingMultiPartData$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToParsePath$str() {
        return "UT000037: Failed to parse path in HTTP request";
    }
    @Override
    public final RuntimeException failedToParsePath() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToParsePath$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authenticationFailed$str() {
        return "UT000038: Authentication failed, requested user name '%s'";
    }
    @Override
    public final String authenticationFailed(final String userName) {
        return String.format(getLoggingLocale(), authenticationFailed$str(), userName);
    }
    protected String tooManyQueryParameters$str() {
        return "UT000039: Too many query parameters, cannot have more than %s query parameters";
    }
    @Override
    public final BadRequestException tooManyQueryParameters(final int noParams) {
        final BadRequestException result = new BadRequestException(String.format(getLoggingLocale(), tooManyQueryParameters$str(), noParams));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tooManyHeaders$str() {
        return "UT000040: Too many headers, cannot have more than %s header";
    }
    @Override
    public final String tooManyHeaders(final int noParams) {
        return String.format(getLoggingLocale(), tooManyHeaders$str(), noParams);
    }
    protected String channelIsClosed$str() {
        return "UT000041: Channel is closed";
    }
    @Override
    public final ClosedChannelException channelIsClosed() {
        final ClosedChannelException result = new ClosedChannelException();
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotDecodeTrailers$str() {
        return "UT000042: Could not decode trailers in HTTP request";
    }
    @Override
    public final IOException couldNotDecodeTrailers() {
        final IOException result = new IOException(String.format(getLoggingLocale(), couldNotDecodeTrailers$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String dataAlreadyQueued$str() {
        return "UT000043: Data is already being sent. You must wait for the completion callback to be be invoked before calling send() again";
    }
    @Override
    public final IllegalStateException dataAlreadyQueued() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), dataAlreadyQueued$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String moreThanOnePredicateWithName$str() {
        return "UT000044: More than one predicate with name %s. Builder class %s and %s";
    }
    @Override
    public final IllegalStateException moreThanOnePredicateWithName(final String name, final Class<? extends io.undertow.predicate.PredicateBuilder> aClass, final Class<? extends io.undertow.predicate.PredicateBuilder> existing) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), moreThanOnePredicateWithName$str(), name, aClass, existing));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String errorParsingPredicateString$str() {
        return "UT000045: Error parsing predicated handler string %s:%n%s";
    }
    @Override
    public final IllegalArgumentException errorParsingPredicateString(final String reason, final String s) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), errorParsingPredicateString$str(), reason, s));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tooManyCookies$str() {
        return "UT000046: The number of cookies sent exceeded the maximum of %s";
    }
    @Override
    public final IllegalStateException tooManyCookies(final int maxCookies) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), tooManyCookies$str(), maxCookies));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tooManyParameters$str() {
        return "UT000047: The number of parameters exceeded the maximum of %s";
    }
    @Override
    public final ParameterLimitException tooManyParameters(final int maxValues) {
        final ParameterLimitException result = new ParameterLimitException(String.format(getLoggingLocale(), tooManyParameters$str(), maxValues));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noRequestActive$str() {
        return "UT000048: No request is currently active";
    }
    @Override
    public final IllegalStateException noRequestActive() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noRequestActive$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authMechanismOutcomeNull$str() {
        return "UT000050: AuthenticationMechanism Outcome is null";
    }
    @Override
    public final IllegalStateException authMechanismOutcomeNull() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), authMechanismOutcomeNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notAValidIpPattern$str() {
        return "UT000051: Not a valid IP pattern %s";
    }
    @Override
    public final IllegalArgumentException notAValidIpPattern(final String peer) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), notAValidIpPattern$str(), peer));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSessionData$str() {
        return "UT000052: Session data requested when non session based authentication in use";
    }
    @Override
    public final IllegalStateException noSessionData() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noSessionData$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String listenerAlreadyRegistered$str() {
        return "UT000053: Listener %s already registered";
    }
    @Override
    public final IllegalArgumentException listenerAlreadyRegistered(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), listenerAlreadyRegistered$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String maxFileSizeExceeded$str() {
        return "UT000054: The maximum size %s for an individual file in a multipart request was exceeded";
    }
    @Override
    public final FileTooLargeException maxFileSizeExceeded(final long maxIndividualFileSize) {
        final FileTooLargeException result = new FileTooLargeException(String.format(getLoggingLocale(), maxFileSizeExceeded$str(), maxIndividualFileSize));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotSetAttribute$str() {
        return "UT000055: Could not set attribute %s to %s as it is read only";
    }
    @Override
    public final String couldNotSetAttribute(final String attributeName, final String newValue) {
        return String.format(getLoggingLocale(), couldNotSetAttribute$str(), attributeName, newValue);
    }
    protected String couldNotParseUriTemplate$str() {
        return "UT000056: Could not parse URI template %s, exception at char %s";
    }
    @Override
    public final RuntimeException couldNotParseUriTemplate(final String path, final int i) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotParseUriTemplate$str(), path, i));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mismatchedBraces$str() {
        return "UT000057: Mismatched braces in attribute string %s";
    }
    @Override
    public final RuntimeException mismatchedBraces(final String valueString) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), mismatchedBraces$str(), valueString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String moreThanOneHandlerWithName$str() {
        return "UT000058: More than one handler with name %s. Builder class %s and %s";
    }
    @Override
    public final IllegalStateException moreThanOneHandlerWithName(final String name, final Class<? extends io.undertow.server.handlers.builder.HandlerBuilder> aClass, final Class<? extends io.undertow.server.handlers.builder.HandlerBuilder> existing) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), moreThanOneHandlerWithName$str(), name, aClass, existing));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String outOfBandResponseOnlyAllowedFor100Continue$str() {
        return "UT000061: Out of band responses only allowed for 100-continue requests";
    }
    @Override
    public final IllegalArgumentException outOfBandResponseOnlyAllowedFor100Continue() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), outOfBandResponseOnlyAllowedFor100Continue$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sslWasNull$str() {
        return "UT000065: SSL must be specified to connect to a https URL";
    }
    @Override
    public final IOException sslWasNull() {
        final IOException result = new IOException(String.format(getLoggingLocale(), sslWasNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String wrongMagicNumber$str() {
        return "UT000066: Incorrect magic number %s for AJP packet header";
    }
    @Override
    public final IOException wrongMagicNumber(final int number) {
        final IOException result = new IOException(String.format(getLoggingLocale(), wrongMagicNumber$str(), number));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String peerUnverified$str() {
        return "UT000067: No client cert was provided";
    }
    @Override
    public final SSLPeerUnverifiedException peerUnverified() {
        final SSLPeerUnverifiedException result = new SSLPeerUnverifiedException(String.format(getLoggingLocale(), peerUnverified$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String servletPathMatchFailed$str() {
        return "UT000068: Servlet path match failed";
    }
    @Override
    public final IllegalArgumentException servletPathMatchFailed() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), servletPathMatchFailed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotParseCookie$str() {
        return "UT000069: Could not parse set cookie header %s";
    }
    @Override
    public final IllegalArgumentException couldNotParseCookie(final String headerValue) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), couldNotParseCookie$str(), headerValue));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String canOnlyBeCalledByIoThread$str() {
        return "UT000070: method can only be called by IO thread";
    }
    @Override
    public final IllegalStateException canOnlyBeCalledByIoThread() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), canOnlyBeCalledByIoThread$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String matcherAlreadyContainsTemplate$str() {
        return "UT000071: Cannot add path template %s, matcher already contains an equivalent pattern %s";
    }
    @Override
    public final IllegalStateException matcherAlreadyContainsTemplate(final String templateString, final String templateString1) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), matcherAlreadyContainsTemplate$str(), templateString, templateString1));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToDecodeURL$str() {
        return "UT000072: Failed to decode url %s to charset %s";
    }
    @Override
    public final UrlDecodeException failedToDecodeURL(final String s, final String enc, final Exception e) {
        final UrlDecodeException result = new UrlDecodeException(String.format(getLoggingLocale(), failedToDecodeURL$str(), s, enc), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String resourceChangeListenerNotSupported$str() {
        return "UT000073: Resource change listeners are not supported";
    }
    @Override
    public final IllegalArgumentException resourceChangeListenerNotSupported() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), resourceChangeListenerNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String objectWasFreed$str() {
        return "UT000075: Object was freed";
    }
    @Override
    public final IllegalStateException objectWasFreed() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), objectWasFreed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String handlerNotShutdown$str() {
        return "UT000076: Handler not shutdown";
    }
    @Override
    public final IllegalStateException handlerNotShutdown() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), handlerNotShutdown$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String upgradeNotSupported$str() {
        return "UT000077: The underlying transport does not support HTTP upgrade";
    }
    @Override
    public final IllegalStateException upgradeNotSupported() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), upgradeNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String renegotiationNotSupported$str() {
        return "UT000078: Renegotiation not supported";
    }
    @Override
    public final IOException renegotiationNotSupported() {
        final IOException result = new IOException(String.format(getLoggingLocale(), renegotiationNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notAValidRegularExpressionPattern$str() {
        return "UT000080: Not a valid regular expression pattern %s";
    }
    @Override
    public final IllegalArgumentException notAValidRegularExpressionPattern(final String pattern) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), notAValidRegularExpressionPattern$str(), pattern));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String badRequest$str() {
        return "UT000081: Bad request";
    }
    @Override
    public final BadRequestException badRequest() {
        final BadRequestException result = new BadRequestException(String.format(getLoggingLocale(), badRequest$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String hostAlreadyRegistered$str() {
        return "UT000082: Host %s already registered";
    }
    @Override
    public final RuntimeException hostAlreadyRegistered(final Object host) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), hostAlreadyRegistered$str(), host));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String hostHasNotBeenRegistered$str() {
        return "UT000083: Host %s has not been registered";
    }
    @Override
    public final RuntimeException hostHasNotBeenRegistered(final Object host) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), hostHasNotBeenRegistered$str(), host));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String extraDataWrittenAfterChunkEnd$str() {
        return "UT000084: Attempted to write additional data after the last chunk";
    }
    @Override
    public final IOException extraDataWrittenAfterChunkEnd() {
        final IOException result = new IOException(String.format(getLoggingLocale(), extraDataWrittenAfterChunkEnd$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotGenerateUniqueSessionId$str() {
        return "UT000085: Could not generate unique session id";
    }
    @Override
    public final RuntimeException couldNotGenerateUniqueSessionId() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), couldNotGenerateUniqueSessionId$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String controlFrameCannotHaveBodyContent$str() {
        return "UT000088: SPDY control frames cannot have body content";
    }
    @Override
    public final IOException controlFrameCannotHaveBodyContent() {
        final IOException result = new IOException(String.format(getLoggingLocale(), controlFrameCannotHaveBodyContent$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String bufferAlreadyFreed$str() {
        return "UT000091: Buffer has already been freed";
    }
    @Override
    public final IllegalStateException bufferAlreadyFreed() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), bufferAlreadyFreed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String awaitCalledFromIoThread$str() {
        return "UT000094: Blocking await method called from IO thread. Blocking IO must be dispatched to a worker thread or deadlocks will result.";
    }
    @Override
    public final IOException awaitCalledFromIoThread() {
        final IOException result = new IOException(String.format(getLoggingLocale(), awaitCalledFromIoThread$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String recursiveCallToFlushingSenders$str() {
        return "UT000095: Recursive call to flushSenders()";
    }
    @Override
    public final RuntimeException recursiveCallToFlushingSenders() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), recursiveCallToFlushingSenders$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fixedLengthOverflow$str() {
        return "UT000096: More data was written to the channel than specified in the content-length";
    }
    @Override
    public final IllegalStateException fixedLengthOverflow() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), fixedLengthOverflow$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String ajpRequestAlreadyInProgress$str() {
        return "UT000097: AJP request already in progress";
    }
    @Override
    public final IllegalStateException ajpRequestAlreadyInProgress() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), ajpRequestAlreadyInProgress$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String httpPingDataMustBeLength8$str() {
        return "UT000098: HTTP ping data must be 8 bytes in length";
    }
    @Override
    public final String httpPingDataMustBeLength8() {
        return String.format(getLoggingLocale(), httpPingDataMustBeLength8$str());
    }
    protected String invalidPingSize$str() {
        return "UT000099: Received a ping of size other than 8";
    }
    @Override
    public final String invalidPingSize() {
        return String.format(getLoggingLocale(), invalidPingSize$str());
    }
    protected String streamIdMustBeZeroForFrameType$str() {
        return "UT000100: stream id must be zero for frame type %s";
    }
    @Override
    public final String streamIdMustBeZeroForFrameType(final int frameType) {
        return String.format(getLoggingLocale(), streamIdMustBeZeroForFrameType$str(), frameType);
    }
    protected String streamIdMustNotBeZeroForFrameType$str() {
        return "UT000101: stream id must not be zero for frame type %s";
    }
    @Override
    public final String streamIdMustNotBeZeroForFrameType(final int frameType) {
        return String.format(getLoggingLocale(), streamIdMustNotBeZeroForFrameType$str(), frameType);
    }
    protected String http2StreamWasReset$str() {
        return "UT000103: Http2 stream was reset";
    }
    @Override
    public final IOException http2StreamWasReset() {
        final IOException result = new IOException(String.format(getLoggingLocale(), http2StreamWasReset$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String incorrectHttp2Preface$str() {
        return "UT000104: Incorrect HTTP2 preface";
    }
    @Override
    public final IOException incorrectHttp2Preface() {
        final IOException result = new IOException(String.format(getLoggingLocale(), incorrectHttp2Preface$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String http2FrameTooLarge$str() {
        return "UT000105: HTTP2 frame to large";
    }
    @Override
    public final IOException http2FrameTooLarge() {
        final IOException result = new IOException(String.format(getLoggingLocale(), http2FrameTooLarge$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String http2ContinuationFrameNotExpected$str() {
        return "UT000106: HTTP2 continuation frame received without a corresponding headers or push promise frame";
    }
    @Override
    public final IOException http2ContinuationFrameNotExpected() {
        final IOException result = new IOException(String.format(getLoggingLocale(), http2ContinuationFrameNotExpected$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String huffmanEncodedHpackValueDidNotEndWithEOS$str() {
        return "UT000107: Huffman encoded value in HPACK headers did not end with EOS padding";
    }
    @Override
    public final HpackException huffmanEncodedHpackValueDidNotEndWithEOS() {
        final HpackException result = new HpackException();
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String integerEncodedOverTooManyOctets$str() {
        return "UT000108: HPACK variable length integer encoded over too many octects, max is %s";
    }
    @Override
    public final HpackException integerEncodedOverTooManyOctets(final int maxIntegerOctets) {
        final HpackException result = new HpackException();
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String zeroNotValidHeaderTableIndex$str() {
        return "UT000109: Zero is not a valid header table index";
    }
    @Override
    public final HpackException zeroNotValidHeaderTableIndex() {
        final HpackException result = new HpackException();
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotSendContinueResponse$str() {
        return "UT000110: Cannot send 100-Continue, getResponseChannel() has already been called";
    }
    @Override
    public final IOException cannotSendContinueResponse() {
        final IOException result = new IOException(String.format(getLoggingLocale(), cannotSendContinueResponse$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String parserDidNotMakeProgress$str() {
        return "UT000111: Parser did not make progress";
    }
    @Override
    public final IOException parserDidNotMakeProgress() {
        final IOException result = new IOException(String.format(getLoggingLocale(), parserDidNotMakeProgress$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String headersStreamCanOnlyBeCreatedByClient$str() {
        return "UT000112: Only client side can call createStream, if you wish to send a PUSH_PROMISE frame use createPushPromiseStream instead";
    }
    @Override
    public final IOException headersStreamCanOnlyBeCreatedByClient() {
        final IOException result = new IOException(String.format(getLoggingLocale(), headersStreamCanOnlyBeCreatedByClient$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String pushPromiseCanOnlyBeCreatedByServer$str() {
        return "UT000113: Only the server side can send a push promise stream";
    }
    @Override
    public final IOException pushPromiseCanOnlyBeCreatedByServer() {
        final IOException result = new IOException(String.format(getLoggingLocale(), pushPromiseCanOnlyBeCreatedByServer$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidAclRule$str() {
        return "UT000114: Invalid IP access control rule %s. Format is: [ip-match] allow|deny";
    }
    @Override
    public final IllegalArgumentException invalidAclRule(final String rule) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidAclRule$str(), rule));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String serverReceivedPushPromise$str() {
        return "UT000115: Server received PUSH_PROMISE frame from client";
    }
    @Override
    public final IOException serverReceivedPushPromise() {
        final IOException result = new IOException(String.format(getLoggingLocale(), serverReceivedPushPromise$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String connectNotSupported$str() {
        return "UT000116: CONNECT not supported by this connector";
    }
    @Override
    public final IllegalStateException connectNotSupported() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), connectNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notAConnectRequest$str() {
        return "UT000117: Request was not a CONNECT request";
    }
    @Override
    public final IllegalStateException notAConnectRequest() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), notAConnectRequest$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotResetBuffer$str() {
        return "UT000118: Cannot reset buffer, response has already been commited";
    }
    @Override
    public final IllegalStateException cannotResetBuffer() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotResetBuffer$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String http2PriRequestFailed$str() {
        return "UT000119: HTTP2 via prior knowledge failed";
    }
    @Override
    public final IOException http2PriRequestFailed() {
        final IOException result = new IOException(String.format(getLoggingLocale(), http2PriRequestFailed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String outOfBandResponseNotSupported$str() {
        return "UT000120: Out of band responses are not allowed for this connector";
    }
    @Override
    public final IllegalStateException outOfBandResponseNotSupported() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), outOfBandResponseNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tooManySessions$str() {
        return "UT000121: Session was rejected as the maximum number of sessions (%s) has been hit";
    }
    @Override
    public final IllegalStateException tooManySessions(final int maxSessions) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), tooManySessions$str(), maxSessions));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String proxyConnectionFailed$str() {
        return "UT000122: CONNECT attempt failed as target proxy returned %s";
    }
    @Override
    public final IOException proxyConnectionFailed(final int responseCode) {
        final IOException result = new IOException(String.format(getLoggingLocale(), proxyConnectionFailed$str(), responseCode));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mcmpMessageRejectedDueToSuspiciousCharacters$str() {
        return "UT000123: MCMP message %s rejected due to suspicious characters";
    }
    @Override
    public final RuntimeException mcmpMessageRejectedDueToSuspiciousCharacters(final String data) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), mcmpMessageRejectedDueToSuspiciousCharacters$str(), data));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String rengotiationTimedOut$str() {
        return "UT000124: renegotiation timed out";
    }
    @Override
    public final IllegalStateException rengotiationTimedOut() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), rengotiationTimedOut$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requestBodyAlreadyRead$str() {
        return "UT000125: Request body already read";
    }
    @Override
    public final IllegalStateException requestBodyAlreadyRead() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), requestBodyAlreadyRead$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String blockingIoFromIOThread$str() {
        return "UT000126: Attempted to do blocking IO from the IO thread. This is prohibited as it may result in deadlocks";
    }
    @Override
    public final IllegalStateException blockingIoFromIOThread() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), blockingIoFromIOThread$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String responseComplete$str() {
        return "UT000127: Response has already been sent";
    }
    @Override
    public final IllegalStateException responseComplete() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), responseComplete$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String couldNotReadContentLengthData$str() {
        return "UT000128: Remote peer closed connection before all data could be read";
    }
    @Override
    public final IOException couldNotReadContentLengthData() {
        final IOException result = new IOException(String.format(getLoggingLocale(), couldNotReadContentLengthData$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToSendAfterBeingSafe$str() {
        return "UT000129: Failed to send after being safe to send";
    }
    @Override
    public final IllegalStateException failedToSendAfterBeingSafe() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), failedToSendAfterBeingSafe$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String reasonPhraseToLargeForBuffer$str() {
        return "UT000130: HTTP reason phrase was too large for the buffer. Either provide a smaller message or a bigger buffer. Phrase: %s";
    }
    @Override
    public final IllegalStateException reasonPhraseToLargeForBuffer(final String phrase) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), reasonPhraseToLargeForBuffer$str(), phrase));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String poolIsClosed$str() {
        return "UT000131: Buffer pool is closed";
    }
    @Override
    public final IllegalStateException poolIsClosed() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), poolIsClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String hpackFailed$str() {
        return "UT000132: HPACK decode failed";
    }
    @Override
    public final HpackException hpackFailed() {
        final HpackException result = new HpackException();
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notAnUpgradeRequest$str() {
        return "UT000133: Request did not contain an Upgrade header, upgrade is not permitted";
    }
    @Override
    public final IllegalStateException notAnUpgradeRequest() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), notAnUpgradeRequest$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authenticationPropertyNotSet$str() {
        return "UT000134: Authentication mechanism %s requires property %s to be set";
    }
    @Override
    public final IllegalStateException authenticationPropertyNotSet(final String name, final String header) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), authenticationPropertyNotSet$str(), name, header));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String rengotiationFailed$str() {
        return "UT000135: renegotiation failed";
    }
    @Override
    public final IllegalStateException rengotiationFailed() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), rengotiationFailed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String userAgentCharsetMustHaveEvenNumberOfItems$str() {
        return "UT000136: User agent charset string must have an even number of items, in the form pattern,charset,pattern,charset,... Instead got: %s";
    }
    @Override
    public final IllegalArgumentException userAgentCharsetMustHaveEvenNumberOfItems(final String supplied) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), userAgentCharsetMustHaveEvenNumberOfItems$str(), supplied));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String datasourceNotFound$str() {
        return "UT000137: Could not find the datasource called %s";
    }
    @Override
    public final IllegalArgumentException datasourceNotFound(final String ds) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), datasourceNotFound$str(), ds));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String serverNotStarted$str() {
        return "UT000138: Server not started";
    }
    @Override
    public final IllegalStateException serverNotStarted() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serverNotStarted$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String exchangeAlreadyComplete$str() {
        return "UT000139: Exchange already complete";
    }
    @Override
    public final IllegalStateException exchangeAlreadyComplete() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), exchangeAlreadyComplete$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notHandshakeRecord$str() {
        return "UT000140: Initial SSL/TLS data is not a handshake record";
    }
    @Override
    public final SSLHandshakeException notHandshakeRecord() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(getLoggingLocale(), notHandshakeRecord$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidHandshakeRecord$str() {
        return "UT000141: Initial SSL/TLS handshake record is invalid";
    }
    @Override
    public final SSLHandshakeException invalidHandshakeRecord() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(getLoggingLocale(), invalidHandshakeRecord$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multiRecordSSLHandshake$str() {
        return "UT000142: Initial SSL/TLS handshake spans multiple records";
    }
    @Override
    public final SSLHandshakeException multiRecordSSLHandshake() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(getLoggingLocale(), multiRecordSSLHandshake$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String expectedClientHello$str() {
        return "UT000143: Expected \"client hello\" record";
    }
    @Override
    public final SSLHandshakeException expectedClientHello() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(getLoggingLocale(), expectedClientHello$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String expectedServerHello$str() {
        return "UT000144: Expected server hello";
    }
    @Override
    public final SSLHandshakeException expectedServerHello() {
        final SSLHandshakeException result = new SSLHandshakeException(String.format(getLoggingLocale(), expectedServerHello$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tooManyRedirects$str() {
        return "UT000145: Too many redirects";
    }
    @Override
    public final IOException tooManyRedirects(final IOException exception) {
        final IOException result = new IOException(String.format(getLoggingLocale(), tooManyRedirects$str()), exception);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String resumedAndDispatched$str() {
        return "UT000146: HttpServerExchange cannot have both async IO resumed and dispatch() called in the same cycle";
    }
    @Override
    public final IllegalStateException resumedAndDispatched() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), resumedAndDispatched$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noHostInHttp11Request$str() {
        return "UT000147: No host header in a HTTP/1.1 request";
    }
    @Override
    public final IOException noHostInHttp11Request() {
        final IOException result = new IOException(String.format(getLoggingLocale(), noHostInHttp11Request$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidHpackEncoding$str() {
        return "UT000148: Invalid HPack encoding. First byte: %s";
    }
    @Override
    public final HpackException invalidHpackEncoding(final byte b) {
        final HpackException result = new HpackException();
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String newlineNotSupportedInHttpString$str() {
        return "UT000149: HttpString is not allowed to contain newlines. value: %s";
    }
    @Override
    public final IllegalArgumentException newlineNotSupportedInHttpString(final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), newlineNotSupportedInHttpString$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String pseudoHeaderInWrongOrder$str() {
        return "UT000150: Pseudo header %s received after receiving normal headers. Pseudo headers must be the first headers in a HTTP/2 header block.";
    }
    @Override
    public final String pseudoHeaderInWrongOrder(final HttpString header) {
        return String.format(getLoggingLocale(), pseudoHeaderInWrongOrder$str(), header);
    }
    protected String expectedContinuationFrame$str() {
        return "UT000151: Expected to receive a continuation frame";
    }
    @Override
    public final String expectedContinuationFrame() {
        return String.format(getLoggingLocale(), expectedContinuationFrame$str());
    }
    protected String incorrectFrameSize$str() {
        return "UT000152: Incorrect frame size";
    }
    @Override
    public final String incorrectFrameSize() {
        return String.format(getLoggingLocale(), incorrectFrameSize$str());
    }
    protected String streamNotRegistered$str() {
        return "UT000153: Stream id not registered";
    }
    @Override
    public final IllegalStateException streamNotRegistered() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), streamNotRegistered$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sendChallengeReturnedNull$str() {
        return "UT000154: Mechanism %s returned a null result from sendChallenge()";
    }
    @Override
    public final NullPointerException sendChallengeReturnedNull(final AuthenticationMechanism mechanism) {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), sendChallengeReturnedNull$str(), mechanism));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String bodyIsSetAndNotReadyForFlush$str() {
        return "UT000155: Framed channel body was set when it was not ready for flush";
    }
    @Override
    public final IllegalStateException bodyIsSetAndNotReadyForFlush() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), bodyIsSetAndNotReadyForFlush$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidGzipHeader$str() {
        return "UT000156: Invalid GZIP header";
    }
    @Override
    public final IOException invalidGzipHeader() {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidGzipHeader$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidGZIPFooter$str() {
        return "UT000157: Invalid GZIP footer";
    }
    @Override
    public final IOException invalidGZIPFooter() {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidGZIPFooter$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String responseTooLargeToBuffer$str() {
        return "UT000158: Response of length %s is too large to buffer";
    }
    @Override
    public final IllegalStateException responseTooLargeToBuffer(final Long length) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), responseTooLargeToBuffer$str(), length));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String headerBlockTooLarge$str() {
        return "UT000161: HTTP/2 header block is too large";
    }
    @Override
    public final String headerBlockTooLarge() {
        return String.format(getLoggingLocale(), headerBlockTooLarge$str());
    }
    protected String invalidSameSiteMode$str() {
        return "UT000162: An invalid SameSite attribute [%s] is specified. It must be one of %s";
    }
    @Override
    public final IllegalArgumentException invalidSameSiteMode(final String mode, final String validAttributes) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSameSiteMode$str(), mode, validAttributes));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidToken$str() {
        return "UT000163: Invalid token %s";
    }
    @Override
    public final IllegalArgumentException invalidToken(final byte c) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidToken$str(), c));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidHeaders$str() {
        return "UT000164: Request contained invalid headers";
    }
    @Override
    public final IllegalArgumentException invalidHeaders() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidHeaders$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidCharacterInRequestTarget$str() {
        return "UT000165: Invalid character %s in request-target";
    }
    @Override
    public final String invalidCharacterInRequestTarget(final char next) {
        return String.format(getLoggingLocale(), invalidCharacterInRequestTarget$str(), next);
    }
    protected String objectIsClosed$str() {
        return "UT000166: Pooled object is closed";
    }
    @Override
    public final IllegalStateException objectIsClosed() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), objectIsClosed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String moreThanOneHostHeader$str() {
        return "UT000167: More than one host header in request";
    }
    @Override
    public final IOException moreThanOneHostHeader() {
        final IOException result = new IOException(String.format(getLoggingLocale(), moreThanOneHostHeader$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidCookieValue$str() {
        return "UT000168: An invalid character [ASCII code: %s] was present in the cookie value";
    }
    @Override
    public final IllegalArgumentException invalidCookieValue(final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidCookieValue$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidCookieDomain$str() {
        return "UT000169: An invalid domain [%s] was specified for this cookie";
    }
    @Override
    public final IllegalArgumentException invalidCookieDomain(final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidCookieDomain$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidCookiePath$str() {
        return "UT000170: An invalid path [%s] was specified for this cookie";
    }
    @Override
    public final IllegalArgumentException invalidCookiePath(final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidCookiePath$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidControlCharacter$str() {
        return "UT000173: An invalid control character [%s] was present in the cookie value or attribute";
    }
    @Override
    public final IllegalArgumentException invalidControlCharacter(final String value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidControlCharacter$str(), value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidEscapeCharacter$str() {
        return "UT000174: An invalid escape character in cookie value";
    }
    @Override
    public final IllegalArgumentException invalidEscapeCharacter() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidEscapeCharacter$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidHpackIndex$str() {
        return "UT000175: Invalid Hpack index %s";
    }
    @Override
    public final HpackException invalidHpackIndex(final int index) {
        final HpackException result = new HpackException();
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String bufferPoolTooSmall$str() {
        return "UT000178: Buffer pool is too small, min size is %s";
    }
    @Override
    public final IllegalArgumentException bufferPoolTooSmall(final int minSize) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), bufferPoolTooSmall$str(), minSize));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidProxyHeader$str() {
        return "UT000179: Invalid PROXY protocol header";
    }
    @Override
    public final IOException invalidProxyHeader() {
        final IOException result = new IOException(String.format(getLoggingLocale(), invalidProxyHeader$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String headerSizeToLarge$str() {
        return "UT000180: PROXY protocol header exceeded max size of 107 bytes";
    }
    @Override
    public final IOException headerSizeToLarge() {
        final IOException result = new IOException(String.format(getLoggingLocale(), headerSizeToLarge$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String http2TrailerToLargeForSingleBuffer$str() {
        return "UT000181: HTTP/2 trailers too large for single buffer";
    }
    @Override
    public final RuntimeException http2TrailerToLargeForSingleBuffer() {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), http2TrailerToLargeForSingleBuffer$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String pingNotSupported$str() {
        return "UT000182: Ping not supported";
    }
    @Override
    public final IOException pingNotSupported() {
        final IOException result = new IOException(String.format(getLoggingLocale(), pingNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String pingTimeout$str() {
        return "UT000183: Ping timed out";
    }
    @Override
    public final IOException pingTimeout() {
        final IOException result = new IOException(String.format(getLoggingLocale(), pingTimeout$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String streamLimitExceeded$str() {
        return "UT000184: Stream limit exceeded";
    }
    @Override
    public final IOException streamLimitExceeded() {
        final IOException result = new IOException(String.format(getLoggingLocale(), streamLimitExceeded$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidIpAddress$str() {
        return "UT000185: Invalid IP address %s";
    }
    @Override
    public final IllegalArgumentException invalidIpAddress(final String addressString) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidIpAddress$str(), addressString));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidTlsExt$str() {
        return "UT000186: Invalid TLS extension";
    }
    @Override
    public final SSLException invalidTlsExt() {
        final SSLException result = new SSLException(String.format(getLoggingLocale(), invalidTlsExt$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notEnoughData$str() {
        return "UT000187: Not enough data";
    }
    @Override
    public final SSLException notEnoughData() {
        final SSLException result = new SSLException(String.format(getLoggingLocale(), notEnoughData$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String emptyHostNameSni$str() {
        return "UT000188: Empty host name in SNI extension";
    }
    @Override
    public final SSLException emptyHostNameSni() {
        final SSLException result = new SSLException(String.format(getLoggingLocale(), emptyHostNameSni$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicatedSniServerName$str() {
        return "UT000189: Duplicated host name of type %s";
    }
    @Override
    public final SSLException duplicatedSniServerName(final int type) {
        final SSLException result = new SSLException(String.format(getLoggingLocale(), duplicatedSniServerName$str(), type));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noContextForSslConnection$str() {
        return "UT000190: No context for SSL connection";
    }
    @Override
    public final SSLException noContextForSslConnection() {
        final SSLException result = new SSLException(String.format(getLoggingLocale(), noContextForSslConnection$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String defaultContextCannotBeNull$str() {
        return "UT000191: Default context cannot be null";
    }
    @Override
    public final IllegalStateException defaultContextCannotBeNull() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), defaultContextCannotBeNull$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String formValueIsInMemoryFile$str() {
        return "UT000192: Form value is a in-memory file, use getFileItem() instead";
    }
    @Override
    public final IllegalStateException formValueIsInMemoryFile() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), formValueIsInMemoryFile$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToDecodeParameterValue$str() {
        return "UT000193: Character decoding failed. Parameter [%s] with value [%s] has been ignored. Note: further occurrences of Parameter errors will be logged at DEBUG level.";
    }
    @Override
    public final String failedToDecodeParameterValue(final String parameter, final String value, final Exception e) {
        return String.format(getLoggingLocale(), failedToDecodeParameterValue$str(), parameter, value);
    }
    protected String failedToDecodeParameterName$str() {
        return "UT000194: Character decoding failed. Parameter with name [%s] has been ignored. Note: further occurrences of Parameter errors will be logged at DEBUG level.";
    }
    @Override
    public final String failedToDecodeParameterName(final String parameter, final Exception e) {
        return String.format(getLoggingLocale(), failedToDecodeParameterName$str(), parameter);
    }
    protected String chunkSizeTooLarge$str() {
        return "UT000195: Chunk size too large";
    }
    @Override
    public final IOException chunkSizeTooLarge() {
        final IOException result = new IOException(String.format(getLoggingLocale(), chunkSizeTooLarge$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String sessionWithIdAlreadyExists$str() {
        return "UT000196: Session with id %s already exists";
    }
    @Override
    public final IllegalStateException sessionWithIdAlreadyExists(final String sessionID) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), sessionWithIdAlreadyExists$str(), sessionID));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String blockingReadTimedOut$str() {
        return "UT000197: Blocking read timed out after %s nanoseconds.";
    }
    @Override
    public final ReadTimeoutException blockingReadTimedOut(final long timeoutNanoseconds) {
        final ReadTimeoutException result = new ReadTimeoutException(String.format(getLoggingLocale(), blockingReadTimedOut$str(), timeoutNanoseconds));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String blockingWriteTimedOut$str() {
        return "UT000198: Blocking write timed out after %s nanoseconds.";
    }
    @Override
    public final WriteTimeoutException blockingWriteTimedOut(final long timeoutNanoseconds) {
        final WriteTimeoutException result = new WriteTimeoutException(String.format(getLoggingLocale(), blockingWriteTimedOut$str(), timeoutNanoseconds));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String readTimedOut$str() {
        return "UT000199: Read timed out after %s milliseconds.";
    }
    @Override
    public final ReadTimeoutException readTimedOut(final long timeoutMilliseconds) {
        final ReadTimeoutException result = new ReadTimeoutException(String.format(getLoggingLocale(), readTimedOut$str(), timeoutMilliseconds));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToReplaceHashOutputStream$str() {
        return "UT000200: Failed to replace hash output stream ";
    }
    @Override
    public final SSLException failedToReplaceHashOutputStream(final Exception e) {
        final SSLException result = new SSLException(String.format(getLoggingLocale(), failedToReplaceHashOutputStream$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToReplaceHashOutputStreamOnWrite$str() {
        return "UT000201: Failed to replace hash output stream ";
    }
    @Override
    public final RuntimeException failedToReplaceHashOutputStreamOnWrite(final Exception e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToReplaceHashOutputStreamOnWrite$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToInitializePathManager$str() {
        return "UT000202: Failed to initialize path manager for '%s' path.";
    }
    @Override
    public final RuntimeException failedToInitializePathManager(final String path, final IOException ioe) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), failedToInitializePathManager$str(), path), ioe);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidACLAddress$str() {
        return "UT000203: Invalid ACL entry";
    }
    @Override
    public final IllegalArgumentException invalidACLAddress(final Exception e) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidACLAddress$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String pathNotADirectory$str() {
        return "UT000205: Path is not a directory '%s'";
    }
    @Override
    public final IOException pathNotADirectory(final Path path) {
        final IOException result = new IOException(String.format(getLoggingLocale(), pathNotADirectory$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String pathElementIsRegularFile$str() {
        return "UT000206: Path '%s' is not a directory";
    }
    @Override
    public final IOException pathElementIsRegularFile(final Path path) {
        final IOException result = new IOException(String.format(getLoggingLocale(), pathElementIsRegularFile$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidSniHostname$str() {
        return "UT000207: Invalid SNI hostname '%s'";
    }
    @Override
    public final IllegalArgumentException invalidSniHostname(final String hostNameValue, final Throwable t) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidSniHostname$str(), hostNameValue), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String failedToAllocateResource$str() {
        return "UT000208: Failed to allocate resource";
    }
    @Override
    public final IOException failedToAllocateResource() {
        final IOException result = new IOException(String.format(getLoggingLocale(), failedToAllocateResource$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
