/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.httpclient.transaction;

import io.undertow.client.ClientResponse;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.transaction.xa.Xid;
import org.jboss.marshalling.ByteInput;
import org.jboss.marshalling.ByteOutput;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.Unmarshaller;
import org.wildfly.httpclient.common.ByteInputs;
import org.wildfly.httpclient.common.ByteOutputs;
import org.wildfly.httpclient.common.HttpTargetContext;
import org.wildfly.httpclient.transaction.Serializer;
import org.xnio.IoUtils;

final class ClientHandlers {
    private ClientHandlers() {
    }

    static HttpTargetContext.HttpMarshaller xidHttpMarshaller(Marshaller marshaller, Xid xid) {
        return new XidHttpMarshaller(marshaller, xid);
    }

    static <T> HttpTargetContext.HttpResultHandler emptyHttpResultHandler(CompletableFuture<T> result, Function<ClientResponse, T> function) {
        return new EmptyHttpResultHandler<T>(result, function);
    }

    static HttpTargetContext.HttpResultHandler xidHttpResultHandler(Unmarshaller unmarshaller, CompletableFuture<Xid> result) {
        return new XidHttpResultHandler(unmarshaller, result);
    }

    static HttpTargetContext.HttpResultHandler xidArrayHttpResultHandler(Unmarshaller unmarshaller, CompletableFuture<Xid[]> result) {
        return new XidArrayHttpResultHandler(unmarshaller, result);
    }

    private static final class XidArrayHttpResultHandler
    implements HttpTargetContext.HttpResultHandler {
        private final Unmarshaller unmarshaller;
        private final CompletableFuture<Xid[]> result;

        private XidArrayHttpResultHandler(Unmarshaller unmarshaller, CompletableFuture<Xid[]> result) {
            this.unmarshaller = unmarshaller;
            this.result = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResult(InputStream is, ClientResponse response, Closeable doneCallback) {
            try (ByteInput in = ByteInputs.byteInputOf(is);){
                this.unmarshaller.start(in);
                Xid[] ret = Serializer.deserializeXidArray(this.unmarshaller);
                this.unmarshaller.finish();
                this.result.complete(ret);
            }
            catch (Exception e) {
                this.result.completeExceptionally(e);
            }
            finally {
                IoUtils.safeClose(doneCallback);
            }
        }
    }

    private static final class XidHttpResultHandler
    implements HttpTargetContext.HttpResultHandler {
        private final Unmarshaller unmarshaller;
        private final CompletableFuture<Xid> result;

        private XidHttpResultHandler(Unmarshaller unmarshaller, CompletableFuture<Xid> result) {
            this.unmarshaller = unmarshaller;
            this.result = result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResult(InputStream is, ClientResponse response, Closeable doneCallback) {
            try (ByteInput in = ByteInputs.byteInputOf(is);){
                this.unmarshaller.start(in);
                Xid xid = Serializer.deserializeXid(this.unmarshaller);
                this.unmarshaller.finish();
                this.result.complete(xid);
            }
            catch (Exception e) {
                this.result.completeExceptionally(e);
            }
            finally {
                IoUtils.safeClose(doneCallback);
            }
        }
    }

    private static final class EmptyHttpResultHandler<T>
    implements HttpTargetContext.HttpResultHandler {
        private final CompletableFuture<T> result;
        private final Function<ClientResponse, T> function;

        private EmptyHttpResultHandler(CompletableFuture<T> result, Function<ClientResponse, T> function) {
            this.result = result;
            this.function = function;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResult(InputStream is, ClientResponse response, Closeable doneCallback) {
            try {
                this.result.complete(this.function != null ? (Object)this.function.apply(response) : null);
            }
            finally {
                IoUtils.safeClose(doneCallback);
            }
        }
    }

    private static final class XidHttpMarshaller
    implements HttpTargetContext.HttpMarshaller {
        private final Marshaller marshaller;
        private final Xid xid;

        private XidHttpMarshaller(Marshaller marshaller, Xid xid) {
            this.marshaller = marshaller;
            this.xid = xid;
        }

        @Override
        public void marshall(OutputStream os) throws Exception {
            try (ByteOutput out = ByteOutputs.byteOutputOf(os);){
                this.marshaller.start(out);
                Serializer.serializeXid(this.marshaller, this.xid);
                this.marshaller.finish();
            }
        }
    }
}

