/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500._private;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.x500._private.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String unexpectedTrailingGarbageInX500principal$str() {
        return "ELY00006: Unexpected trailing garbage in X.500 principal";
    }

    @Override
    public final IllegalArgumentException unexpectedTrailingGarbageInX500principal() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unexpectedTrailingGarbageInX500principal$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    protected String nonX509CertificateInCertificateArray$str() {
        return "ELY10025: Non-X.509 certificate found in certificate array";
    }

    @Override
    public final IllegalArgumentException nonX509CertificateInCertificateArray() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.nonX509CertificateInCertificateArray$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String startingPublicKeyNotFoundInCertificateArray$str() {
        return "ELY10026: Starting public key not found in certificate array";
    }

    @Override
    public final IllegalArgumentException startingPublicKeyNotFoundInCertificateArray() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.startingPublicKeyNotFoundInCertificateArray$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String incompleteCertificateArray$str() {
        return "ELY10027: Incomplete certificate array";
    }

    @Override
    public final IllegalArgumentException incompleteCertificateArray() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.incompleteCertificateArray$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unableToCreateCertificateChainFromCertificateMap$str() {
        return "ELY10028: Unable to create X.509 certificate chain from map of certificates";
    }

    @Override
    public final IllegalArgumentException unableToCreateCertificateChainFromCertificateMap() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unableToCreateCertificateChainFromCertificateMap$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidValueForTrustedAuthorityType$str() {
        return "ELY05110: Invalid value for trusted authority type; expected a value between 0 and 4 (inclusive)";
    }

    @Override
    public final IllegalArgumentException invalidValueForTrustedAuthorityType() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidValueForTrustedAuthorityType$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidValueForGeneralNameType$str() {
        return "ELY05111: Invalid value for a general name type; expected a value between 0 and 8 (inclusive)";
    }

    @Override
    public final IllegalArgumentException invalidValueForGeneralNameType() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidValueForGeneralNameType$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String asnInvalidGeneralNameForUriType$str() {
        return "ELY07006: Invalid general name for URI type";
    }

    @Override
    public final ASN1Exception asnInvalidGeneralNameForUriType(Throwable cause) {
        ASN1Exception result = new ASN1Exception(String.format(this.getLoggingLocale(), this.asnInvalidGeneralNameForUriType$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String asnInvalidGeneralNameForIpAddressType$str() {
        return "ELY07007: Invalid general name for IP address type";
    }

    @Override
    public final ASN1Exception asnInvalidGeneralNameForIpAddressType() {
        ASN1Exception result = new ASN1Exception(String.format(this.getLoggingLocale(), this.asnInvalidGeneralNameForIpAddressType$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String asnIpAddressGeneralNameCannotBeResolved$str() {
        return "ELY07008: IP address general name cannot be resolved";
    }

    @Override
    public final ASN1Exception asnIpAddressGeneralNameCannotBeResolved(Throwable cause) {
        ASN1Exception result = new ASN1Exception(String.format(this.getLoggingLocale(), this.asnIpAddressGeneralNameCannotBeResolved$str(), new Object[0]), cause);
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String asnInvalidGeneralNameForUriTypeMissingScheme$str() {
        return "ELY07025: Invalid general name for URI type: missing scheme";
    }

    @Override
    public final ASN1Exception asnInvalidGeneralNameForUriTypeMissingScheme() {
        ASN1Exception result = new ASN1Exception(String.format(this.getLoggingLocale(), this.asnInvalidGeneralNameForUriTypeMissingScheme$str(), new Object[0]));
        ElytronMessages_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

