/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.QueueAbstractPacket;

public class SessionQueueQueryMessage
extends QueueAbstractPacket {
    public SessionQueueQueryMessage(SimpleString queueName) {
        super((byte)45);
        this.queueName = queueName;
    }

    public SessionQueueQueryMessage() {
        super((byte)45);
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeSimpleString(this.queueName);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.queueName = buffer.readSimpleString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.queueName == null ? 0 : this.queueName.hashCode());
        return result;
    }

    @Override
    protected String getPacketString() {
        StringBuilder sb = new StringBuilder(super.getPacketString());
        sb.append(", queueName=" + String.valueOf(this.queueName));
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SessionQueueQueryMessage)) {
            return false;
        }
        SessionQueueQueryMessage other = (SessionQueueQueryMessage)obj;
        return !(this.queueName == null ? other.queueName != null : !this.queueName.equals(other.queueName));
    }
}

