package org.jgroups.tests;

import org.jgroups.util.Util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;

/**
 * @author Bela Ban
 * @since x.y
 */
public class bla5 {
    public static void main(String[] args) throws IOException {
        ServerSocket srv=new ServerSocket(7000);
        srv.setReceiveBufferSize(248);
        for(;;) {
            InputStream in=null;
            BufferedInputStream input=null;
            Socket sock=srv.accept();
            sock.setReceiveBufferSize(248);
            sock.setSendBufferSize(248);
            try {
                System.out.printf("-- accepted connection from %s\n", sock.getRemoteSocketAddress());
                in=sock.getInputStream();
                input=new BufferedInputStream(in, 16);
                for(;;) {
                    byte[] data=new byte[32];
                    int bytes=input.read(data, 0, data.length);
                    System.out.printf("-- %d bytes: %s", bytes, new String(data, 0, bytes));
                }
            }
            finally {
                Util.close(input, in, sock);
            }
        }
    }
}
