/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.datasources.statistics;

import org.jboss.as.connector.dynamicresource.StatisticsResourceDefinition;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemProviders;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.jca.core.api.connectionmanager.pool.PoolStatistics;
import org.jboss.jca.core.spi.statistics.StatisticsPlugin;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class DataSourceStatisticsService
implements Service<ManagementResourceRegistration> {
    private static final PathElement JDBC_STATISTICS = PathElement.pathElement((String)"statistics", (String)"jdbc");
    private static final PathElement POOL_STATISTICS = PathElement.pathElement((String)"statistics", (String)"pool");
    private final ManagementResourceRegistration registration;
    private final boolean statsEnabled;
    protected final InjectedValue<CommonDeployment> injectedDeploymentMD = new InjectedValue();

    public DataSourceStatisticsService(ManagementResourceRegistration registration, boolean statsEnabled) {
        this.registration = registration;
        this.statsEnabled = statsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        ConnectorLogger.ROOT_LOGGER.debugf("Starting DataSourceStatisticsService", new Object[0]);
        DataSourceStatisticsService dataSourceStatisticsService = this;
        synchronized (dataSourceStatisticsService) {
            CommonDeployment deploymentMD = (CommonDeployment)this.injectedDeploymentMD.getValue();
            StatisticsPlugin jdbcStats = deploymentMD.getDataSources()[0].getStatistics();
            PoolStatistics poolStats = deploymentMD.getDataSources()[0].getPool().getStatistics();
            jdbcStats.setEnabled(this.statsEnabled);
            poolStats.setEnabled(this.statsEnabled);
            int jdbcStatsSize = jdbcStats.getNames().size();
            int poolStatsSize = poolStats.getNames().size();
            if ((jdbcStatsSize > 0 || poolStatsSize > 0) && this.registration != null) {
                if (jdbcStatsSize > 0 && this.registration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{JDBC_STATISTICS})) == null) {
                    ManagementResourceRegistration jdbcRegistration = this.registration.registerSubModel((ResourceDefinition)new StatisticsResourceDefinition(JDBC_STATISTICS, DataSourcesSubsystemProviders.RESOURCE_NAME, jdbcStats));
                    jdbcRegistration.setRuntimeOnly(true);
                }
                if (poolStatsSize > 0 && this.registration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{POOL_STATISTICS})) == null) {
                    ManagementResourceRegistration poolRegistration = this.registration.registerSubModel((ResourceDefinition)new StatisticsResourceDefinition(POOL_STATISTICS, DataSourcesSubsystemProviders.RESOURCE_NAME, (StatisticsPlugin)poolStats));
                    poolRegistration.setRuntimeOnly(true);
                }
            }
        }
    }

    public void stop(StopContext context) {
        if (this.registration != null) {
            this.registration.unregisterSubModel(JDBC_STATISTICS);
            this.registration.unregisterSubModel(POOL_STATISTICS);
        }
    }

    public ManagementResourceRegistration getValue() throws IllegalStateException, IllegalArgumentException {
        return this.registration;
    }

    public Injector<CommonDeployment> getCommonDeploymentInjector() {
        return this.injectedDeploymentMD;
    }

    public static void registerStatisticsResources(Resource datasourceResource) {
        if (!datasourceResource.hasChild(JDBC_STATISTICS)) {
            datasourceResource.registerChild(JDBC_STATISTICS, (Resource)new PlaceholderResource.PlaceholderResourceEntry(JDBC_STATISTICS));
        }
        if (!datasourceResource.hasChild(POOL_STATISTICS)) {
            datasourceResource.registerChild(POOL_STATISTICS, (Resource)new PlaceholderResource.PlaceholderResourceEntry(POOL_STATISTICS));
        }
    }

    public static void removeStatisticsResources(Resource datasourceResource) {
        if (datasourceResource.hasChild(JDBC_STATISTICS)) {
            datasourceResource.removeChild(JDBC_STATISTICS);
        }
        if (datasourceResource.hasChild(POOL_STATISTICS)) {
            datasourceResource.removeChild(POOL_STATISTICS);
        }
    }
}

