/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.jca;

import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.connector.subsystems.jca.TracerDefinition;
import org.jboss.as.connector.subsystems.jca.TracerService;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public class TracerAdd
extends AbstractAddStepHandler {
    public static final TracerAdd INSTANCE = new TracerAdd();

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (TracerDefinition.TracerParameters parameter : TracerDefinition.TracerParameters.values()) {
            parameter.getAttribute().validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        boolean enabled = TracerDefinition.TracerParameters.TRACER_ENABLED.getAttribute().resolveModelAttribute(context, model).asBoolean();
        ServiceName serviceName = ConnectorServices.TRACER_CONFIG_SERVICE;
        ServiceName jcaConfigServiceName = ConnectorServices.CONNECTOR_CONFIG_SERVICE;
        ServiceTarget serviceTarget = context.getServiceTarget();
        TracerService.Tracer config = new TracerService.Tracer(enabled);
        TracerService service = new TracerService(config);
        serviceTarget.addService(serviceName, (Service)service).setInitialMode(ServiceController.Mode.ACTIVE).addDependency(jcaConfigServiceName, JcaSubsystemConfiguration.class, service.getJcaConfigInjector()).install();
    }
}

