/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.util.AbstractParser;
import org.jboss.as.connector.util.ParserException;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.metadata.common.Capacity;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Pool;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.Security;
import org.jboss.jca.common.api.metadata.common.TimeOut;
import org.jboss.jca.common.api.metadata.common.Validation;
import org.jboss.jca.common.api.metadata.common.XaPool;
import org.jboss.jca.common.api.metadata.ds.DataSource;
import org.jboss.jca.common.api.metadata.ds.DsPool;
import org.jboss.jca.common.api.metadata.ds.XaDataSource;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.resourceadapter.AdminObject;
import org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public abstract class CommonIronJacamarParser
extends AbstractParser {
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle(CommonBundle.class);

    protected void parseConfigProperties(XMLExtendedStreamReader reader, Map<String, ModelNode> map) throws XMLStreamException, ParserException {
        String name = this.rawAttributeText((XMLStreamReader)reader, "name");
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        String value = this.rawElementText((XMLStreamReader)reader);
        Constants.CONFIG_PROPERTY_VALUE.parseAndSetParameter(value, operation, (XMLStreamReader)reader);
        if (map.containsKey(name)) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        map.put(name, operation);
    }

    protected void parseConnectionDefinitions_3_0(XMLExtendedStreamReader reader, Map<String, ModelNode> map, Map<String, HashMap<String, ModelNode>> configMap, boolean isXa) throws XMLStreamException, ParserException, ValidateException {
        ModelNode connectionDefinitionNode = new ModelNode();
        connectionDefinitionNode.get("operation").set("add");
        String poolName = null;
        String jndiName = null;
        int attributeSize = reader.getAttributeCount();
        boolean poolDefined = Boolean.FALSE;
        block25: for (int i = 0; i < attributeSize; ++i) {
            ConnectionDefinition.Attribute attribute = ConnectionDefinition.Attribute.forName((String)reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case ENABLED: {
                    Constants.ENABLED.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block25;
                }
                case CONNECTABLE: {
                    Constants.CONNECTABLE.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block25;
                }
                case TRACKING: {
                    Constants.TRACKING.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block25;
                }
                case JNDI_NAME: {
                    jndiName = value;
                    Constants.JNDINAME.parseAndSetParameter(jndiName, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block25;
                }
                case POOL_NAME: {
                    poolName = value;
                    continue block25;
                }
                case USE_JAVA_CONTEXT: {
                    Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block25;
                }
                case USE_CCM: {
                    Constants.USE_CCM.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block25;
                }
                case SHARABLE: {
                    Constants.SHARABLE.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block25;
                }
                case ENLISTMENT: {
                    Constants.ENLISTMENT.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block25;
                }
                case CLASS_NAME: {
                    Constants.CLASS_NAME.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block25;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (poolName == null || poolName.trim().equals("")) {
            if (jndiName != null && jndiName.trim().length() != 0) {
                poolName = jndiName.contains("/") ? jndiName.substring(jndiName.lastIndexOf("/") + 1) : jndiName.substring(jndiName.lastIndexOf(":") + 1);
            } else {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(ConnectionDefinition.Attribute.JNDI_NAME));
            }
        }
        while (reader.hasNext()) {
            block12 : switch (reader.nextTag()) {
                case 2: {
                    if (Activation.Tag.forName((String)reader.getLocalName()) == Activation.Tag.CONNECTION_DEFINITION) {
                        map.put(poolName, connectionDefinitionNode);
                        return;
                    }
                    if (ConnectionDefinition.Tag.forName((String)reader.getLocalName()) != ConnectionDefinition.Tag.UNKNOWN) break;
                    throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
                }
                case 1: {
                    switch (ConnectionDefinition.Tag.forName((String)reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            if (!configMap.containsKey(poolName)) {
                                configMap.put(poolName, new HashMap(0));
                            }
                            this.parseConfigProperties(reader, (Map<String, ModelNode>)configMap.get(poolName));
                            break block12;
                        }
                        case SECURITY: {
                            this.parseSecuritySettings(reader, connectionDefinitionNode);
                            break block12;
                        }
                        case TIMEOUT: {
                            this.parseTimeOut(reader, isXa, connectionDefinitionNode);
                            break block12;
                        }
                        case VALIDATION: {
                            this.parseValidation(reader, connectionDefinitionNode);
                            break block12;
                        }
                        case XA_POOL: {
                            if (!isXa) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            if (poolDefined) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            this.parseXaPool(reader, connectionDefinitionNode);
                            poolDefined = true;
                            break block12;
                        }
                        case POOL: {
                            if (isXa) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            if (poolDefined) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            this.parsePool(reader, connectionDefinitionNode);
                            poolDefined = true;
                            break block12;
                        }
                        case RECOVERY: {
                            this.parseRecovery(reader, connectionDefinitionNode);
                            break block12;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
    }

    protected void parseConnectionDefinitions_4_0(XMLExtendedStreamReader reader, Map<String, ModelNode> map, Map<String, HashMap<String, ModelNode>> configMap, boolean isXa) throws XMLStreamException, ParserException, ValidateException {
        ModelNode connectionDefinitionNode = new ModelNode();
        connectionDefinitionNode.get("operation").set("add");
        String poolName = null;
        String jndiName = null;
        int attributeSize = reader.getAttributeCount();
        boolean poolDefined = Boolean.FALSE;
        block27: for (int i = 0; i < attributeSize; ++i) {
            ConnectionDefinition.Attribute attribute = ConnectionDefinition.Attribute.forName((String)reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case ENABLED: {
                    Constants.ENABLED.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block27;
                }
                case CONNECTABLE: {
                    Constants.CONNECTABLE.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block27;
                }
                case TRACKING: {
                    Constants.TRACKING.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block27;
                }
                case JNDI_NAME: {
                    jndiName = value;
                    Constants.JNDINAME.parseAndSetParameter(jndiName, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block27;
                }
                case POOL_NAME: {
                    poolName = value;
                    continue block27;
                }
                case USE_JAVA_CONTEXT: {
                    Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block27;
                }
                case USE_CCM: {
                    Constants.USE_CCM.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block27;
                }
                case SHARABLE: {
                    Constants.SHARABLE.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block27;
                }
                case ENLISTMENT: {
                    Constants.ENLISTMENT.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block27;
                }
                case CLASS_NAME: {
                    Constants.CLASS_NAME.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block27;
                }
                case MCP: {
                    Constants.MCP.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block27;
                }
                case ENLISTMENT_TRACE: {
                    Constants.ENLISTMENT_TRACE.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block27;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (poolName == null || poolName.trim().equals("")) {
            if (jndiName != null && jndiName.trim().length() != 0) {
                poolName = jndiName.contains("/") ? jndiName.substring(jndiName.lastIndexOf("/") + 1) : jndiName.substring(jndiName.lastIndexOf(":") + 1);
            } else {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(ConnectionDefinition.Attribute.JNDI_NAME));
            }
        }
        while (reader.hasNext()) {
            block14 : switch (reader.nextTag()) {
                case 2: {
                    if (Activation.Tag.forName((String)reader.getLocalName()) == Activation.Tag.CONNECTION_DEFINITION) {
                        map.put(poolName, connectionDefinitionNode);
                        return;
                    }
                    if (ConnectionDefinition.Tag.forName((String)reader.getLocalName()) != ConnectionDefinition.Tag.UNKNOWN) break;
                    throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
                }
                case 1: {
                    switch (ConnectionDefinition.Tag.forName((String)reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            if (!configMap.containsKey(poolName)) {
                                configMap.put(poolName, new HashMap(0));
                            }
                            this.parseConfigProperties(reader, (Map<String, ModelNode>)configMap.get(poolName));
                            break block14;
                        }
                        case SECURITY: {
                            this.parseSecuritySettings(reader, connectionDefinitionNode);
                            break block14;
                        }
                        case TIMEOUT: {
                            this.parseTimeOut(reader, isXa, connectionDefinitionNode);
                            break block14;
                        }
                        case VALIDATION: {
                            this.parseValidation(reader, connectionDefinitionNode);
                            break block14;
                        }
                        case XA_POOL: {
                            if (!isXa) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            if (poolDefined) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            this.parseXaPool(reader, connectionDefinitionNode);
                            poolDefined = true;
                            break block14;
                        }
                        case POOL: {
                            if (isXa) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            if (poolDefined) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            this.parsePool(reader, connectionDefinitionNode);
                            poolDefined = true;
                            break block14;
                        }
                        case RECOVERY: {
                            this.parseRecovery(reader, connectionDefinitionNode);
                            break block14;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
    }

    protected void parseConnectionDefinitions_1_0(XMLExtendedStreamReader reader, Map<String, ModelNode> map, Map<String, HashMap<String, ModelNode>> configMap, boolean isXa) throws XMLStreamException, ParserException, ValidateException {
        ModelNode connectionDefinitionNode = new ModelNode();
        connectionDefinitionNode.get("operation").set("add");
        String poolName = null;
        String jndiName = null;
        int attributeSize = reader.getAttributeCount();
        boolean poolDefined = Boolean.FALSE;
        block23: for (int i = 0; i < attributeSize; ++i) {
            ConnectionDefinition.Attribute attribute = ConnectionDefinition.Attribute.forName((String)reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case ENABLED: {
                    Constants.ENABLED.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block23;
                }
                case JNDI_NAME: {
                    jndiName = value;
                    Constants.JNDINAME.parseAndSetParameter(jndiName, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block23;
                }
                case POOL_NAME: {
                    poolName = value;
                    continue block23;
                }
                case USE_JAVA_CONTEXT: {
                    Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block23;
                }
                case USE_CCM: {
                    Constants.USE_CCM.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block23;
                }
                case SHARABLE: {
                    Constants.SHARABLE.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block23;
                }
                case ENLISTMENT: {
                    Constants.ENLISTMENT.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block23;
                }
                case CLASS_NAME: {
                    Constants.CLASS_NAME.parseAndSetParameter(value, connectionDefinitionNode, (XMLStreamReader)reader);
                    continue block23;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (poolName == null || poolName.trim().equals("")) {
            if (jndiName != null && jndiName.trim().length() != 0) {
                poolName = jndiName.contains("/") ? jndiName.substring(jndiName.lastIndexOf("/") + 1) : jndiName.substring(jndiName.lastIndexOf(":") + 1);
            } else {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(ConnectionDefinition.Attribute.JNDI_NAME));
            }
        }
        while (reader.hasNext()) {
            block10 : switch (reader.nextTag()) {
                case 2: {
                    if (Activation.Tag.forName((String)reader.getLocalName()) == Activation.Tag.CONNECTION_DEFINITION) {
                        map.put(poolName, connectionDefinitionNode);
                        return;
                    }
                    if (ConnectionDefinition.Tag.forName((String)reader.getLocalName()) != ConnectionDefinition.Tag.UNKNOWN) break;
                    throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
                }
                case 1: {
                    switch (ConnectionDefinition.Tag.forName((String)reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            if (!configMap.containsKey(poolName)) {
                                configMap.put(poolName, new HashMap(0));
                            }
                            this.parseConfigProperties(reader, (Map<String, ModelNode>)configMap.get(poolName));
                            break block10;
                        }
                        case SECURITY: {
                            this.parseSecuritySettings(reader, connectionDefinitionNode);
                            break block10;
                        }
                        case TIMEOUT: {
                            this.parseTimeOut(reader, isXa, connectionDefinitionNode);
                            break block10;
                        }
                        case VALIDATION: {
                            this.parseValidation(reader, connectionDefinitionNode);
                            break block10;
                        }
                        case XA_POOL: {
                            if (!isXa) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            if (poolDefined) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            this.parseXaPool(reader, connectionDefinitionNode);
                            poolDefined = true;
                            break block10;
                        }
                        case POOL: {
                            if (isXa) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            if (poolDefined) {
                                throw new ParserException(bundle.multiplePools());
                            }
                            this.parsePool(reader, connectionDefinitionNode);
                            poolDefined = true;
                            break block10;
                        }
                        case RECOVERY: {
                            this.parseRecovery(reader, connectionDefinitionNode);
                            break block10;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
    }

    private void parseValidation(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException, ParserException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (ConnectionDefinition.Tag.forName((String)reader.getLocalName()) == ConnectionDefinition.Tag.VALIDATION) {
                        return;
                    }
                    if (ConnectionDefinition.Tag.forName((String)reader.getLocalName()) != ConnectionDefinition.Tag.UNKNOWN) break;
                    throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
                }
                case 1: {
                    switch (Validation.Tag.forName((String)reader.getLocalName())) {
                        case BACKGROUND_VALIDATION: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case BACKGROUND_VALIDATION_MILLIS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USE_FAST_FAIL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case VALIDATE_ON_MATCH: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.VALIDATE_ON_MATCH.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
    }

    private void parseTimeOut(XMLExtendedStreamReader reader, Boolean isXa, ModelNode node) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (ConnectionDefinition.Tag.forName((String)reader.getLocalName()) == ConnectionDefinition.Tag.TIMEOUT) {
                        return;
                    }
                    if (TimeOut.Tag.forName((String)reader.getLocalName()) != TimeOut.Tag.UNKNOWN) break;
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
                case 1: {
                    String value = this.rawElementText((XMLStreamReader)reader);
                    switch (TimeOut.Tag.forName((String)reader.getLocalName())) {
                        case ALLOCATION_RETRY: {
                            Constants.ALLOCATION_RETRY.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case ALLOCATION_RETRY_WAIT_MILLIS: {
                            Constants.ALLOCATION_RETRY_WAIT_MILLIS.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case BLOCKING_TIMEOUT_MILLIS: {
                            org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case IDLE_TIMEOUT_MINUTES: {
                            org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case XA_RESOURCE_TIMEOUT: {
                            Constants.XA_RESOURCE_TIMEOUT.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
    }

    protected void parseAdminObjects(XMLExtendedStreamReader reader, Map<String, ModelNode> map, Map<String, HashMap<String, ModelNode>> configMap) throws XMLStreamException, ParserException, ValidateException {
        ModelNode adminObjectNode = new ModelNode();
        adminObjectNode.get("operation").set("add");
        int attributeSize = reader.getAttributeCount();
        String poolName = null;
        String jndiName = null;
        block14: for (int i = 0; i < attributeSize; ++i) {
            AdminObject.Attribute attribute = AdminObject.Attribute.forName((String)reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.ENABLED.getXmlName());
                    if (value == null) continue block14;
                    Constants.ENABLED.parseAndSetParameter(value, adminObjectNode, (XMLStreamReader)reader);
                    continue block14;
                }
                case JNDI_NAME: {
                    jndiName = this.rawAttributeText((XMLStreamReader)reader, Constants.JNDINAME.getXmlName());
                    if (jndiName == null) continue block14;
                    Constants.JNDINAME.parseAndSetParameter(jndiName, adminObjectNode, (XMLStreamReader)reader);
                    continue block14;
                }
                case POOL_NAME: {
                    poolName = this.rawAttributeText((XMLStreamReader)reader, "pool-name");
                    continue block14;
                }
                case USE_JAVA_CONTEXT: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.USE_JAVA_CONTEXT.getXmlName());
                    if (value == null) continue block14;
                    Constants.USE_JAVA_CONTEXT.parseAndSetParameter(value, adminObjectNode, (XMLStreamReader)reader);
                    continue block14;
                }
                case CLASS_NAME: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.CLASS_NAME.getXmlName());
                    if (value == null) continue block14;
                    Constants.CLASS_NAME.parseAndSetParameter(value, adminObjectNode, (XMLStreamReader)reader);
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (poolName == null || poolName.trim().equals("")) {
            if (jndiName != null && jndiName.trim().length() != 0) {
                poolName = jndiName.contains("/") ? jndiName.substring(jndiName.lastIndexOf("/") + 1) : jndiName.substring(jndiName.lastIndexOf(":") + 1);
            } else {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(AdminObject.Attribute.JNDI_NAME));
            }
        }
        while (reader.hasNext()) {
            block7 : switch (reader.nextTag()) {
                case 2: {
                    if (Activation.Tag.forName((String)reader.getLocalName()) == Activation.Tag.ADMIN_OBJECT) {
                        map.put(poolName, adminObjectNode);
                        return;
                    }
                    if (AdminObject.Tag.forName((String)reader.getLocalName()) != AdminObject.Tag.UNKNOWN) break;
                    throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
                }
                case 1: {
                    switch (AdminObject.Tag.forName((String)reader.getLocalName())) {
                        case CONFIG_PROPERTY: {
                            if (!configMap.containsKey(poolName)) {
                                configMap.put(poolName, new HashMap(0));
                            }
                            this.parseConfigProperties(reader, (Map<String, ModelNode>)configMap.get(poolName));
                            break block7;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
    }

    protected void parseXaPool(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) == XaDataSource.Tag.XA_POOL) {
                        return;
                    }
                    if (XaPool.Tag.forName((String)reader.getLocalName()) != XaPool.Tag.UNKNOWN) break;
                    throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
                }
                case 1: {
                    switch (XaPool.Tag.forName((String)reader.getLocalName())) {
                        case MAX_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case INITIAL_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case PREFILL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case FLUSH_STRATEGY: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case INTERLEAVING: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            value = value == null ? "true" : value;
                            Constants.INTERLEAVING.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case IS_SAME_RM_OVERRIDE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.SAME_RM_OVERRIDE.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case NO_TX_SEPARATE_POOLS: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            value = value == null ? "true" : value;
                            Constants.NOTXSEPARATEPOOL.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case PAD_XID: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.PAD_XID.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case WRAP_XA_RESOURCE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.WRAP_XA_RESOURCE.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case CAPACITY: {
                            this.parseCapacity(reader, node);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
    }

    protected void parsePool(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.POOL) {
                        return;
                    }
                    if (Pool.Tag.forName((String)reader.getLocalName()) != Pool.Tag.UNKNOWN) break;
                    throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
                }
                case 1: {
                    switch (Pool.Tag.forName((String)reader.getLocalName())) {
                        case MAX_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case INITIAL_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case MIN_POOL_SIZE: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case PREFILL: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USE_STRICT_MIN: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case FLUSH_STRATEGY: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case CAPACITY: {
                            this.parseCapacity(reader, node);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
    }

    private void parseCapacity(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DsPool.Tag.forName((String)reader.getLocalName()) == DsPool.Tag.CAPACITY) {
                        return;
                    }
                    if (Capacity.Tag.forName((String)reader.getLocalName()) != Capacity.Tag.UNKNOWN) break;
                    throw new ParserException(bundle.unexpectedEndTag(reader.getLocalName()));
                }
                case 1: {
                    switch (Capacity.Tag.forName((String)reader.getLocalName())) {
                        case INCREMENTER: {
                            this.parseExtension(reader, reader.getLocalName(), operation, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES);
                            break block0;
                        }
                        case DECREMENTER: {
                            this.parseExtension(reader, reader.getLocalName(), operation, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES);
                            break block0;
                        }
                    }
                    throw new ParserException(bundle.unexpectedElement(reader.getLocalName()));
                }
            }
        }
        throw new ParserException(bundle.unexpectedEndOfDocument());
    }

    protected void parseRecovery(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException, ParserException, ValidateException {
        block11: for (Recovery.Attribute attribute : Recovery.Attribute.values()) {
            switch (attribute) {
                case NO_RECOVERY: {
                    String value = this.rawAttributeText((XMLStreamReader)reader, Constants.NO_RECOVERY.getXmlName());
                    if (value == null) continue block11;
                    Constants.NO_RECOVERY.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block11;
                }
            }
        }
        while (reader.hasNext()) {
            block3 : switch (reader.nextTag()) {
                case 2: {
                    if (XaDataSource.Tag.forName((String)reader.getLocalName()) == XaDataSource.Tag.RECOVERY) {
                        return;
                    }
                    if (Recovery.Tag.forName((String)reader.getLocalName()) != Recovery.Tag.UNKNOWN) break;
                    throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
                }
                case 1: {
                    Recovery.Tag tag = Recovery.Tag.forName((String)reader.getLocalName());
                    switch (tag) {
                        case RECOVER_CREDENTIAL: {
                            this.parseRecoveryCredential(reader, node);
                            break block3;
                        }
                        case RECOVER_PLUGIN: {
                            this.parseExtension(reader, tag.getLocalName(), node, Constants.RECOVERLUGIN_CLASSNAME, Constants.RECOVERLUGIN_PROPERTIES);
                            break block3;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
    }

    private void parseSecuritySettings(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException, ParserException, ValidateException {
        boolean securtyDomainMatched = false;
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY) {
                        return;
                    }
                    if (Security.Tag.forName((String)reader.getLocalName()) != Security.Tag.UNKNOWN) break;
                    throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
                }
                case 1: {
                    switch (Security.Tag.forName((String)reader.getLocalName())) {
                        case SECURITY_DOMAIN: {
                            if (securtyDomainMatched) {
                                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                            }
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.SECURITY_DOMAIN.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            securtyDomainMatched = true;
                            break block0;
                        }
                        case SECURITY_DOMAIN_AND_APPLICATION: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.SECURITY_DOMAIN_AND_APPLICATION.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case APPLICATION: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            value = value == null ? "true" : value;
                            Constants.APPLICATION.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
    }

    private void parseRecoveryCredential(XMLExtendedStreamReader reader, ModelNode node) throws XMLStreamException, ParserException, ValidateException {
        while (reader.hasNext()) {
            block0 : switch (reader.nextTag()) {
                case 2: {
                    if (DataSource.Tag.forName((String)reader.getLocalName()) == DataSource.Tag.SECURITY || Recovery.Tag.forName((String)reader.getLocalName()) == Recovery.Tag.RECOVER_CREDENTIAL) {
                        return;
                    }
                    if (Credential.Tag.forName((String)reader.getLocalName()) != Credential.Tag.UNKNOWN) break;
                    throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
                }
                case 1: {
                    switch (Credential.Tag.forName((String)reader.getLocalName())) {
                        case PASSWORD: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_PASSWORD.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case USER_NAME: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_USERNAME.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                        case SECURITY_DOMAIN: {
                            String value = this.rawElementText((XMLStreamReader)reader);
                            Constants.RECOVERY_SECURITY_DOMAIN.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                            break block0;
                        }
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        }
        throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
    }
}

