package org.jboss.as.connector.logging;

import java.util.Locale;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.vfs.VirtualFile;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.jca.core.spi.rar.NotFoundException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.NoSuchMethodException;
import org.jboss.as.controller.PathElement;
import org.jboss.logging.BasicLogger;
import org.jboss.msc.service.StartException;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;
import javax.annotation.Generated;
import org.jboss.jca.deployers.common.DeployException;
import org.jboss.as.controller.OperationFailedException;
import java.lang.SecurityException;
import javax.security.auth.Subject;
import org.jboss.as.controller.PathAddress;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;
import org.jboss.dmr.ModelNode;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-11-14T18:04:51-0800")
public class ConnectorLogger_$logger extends DelegatingBasicLogger implements ConnectorLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ConnectorLogger_$logger.class.getName();
    public ConnectorLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void boundDataSource(final String jndiName) {
        super.log.logf(FQCN, INFO, null, boundDataSource$str(), jndiName);
    }
    private static final String boundDataSource = "WFLYJCA0001: Bound data source [%s]";
    protected String boundDataSource$str() {
        return boundDataSource;
    }
    @Override
    public final void boundJca(final String description, final String jndiName) {
        super.log.logf(FQCN, INFO, null, boundJca$str(), description, jndiName);
    }
    private static final String boundJca = "WFLYJCA0002: Bound JCA %s [%s]";
    protected String boundJca$str() {
        return boundJca;
    }
    @Override
    public final void cannotInstantiateDriverClass(final String driverClassName, final Throwable reason) {
        super.log.logf(FQCN, WARN, null, cannotInstantiateDriverClass2$str(), driverClassName, reason);
    }
    private static final String cannotInstantiateDriverClass2 = "WFLYJCA0003: Unable to instantiate driver class \"%s\": %s";
    protected String cannotInstantiateDriverClass2$str() {
        return cannotInstantiateDriverClass2;
    }
    @Override
    public final void deployingCompliantJdbcDriver(final Class<? extends java.sql.Driver> driver, final int majorVersion, final int minorVersion) {
        super.log.logf(FQCN, INFO, null, deployingCompliantJdbcDriver$str(), driver, majorVersion, minorVersion);
    }
    private static final String deployingCompliantJdbcDriver = "WFLYJCA0004: Deploying JDBC-compliant driver %s (version %d.%d)";
    protected String deployingCompliantJdbcDriver$str() {
        return deployingCompliantJdbcDriver;
    }
    @Override
    public final void deployingNonCompliantJdbcDriver(final Class<? extends java.sql.Driver> driver, final int majorVersion, final int minorVersion) {
        super.log.logf(FQCN, INFO, null, deployingNonCompliantJdbcDriver$str(), driver, majorVersion, minorVersion);
    }
    private static final String deployingNonCompliantJdbcDriver = "WFLYJCA0005: Deploying non-JDBC-compliant driver %s (version %d.%d)";
    protected String deployingNonCompliantJdbcDriver$str() {
        return deployingNonCompliantJdbcDriver;
    }
    @Override
    public final void registeredAdminObject(final String jndiName) {
        super.log.logf(FQCN, INFO, null, registeredAdminObject$str(), jndiName);
    }
    private static final String registeredAdminObject = "WFLYJCA0006: Registered admin object at %s";
    protected String registeredAdminObject$str() {
        return registeredAdminObject;
    }
    @Override
    public final void registeredConnectionFactory(final String jndiName) {
        super.log.logf(FQCN, INFO, null, registeredConnectionFactory$str(), jndiName);
    }
    private static final String registeredConnectionFactory = "WFLYJCA0007: Registered connection factory %s";
    protected String registeredConnectionFactory$str() {
        return registeredConnectionFactory;
    }
    @Override
    public final void startingSubsystem(final String subsystem, final String version) {
        super.log.logf(FQCN, INFO, null, startingSubsystem$str(), subsystem, version);
    }
    private static final String startingSubsystem = "WFLYJCA0009: Starting %s Subsystem (%s)";
    protected String startingSubsystem$str() {
        return startingSubsystem;
    }
    @Override
    public final void unboundDataSource(final String jndiName) {
        super.log.logf(FQCN, INFO, null, unboundDataSource$str(), jndiName);
    }
    private static final String unboundDataSource = "WFLYJCA0010: Unbound data source [%s]";
    protected String unboundDataSource$str() {
        return unboundDataSource;
    }
    @Override
    public final void unboundJca(final String description, final String jndiName) {
        super.log.logf(FQCN, INFO, null, unboundJca$str(), description, jndiName);
    }
    private static final String unboundJca = "WFLYJCA0011: Unbound JCA %s [%s]";
    protected String unboundJca$str() {
        return unboundJca;
    }
    @Override
    public final void driversElementNotSupported(final String deploymentName) {
        super.log.logf(FQCN, WARN, null, driversElementNotSupported$str(), deploymentName);
    }
    private static final String driversElementNotSupported = "WFLYJCA0012: <drivers/> in standalone -ds.xml deployments aren't supported: Ignoring %s";
    protected String driversElementNotSupported$str() {
        return driversElementNotSupported;
    }
    private static final String driverNameAndResourceNameNotEquals = "WFLYJCA0015: the attribute driver-name (%s) cannot be different from driver resource name (%s)";
    protected String driverNameAndResourceNameNotEquals$str() {
        return driverNameAndResourceNameNotEquals;
    }
    @Override
    public final OperationFailedException driverNameAndResourceNameNotEquals(final String driverName, final String resourceName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), driverNameAndResourceNameNotEquals$str(), driverName, resourceName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void methodNotFoundOnDataSource(final String method, final Class<?> clazz) {
        super.log.logf(FQCN, WARN, null, methodNotFoundOnDataSource$str(), method, clazz);
    }
    private static final String methodNotFoundOnDataSource = "WFLYJCA0016: Method %s on DataSource class %s not found. Ignoring";
    protected String methodNotFoundOnDataSource$str() {
        return methodNotFoundOnDataSource;
    }
    @Override
    public final void forceIJToNull() {
        super.log.logf(FQCN, DEBUG, null, forceIJToNull$str());
    }
    private static final String forceIJToNull = "WFLYJCA0017: Forcing ironjacamar.xml descriptor to null";
    protected String forceIJToNull$str() {
        return forceIJToNull;
    }
    @Override
    public final void startedDriverService(final String driverName) {
        super.log.logf(FQCN, INFO, null, startedDriverService$str(), driverName);
    }
    private static final String startedDriverService = "WFLYJCA0018: Started Driver service with driver-name = %s";
    protected String startedDriverService$str() {
        return startedDriverService;
    }
    @Override
    public final void stoppedDriverService(final String driverName) {
        super.log.logf(FQCN, INFO, null, stoppedDriverService$str(), driverName);
    }
    private static final String stoppedDriverService = "WFLYJCA0019: Stopped Driver service with driver-name = %s";
    protected String stoppedDriverService$str() {
        return stoppedDriverService;
    }
    @Override
    public final void unsupportedSelectorOption(final String name) {
        super.log.logf(FQCN, WARN, null, unsupportedSelectorOption$str(), name);
    }
    private static final String unsupportedSelectorOption = "WFLYJCA0020: Unsupported selector's option: %s";
    protected String unsupportedSelectorOption$str() {
        return unsupportedSelectorOption;
    }
    @Override
    public final void unsupportedPolicyOption(final String name) {
        super.log.logf(FQCN, WARN, null, unsupportedPolicyOption$str(), name);
    }
    private static final String unsupportedPolicyOption = "WFLYJCA0021: Unsupported policy's option: %s";
    protected String unsupportedPolicyOption$str() {
        return unsupportedPolicyOption;
    }
    private static final String failedToStartJGroupsChannel = "WFLYJCA0022: Failed to start JGroups channel %s for distributed workmanager %s";
    protected String failedToStartJGroupsChannel$str() {
        return failedToStartJGroupsChannel;
    }
    @Override
    public final StartException failedToStartJGroupsChannel(final String channelName, final String wmName) {
        final StartException result = new StartException(String.format(getLoggingLocale(), failedToStartJGroupsChannel$str(), channelName, wmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToFindDistributedWorkManager = "WFLYJCA0023: Cannot find WorkManager %s or it isn't a distributed workmanager. Only DWM can override configurations";
    protected String failedToFindDistributedWorkManager$str() {
        return failedToFindDistributedWorkManager;
    }
    @Override
    public final OperationFailedException failedToFindDistributedWorkManager(final String wmName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), failedToFindDistributedWorkManager$str(), wmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToStartDWMTransport = "WFLYJCA0024: Failed to start JGroups transport for distributed workmanager %s";
    protected String failedToStartDWMTransport$str() {
        return failedToStartDWMTransport;
    }
    @Override
    public final StartException failedToStartDWMTransport(final String wmName) {
        final StartException result = new StartException(String.format(getLoggingLocale(), failedToStartDWMTransport$str(), wmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedSelector = "WFLYJCA0025: Unsupported selector's option: %s";
    protected String unsupportedSelector$str() {
        return unsupportedSelector;
    }
    @Override
    public final OperationFailedException unsupportedSelector(final String name) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unsupportedSelector$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedPolicy = "WFLYJCA0026: Unsupported policy's option: %s";
    protected String unsupportedPolicy$str() {
        return unsupportedPolicy;
    }
    @Override
    public final OperationFailedException unsupportedPolicy(final String name) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), unsupportedPolicy$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void noSecurityDefined(final String jndiName) {
        super.log.logf(FQCN, WARN, null, noSecurityDefined$str(), jndiName);
    }
    private static final String noSecurityDefined = "WFLYJCA0027: No ironjacamar.security defined for %s";
    protected String noSecurityDefined$str() {
        return noSecurityDefined;
    }
    @Override
    public final void connectionFactoryAnnotation(final String jndiName) {
        super.log.logf(FQCN, WARN, null, connectionFactoryAnnotation$str(), jndiName);
    }
    private static final String connectionFactoryAnnotation = "WFLYJCA0028: @ConnectionFactoryDefinition will have limited management: %s";
    protected String connectionFactoryAnnotation$str() {
        return connectionFactoryAnnotation;
    }
    @Override
    public final void adminObjectAnnotation(final String jndiName) {
        super.log.logf(FQCN, WARN, null, adminObjectAnnotation$str(), jndiName);
    }
    private static final String adminObjectAnnotation = "WFLYJCA0029: @AdministeredObjectDefinition will have limited management: %s";
    protected String adminObjectAnnotation$str() {
        return adminObjectAnnotation;
    }
    private static final String cannotDeploy = "WFLYJCA0030: unable to deploy";
    protected String cannotDeploy$str() {
        return cannotDeploy;
    }
    @Override
    public final DeployException cannotDeploy(final Throwable cause) {
        final DeployException result = new DeployException(String.format(getLoggingLocale(), cannotDeploy$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotDeployAndValidate = "WFLYJCA0031: unable to validate and deploy ds or xads";
    protected String cannotDeployAndValidate$str() {
        return cannotDeployAndValidate;
    }
    @Override
    public final DeployException cannotDeployAndValidate(final Throwable cause) {
        final DeployException result = new DeployException(String.format(getLoggingLocale(), cannotDeployAndValidate$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotStartDs = "WFLYJCA0032: Unable to start the ds because it generated more than one cf";
    protected String cannotStartDs$str() {
        return cannotStartDs;
    }
    @Override
    public final StartException cannotStartDs() {
        final StartException result = new StartException(String.format(getLoggingLocale(), cannotStartDs$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String deploymentError = "WFLYJCA0033: Error during the deployment of %s";
    protected String deploymentError$str() {
        return deploymentError;
    }
    @Override
    public final StartException deploymentError(final Throwable cause, final String name) {
        final StartException result = new StartException(String.format(getLoggingLocale(), deploymentError$str(), name), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInstantiateDriverClass1 = "WFLYJCA0034: Unable to instantiate driver class \"%s\". See log (WARN) for more details";
    protected String cannotInstantiateDriverClass1$str() {
        return cannotInstantiateDriverClass1;
    }
    @Override
    public final String cannotInstantiateDriverClass(final String driverClassName) {
        return String.format(getLoggingLocale(), cannotInstantiateDriverClass1$str(), driverClassName);
    }
    private static final String driverVersionMismatch = "WFLYJCA0035: Specified driver version doesn't match with actual driver version";
    protected String driverVersionMismatch$str() {
        return driverVersionMismatch;
    }
    @Override
    public final IllegalStateException driverVersionMismatch() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), driverVersionMismatch$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToCreate = "WFLYJCA0036: Failed to create %s instance for [%s]%n reason: %s";
    protected String failedToCreate$str() {
        return failedToCreate;
    }
    @Override
    public final String failedToCreate(final String type, final ModelNode operation, final String reasonMessage) {
        return String.format(getLoggingLocale(), failedToCreate$str(), type, operation, reasonMessage);
    }
    private static final String failedToGetMetrics = "WFLYJCA0037: failed to get metrics: %s";
    protected String failedToGetMetrics$str() {
        return failedToGetMetrics;
    }
    @Override
    public final String failedToGetMetrics(final String message) {
        return String.format(getLoggingLocale(), failedToGetMetrics$str(), message);
    }
    private static final String failedToGetUrlDelimiter = "WFLYJCA0039: failed to get url delimiter";
    protected String failedToGetUrlDelimiter$str() {
        return failedToGetUrlDelimiter;
    }
    @Override
    public final DeployException failedToGetUrlDelimiter(final Throwable cause) {
        final DeployException result = new DeployException(String.format(getLoggingLocale(), failedToGetUrlDelimiter$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToInvokeOperation = "WFLYJCA0040: failed to invoke operation: %s";
    protected String failedToInvokeOperation$str() {
        return failedToInvokeOperation;
    }
    @Override
    public final String failedToInvokeOperation(final String message) {
        return String.format(getLoggingLocale(), failedToInvokeOperation$str(), message);
    }
    private static final String failedToLoadModuleDriver = "WFLYJCA0041: Failed to load module for driver [%s]";
    protected String failedToLoadModuleDriver$str() {
        return failedToLoadModuleDriver;
    }
    @Override
    public final String failedToLoadModuleDriver(final String moduleName) {
        return String.format(getLoggingLocale(), failedToLoadModuleDriver$str(), moduleName);
    }
    private static final String failedToMatchPool = "WFLYJCA0042: failed to match pool. Check JndiName: %s";
    protected String failedToMatchPool$str() {
        return failedToMatchPool;
    }
    @Override
    public final IllegalArgumentException failedToMatchPool(final String jndiName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), failedToMatchPool$str(), jndiName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToParseServiceXml = "WFLYJCA0043: Failed to parse service xml [%s]";
    protected String failedToParseServiceXml$str() {
        return failedToParseServiceXml;
    }
    @Override
    public final DeploymentUnitProcessingException failedToParseServiceXml(final VirtualFile xmlFile) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToParseServiceXml$str(), xmlFile));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final DeploymentUnitProcessingException failedToParseServiceXml(final Throwable cause, final VirtualFile xmlFile) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToParseServiceXml$str(), xmlFile), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToProcessRaChild = "WFLYJCA0044: Failed to process RA child archives for [%s]";
    protected String failedToProcessRaChild$str() {
        return failedToProcessRaChild;
    }
    @Override
    public final DeploymentUnitProcessingException failedToProcessRaChild(final Throwable cause, final VirtualFile deploymentRoot) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToProcessRaChild$str(), deploymentRoot), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToSetAttribute = "WFLYJCA0045: failed to set attribute: %s";
    protected String failedToSetAttribute$str() {
        return failedToSetAttribute;
    }
    @Override
    public final String failedToSetAttribute(final String message) {
        return String.format(getLoggingLocale(), failedToSetAttribute$str(), message);
    }
    private static final String failedToStartRaDeployment = "WFLYJCA0046: Failed to start RA deployment [%s]";
    protected String failedToStartRaDeployment$str() {
        return failedToStartRaDeployment;
    }
    @Override
    public final StartException failedToStartRaDeployment(final Throwable cause, final String deploymentName) {
        final StartException result = new StartException(String.format(getLoggingLocale(), failedToStartRaDeployment$str(), deploymentName), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidConnection = "WFLYJCA0047: Connection is not valid";
    protected String invalidConnection$str() {
        return invalidConnection;
    }
    @Override
    public final IllegalStateException invalidConnection() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidConnection$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jndiBindingsNotSupported = "WFLYJCA0049: Non-explicit JNDI bindings not supported";
    protected String jndiBindingsNotSupported$str() {
        return jndiBindingsNotSupported;
    }
    @Override
    public final IllegalStateException jndiBindingsNotSupported() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), jndiBindingsNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noMetricsAvailable = "WFLYJCA0050: no metrics available";
    protected String noMetricsAvailable$str() {
        return noMetricsAvailable;
    }
    @Override
    public final String noMetricsAvailable() {
        return String.format(getLoggingLocale(), noMetricsAvailable$str());
    }
    private static final String notAnAnnotation = "WFLYJCA0051: %s should be an annotation";
    protected String notAnAnnotation$str() {
        return notAnAnnotation;
    }
    @Override
    public final IllegalArgumentException notAnAnnotation(final Class<?> clazz) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), notAnAnnotation$str(), clazz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullVar = "WFLYJCA0052: %s is null";
    protected String nullVar$str() {
        return nullVar;
    }
    @Override
    public final String nullVar(final String name) {
        return String.format(getLoggingLocale(), nullVar$str(), name);
    }
    private static final String serviceAlreadyStarted = "WFLYJCA0053: %s service [%s] is already started";
    protected String serviceAlreadyStarted$str() {
        return serviceAlreadyStarted;
    }
    @Override
    public final String serviceAlreadyStarted(final String serviceType, final Object obj) {
        return String.format(getLoggingLocale(), serviceAlreadyStarted$str(), serviceType, obj);
    }
    private static final String serviceNotAvailable = "WFLYJCA0054: %s service [%s] is not available";
    protected String serviceNotAvailable$str() {
        return serviceNotAvailable;
    }
    @Override
    public final String serviceNotAvailable(final String serviceType, final Object obj) {
        return String.format(getLoggingLocale(), serviceNotAvailable$str(), serviceType, obj);
    }
    private static final String serviceNotStarted = "WFLYJCA0056: Service not started";
    protected String serviceNotStarted$str() {
        return serviceNotStarted;
    }
    @Override
    public final IllegalStateException serviceNotStarted() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), serviceNotStarted$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String undefinedVar = "WFLYJCA0058: %s is undefined";
    protected String undefinedVar$str() {
        return undefinedVar;
    }
    @Override
    public final IllegalArgumentException undefinedVar(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), undefinedVar$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToLoadNativeLibraries = "WFLYJCA0061: Failed to load native libraries";
    protected String failedToLoadNativeLibraries$str() {
        return failedToLoadNativeLibraries;
    }
    @Override
    public final DeploymentUnitProcessingException failedToLoadNativeLibraries(final Throwable cause) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), failedToLoadNativeLibraries$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String exceptionDeployingDatasource = "WFLYJCA0064: Exception deploying datasource %s";
    protected String exceptionDeployingDatasource$str() {
        return exceptionDeployingDatasource;
    }
    @Override
    public final DeploymentUnitProcessingException exceptionDeployingDatasource(final Throwable cause, final String datasource) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), exceptionDeployingDatasource$str(), datasource), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noDataSourceRegisteredForAddress = "WFLYJCA0065: No DataSource exists at address %s";
    protected String noDataSourceRegisteredForAddress$str() {
        return noDataSourceRegisteredForAddress;
    }
    @Override
    public final String noDataSourceRegisteredForAddress(final PathAddress address) {
        return String.format(getLoggingLocale(), noDataSourceRegisteredForAddress$str(), address);
    }
    private static final String unknownAttribute = "WFLYJCA0066: Unknown attribute %s";
    protected String unknownAttribute$str() {
        return unknownAttribute;
    }
    @Override
    public final IllegalStateException unknownAttribute(final String attributeName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownAttribute$str(), attributeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unknownOperation = "WFLYJCA0067: Unknown operation %s";
    protected String unknownOperation$str() {
        return unknownOperation;
    }
    @Override
    public final IllegalStateException unknownOperation(final String attributeName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unknownOperation$str(), attributeName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String xaDataSourcePropertiesNotPresent = "WFLYJCA0069: At least one xa-datasource-property is required for an xa-datasource";
    protected String xaDataSourcePropertiesNotPresent$str() {
        return xaDataSourcePropertiesNotPresent;
    }
    @Override
    public final OperationFailedException xaDataSourcePropertiesNotPresent() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), xaDataSourcePropertiesNotPresent$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jndiNameRequired = "WFLYJCA0070: Jndi name is required";
    protected String jndiNameRequired$str() {
        return jndiNameRequired;
    }
    @Override
    public final OperationFailedException jndiNameRequired() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), jndiNameRequired$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jndiNameInvalidFormat = "WFLYJCA0071: Jndi name have to start with java:/ or java:jboss/";
    protected String jndiNameInvalidFormat$str() {
        return jndiNameInvalidFormat;
    }
    @Override
    public final OperationFailedException jndiNameInvalidFormat() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), jndiNameInvalidFormat$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String deploymentFailed = "WFLYJCA0072: Deployment %s failed";
    protected String deploymentFailed$str() {
        return deploymentFailed;
    }
    @Override
    public final DeployException deploymentFailed(final Throwable cause, final String className) {
        final DeployException result = new DeployException(String.format(getLoggingLocale(), deploymentFailed$str(), className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String failedToLoadModuleRA = "WFLYJCA0073: Failed to load module for RA [%s]";
    protected String failedToLoadModuleRA$str() {
        return failedToLoadModuleRA;
    }
    @Override
    public final String failedToLoadModuleRA(final String moduleName) {
        return String.format(getLoggingLocale(), failedToLoadModuleRA$str(), moduleName);
    }
    private static final String noSuchMethod = "WFLYJCA0074: Method %s not found";
    protected String noSuchMethod$str() {
        return noSuchMethod;
    }
    @Override
    public final NoSuchMethodException noSuchMethod(final String name) {
        final NoSuchMethodException result = new NoSuchMethodException(String.format(getLoggingLocale(), noSuchMethod$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchField = "WFLYJCA0075: Field %s not found";
    protected String noSuchField$str() {
        return noSuchField;
    }
    @Override
    public final NoSuchMethodException noSuchField(final String name) {
        final NoSuchMethodException result = new NoSuchMethodException(String.format(getLoggingLocale(), noSuchField$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noPropertyResolution = "WFLYJCA0076: Unknown property resolution for property %s";
    protected String noPropertyResolution$str() {
        return noPropertyResolution;
    }
    @Override
    public final IllegalArgumentException noPropertyResolution(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noPropertyResolution$str(), name));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String archiveOrModuleRequired = "WFLYJCA0077: At least one of ARCHIVE or MODULE is required";
    protected String archiveOrModuleRequired$str() {
        return archiveOrModuleRequired;
    }
    @Override
    public final OperationFailedException archiveOrModuleRequired() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), archiveOrModuleRequired$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String compressedRarNotSupportedInModuleRA = "WFLYJCA0078: Rar are supported only in uncompressed form. Failed to load module for RA [%s]";
    protected String compressedRarNotSupportedInModuleRA$str() {
        return compressedRarNotSupportedInModuleRA;
    }
    @Override
    public final String compressedRarNotSupportedInModuleRA(final String moduleName) {
        return String.format(getLoggingLocale(), compressedRarNotSupportedInModuleRA$str(), moduleName);
    }
    private static final String FailedDeployDriverNotSpecified = "WFLYJCA0079: Failed to deploy datasource %s because driver is not specified";
    protected String FailedDeployDriverNotSpecified$str() {
        return FailedDeployDriverNotSpecified;
    }
    @Override
    public final DeploymentUnitProcessingException FailedDeployDriverNotSpecified(final String dsName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), FailedDeployDriverNotSpecified$str(), dsName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String RARNotYetDeployed = "WFLYJCA0080: RAR '%s' not yet deployed.";
    protected String RARNotYetDeployed$str() {
        return RARNotYetDeployed;
    }
    @Override
    public final OperationFailedException RARNotYetDeployed(final String raName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), RARNotYetDeployed$str(), raName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidConnectionFactory = "WFLYJCA0083: Connection factory interface (%s) is incorrect for resource adapter '%s' while deploying %s";
    protected String invalidConnectionFactory$str() {
        return invalidConnectionFactory;
    }
    @Override
    public final DeploymentUnitProcessingException invalidConnectionFactory(final String cf, final String ra, final String jndiName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), invalidConnectionFactory$str(), cf, ra, jndiName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String adminObjectForJCA10 = "WFLYJCA0084: Admin object declared for JCA 1.0 resource adapter '%s' while deploying %s";
    protected String adminObjectForJCA10$str() {
        return adminObjectForJCA10;
    }
    @Override
    public final DeploymentUnitProcessingException adminObjectForJCA10(final String ra, final String jndiName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), adminObjectForJCA10$str(), ra, jndiName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidAdminObject = "WFLYJCA0085: Admin object class (%s) is incorrect for resource adapter '%s' while deploying %s";
    protected String invalidAdminObject$str() {
        return invalidAdminObject;
    }
    @Override
    public final DeploymentUnitProcessingException invalidAdminObject(final String ao, final String ra, final String jndiName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), invalidAdminObject$str(), ao, ra, jndiName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void cannotFindDriverClassName(final String driverName) {
        super.log.logf(FQCN, WARN, null, cannotFindDriverClassName$str(), driverName);
    }
    private static final String cannotFindDriverClassName = "WFLYJCA0086: Unable to find driver class name in \"%s\" jar";
    protected String cannotFindDriverClassName$str() {
        return cannotFindDriverClassName;
    }
    @Override
    public final void unableToRegisterRecovery(final String key, final boolean isXa) {
        super.log.logf(FQCN, ERROR, null, unableToRegisterRecovery$str(), key, isXa);
    }
    private static final String unableToRegisterRecovery = "WFLYJCA0087: Unable to register recovery: %s (%s)";
    protected String unableToRegisterRecovery$str() {
        return unableToRegisterRecovery;
    }
    private static final String rejectAttributesMustBeTrue = "WFLYJCA0088: Attributes %s rejected. Must be true";
    protected String rejectAttributesMustBeTrue$str() {
        return rejectAttributesMustBeTrue;
    }
    @Override
    public final String rejectAttributesMustBeTrue(final java.util.Set<String> key) {
        return String.format(getLoggingLocale(), rejectAttributesMustBeTrue$str(), key);
    }
    @Override
    public final void exceptionDuringUnregistering(final NotFoundException nfe) {
        super.log.logf(FQCN, WARN, nfe, exceptionDuringUnregistering$str());
    }
    private static final String exceptionDuringUnregistering = "WFLYJCA0089: Exception during unregistering deployment";
    protected String exceptionDuringUnregistering$str() {
        return exceptionDuringUnregistering;
    }
    private static final String jndiNameShouldValidate = "WFLYJCA0090: Jndi name shouldn't include '//' or end with '/'";
    protected String jndiNameShouldValidate$str() {
        return jndiNameShouldValidate;
    }
    @Override
    public final OperationFailedException jndiNameShouldValidate() {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), jndiNameShouldValidate$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void deprecated() {
        super.log.logf(FQCN, WARN, null, deprecated$str());
    }
    private static final String deprecated = "WFLYJCA0091: -ds.xml file deployments are deprecated. Support may be removed in a future version.";
    protected String deprecated$str() {
        return deprecated;
    }
    private static final String indexedChildResourceRegistrationNotAvailable = "WFLYJCA0092: Indexed child resources can only be registered if the parent resource supports ordered children. The parent of '%s' is not indexed";
    protected String indexedChildResourceRegistrationNotAvailable$str() {
        return indexedChildResourceRegistrationNotAvailable;
    }
    @Override
    public final IllegalStateException indexedChildResourceRegistrationNotAvailable(final PathElement address) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), indexedChildResourceRegistrationNotAvailable$str(), address));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void legacyDisableEnableOperation(final String name) {
        super.log.logf(FQCN, INFO, null, legacyDisableEnableOperation$str(), name);
    }
    private static final String legacyDisableEnableOperation = "WFLYJCA0093: The '%s' operation is deprecated. Use of the 'add' or 'remove' operations is preferred, or if required the 'write-attribute' operation can used to set the deprecated 'enabled' attribute";
    protected String legacyDisableEnableOperation$str() {
        return legacyDisableEnableOperation;
    }
    @Override
    public final void errorDuringRecoveryShutdown(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, errorDuringRecoveryShutdown$str());
    }
    private static final String errorDuringRecoveryShutdown = "WFLYJCA0096: Error during recovery shutdown";
    protected String errorDuringRecoveryShutdown$str() {
        return errorDuringRecoveryShutdown;
    }
    @Override
    public final void errorStoppingRA(final Throwable cause) {
        super.log.logf(FQCN, WARN, cause, errorStoppingRA$str());
    }
    private static final String errorStoppingRA = "WFLYJCA0097: Exception while stopping resource adapter";
    protected String errorStoppingRA$str() {
        return errorStoppingRA;
    }
    @Override
    public final void boundNonJTADataSource(final String jndiName) {
        super.log.logf(FQCN, INFO, null, boundNonJTADataSource$str(), jndiName);
    }
    private static final String boundNonJTADataSource = "WFLYJCA0098: Bound non-transactional data source: %s";
    protected String boundNonJTADataSource$str() {
        return boundNonJTADataSource;
    }
    @Override
    public final void unBoundNonJTADataSource(final String jndiName) {
        super.log.logf(FQCN, INFO, null, unBoundNonJTADataSource$str(), jndiName);
    }
    private static final String unBoundNonJTADataSource = "WFLYJCA0099: Unbound non-transactional data source: %s";
    protected String unBoundNonJTADataSource$str() {
        return unBoundNonJTADataSource;
    }
    private static final String noSupportedOperation = "WFLYJCA0100: Operation %s is not supported";
    protected String noSupportedOperation$str() {
        return noSupportedOperation;
    }
    @Override
    public final UnsupportedOperationException noSupportedOperation(final String operation) {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), noSupportedOperation$str(), operation));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String oneThreadPoolWorkManager = "WFLYJCA0101: Thread pool: %s(type: %s) can not be added for workmanager: %s, only one thread pool is allowed for each type.";
    protected String oneThreadPoolWorkManager$str() {
        return oneThreadPoolWorkManager;
    }
    @Override
    public final OperationFailedException oneThreadPoolWorkManager(final String threadPoolName, final String threadPoolType, final String workManagerName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), oneThreadPoolWorkManager$str(), threadPoolName, threadPoolType, workManagerName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String attributeRequiresTrueAttribute = "WFLYJCA0102: Attribute %s can only be defined if %s is true";
    protected String attributeRequiresTrueAttribute$str() {
        return attributeRequiresTrueAttribute;
    }
    @Override
    public final OperationFailedException attributeRequiresTrueAttribute(final String attribute, final String requiredAttribute) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), attributeRequiresTrueAttribute$str(), attribute, requiredAttribute));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String attributeRequiresFalseOrUndefinedAttribute = "WFLYJCA0103: Attribute %s can only be defined if %s is undefined or false";
    protected String attributeRequiresFalseOrUndefinedAttribute$str() {
        return attributeRequiresFalseOrUndefinedAttribute;
    }
    @Override
    public final OperationFailedException attributeRequiresFalseOrUndefinedAttribute(final String attribute, final String requiredFalseAttribute) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), attributeRequiresFalseOrUndefinedAttribute$str(), attribute, requiredFalseAttribute));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String subject = "WFLYJCA0104: Subject=%s\nSubject identity=%s";
    protected String subject$str() {
        return subject;
    }
    @Override
    public final String subject(final Subject subject, final String identity) {
        return String.format(getLoggingLocale(), subject$str(), subject, identity);
    }
    @Override
    public final void elytronHandlerHandle(final String callbacks) {
        super.log.logf(FQCN, INFO, null, elytronHandlerHandle$str(), callbacks);
    }
    private static final String elytronHandlerHandle = "WFLYJCA0106: Elytron handler handle: %s";
    protected String elytronHandlerHandle$str() {
        return elytronHandlerHandle;
    }
    private static final String executionSubjectNotSetInHandler = "WFLYJCA0107: Execution subject was not provided to the callback handler";
    protected String executionSubjectNotSetInHandler$str() {
        return executionSubjectNotSetInHandler;
    }
    @Override
    public final SecurityException executionSubjectNotSetInHandler() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), executionSubjectNotSetInHandler$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCallbackSecurityDomain = "WFLYJCA0108: Supplied callback doesn't contain a security domain reference";
    protected String invalidCallbackSecurityDomain$str() {
        return invalidCallbackSecurityDomain;
    }
    @Override
    public final IllegalArgumentException invalidCallbackSecurityDomain() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidCallbackSecurityDomain$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedCreateCallbackHandlerMethod = "WFLYJCA0109: Callback with security domain is required - use createCallbackHandler(Callback callback) instead";
    protected String unsupportedCreateCallbackHandlerMethod$str() {
        return unsupportedCreateCallbackHandlerMethod;
    }
    @Override
    public final UnsupportedOperationException unsupportedCreateCallbackHandlerMethod() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), unsupportedCreateCallbackHandlerMethod$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCredentialSourceSupplier = "WFLYJCA0110: CredentialSourceSupplier is invalid for DSSecurity";
    protected String invalidCredentialSourceSupplier$str() {
        return invalidCredentialSourceSupplier;
    }
    @Override
    public final IllegalStateException invalidCredentialSourceSupplier(final Throwable cause) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidCredentialSourceSupplier$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidElytronWorkManagerSetting = "WFLYJCA0111: WorkManager hasn't elytron-enabled flag set accordingly with RA one";
    protected String invalidElytronWorkManagerSetting$str() {
        return invalidElytronWorkManagerSetting;
    }
    @Override
    public final IllegalStateException invalidElytronWorkManagerSetting() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidElytronWorkManagerSetting$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String datasourceIsDisabled = "WFLYJCA0112: Datasource %s is disabled";
    protected String datasourceIsDisabled$str() {
        return datasourceIsDisabled;
    }
    @Override
    public final IllegalArgumentException datasourceIsDisabled(final String jndiName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), datasourceIsDisabled$str(), jndiName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void unexceptedWorkerCompletionError(final String errorMessage, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unexceptedWorkerCompletionError$str(), errorMessage);
    }
    private static final String unexceptedWorkerCompletionError = "WFLYJCA0113: Unexcepted error during worker execution : %s";
    protected String unexceptedWorkerCompletionError$str() {
        return unexceptedWorkerCompletionError;
    }
    private static final String failedToLoadDataSourceClass = "WFLYJCA0114: Failed to load datasource class: %s";
    protected String failedToLoadDataSourceClass$str() {
        return failedToLoadDataSourceClass;
    }
    @Override
    public final OperationFailedException failedToLoadDataSourceClass(final String clsName, final Throwable t) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), failedToLoadDataSourceClass$str(), clsName), t);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingDependencyInModuleDriver = "WFLYJCA0115: Module for driver [%s] or one of it dependencies is missing: [%s]";
    protected String missingDependencyInModuleDriver$str() {
        return missingDependencyInModuleDriver;
    }
    @Override
    public final String missingDependencyInModuleDriver(final String moduleName, final String missingModule) {
        return String.format(getLoggingLocale(), missingDependencyInModuleDriver$str(), moduleName, missingModule);
    }
    private static final String raModuleNotFound = "WFLYJCA0116: Failed to load module for RA [%s] - the module or one of its dependencies is missing [%s]";
    protected String raModuleNotFound$str() {
        return raModuleNotFound;
    }
    @Override
    public final String raModuleNotFound(final String moduleName, final String missingModule) {
        return String.format(getLoggingLocale(), raModuleNotFound$str(), moduleName, missingModule);
    }
    private static final String notAValidDataSourceClass = "WFLYJCA0117: %s is not a valid %s implementation";
    protected String notAValidDataSourceClass$str() {
        return notAValidDataSourceClass;
    }
    @Override
    public final OperationFailedException notAValidDataSourceClass(final String clz, final String dsClz) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), notAValidDataSourceClass$str(), clz, dsClz));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void bindingAlias(final String jndiName, final String alias) {
        super.log.logf(FQCN, INFO, null, bindingAlias$str(), jndiName, alias);
    }
    private static final String bindingAlias = "WFLYJCA0118: Binding connection factory named %s to alias %s";
    protected String bindingAlias$str() {
        return bindingAlias;
    }
    @Override
    public final void unbindingAlias(final String jndiName, final String alias) {
        super.log.logf(FQCN, INFO, null, unbindingAlias$str(), jndiName, alias);
    }
    private static final String unbindingAlias = "WFLYJCA0119: Unbinding connection factory named %s to alias %s";
    protected String unbindingAlias$str() {
        return unbindingAlias;
    }
}
