/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.List;
import org.jboss.as.connector._private.Capabilities;
import org.jboss.as.connector.subsystems.common.pool.PoolConfigurationRWHandler;
import org.jboss.as.connector.subsystems.common.pool.PoolOperations;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourceEnableDisable;
import org.jboss.as.connector.subsystems.datasources.DataSourceRemove;
import org.jboss.as.connector.subsystems.datasources.DataSourcesExtension;
import org.jboss.as.connector.subsystems.datasources.EnlistmentTraceAttributeWriteHandler;
import org.jboss.as.connector.subsystems.datasources.XMLXaDataSourceRuntimeHandler;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceAdd;
import org.jboss.as.connector.subsystems.datasources.XaDataSourcePropertyDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.ApplicationTypeConfig;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.ApplicationTypeAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;

public class XaDataSourceDefinition
extends SimpleResourceDefinition {
    protected static final PathElement PATH_XA_DATASOURCE = PathElement.pathElement((String)"xa-data-source");
    private static final String LEGACY_MCP = "org.jboss.jca.core.connectionmanager.pool.mcp.SemaphoreArrayListManagedConnectionPool";
    private final boolean registerRuntimeOnly;
    private final boolean deployed;
    private final List<AccessConstraintDefinition> accessConstraints;

    private XaDataSourceDefinition(boolean registerRuntimeOnly, boolean deployed) {
        super(PATH_XA_DATASOURCE, (ResourceDescriptionResolver)DataSourcesExtension.getResourceDescriptionResolver("xa-data-source"), (OperationStepHandler)(deployed ? null : XaDataSourceAdd.INSTANCE), (OperationStepHandler)(deployed ? null : DataSourceRemove.XA_INSTANCE));
        this.registerRuntimeOnly = registerRuntimeOnly;
        this.deployed = deployed;
        ApplicationTypeConfig atc = new ApplicationTypeConfig("datasources", "xa-data-source");
        this.accessConstraints = new ApplicationTypeAccessConstraintDefinition(atc).wrapAsList();
    }

    public static XaDataSourceDefinition createInstance(boolean registerRuntimeOnly, boolean deployed) {
        return new XaDataSourceDefinition(registerRuntimeOnly, deployed);
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (!this.deployed) {
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.DATASOURCE_ENABLE, (OperationStepHandler)DataSourceEnableDisable.ENABLE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.DATASOURCE_DISABLE, (OperationStepHandler)DataSourceEnableDisable.DISABLE);
        }
        if (this.registerRuntimeOnly) {
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.FLUSH_IDLE_CONNECTION, (OperationStepHandler)PoolOperations.FlushIdleConnectionInPool.DS_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.FLUSH_ALL_CONNECTION, (OperationStepHandler)PoolOperations.FlushAllConnectionInPool.DS_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.DUMP_QUEUED_THREADS, (OperationStepHandler)PoolOperations.DumpQueuedThreadInPool.DS_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.FLUSH_INVALID_CONNECTION, (OperationStepHandler)PoolOperations.FlushInvalidConnectionInPool.DS_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.FLUSH_GRACEFULLY_CONNECTION, (OperationStepHandler)PoolOperations.FlushGracefullyConnectionInPool.DS_INSTANCE);
            resourceRegistration.registerOperationHandler((OperationDefinition)Constants.TEST_CONNECTION, (OperationStepHandler)PoolOperations.TestConnectionInPool.DS_INSTANCE);
        }
    }

    public void registerCapabilities(ManagementResourceRegistration resourceRegistration) {
        super.registerCapabilities(resourceRegistration);
        if (!this.deployed) {
            resourceRegistration.registerCapability(Capabilities.DATA_SOURCE_CAPABILITY);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        if (this.deployed) {
            SimpleAttributeDefinition runtimeAttribute;
            for (SimpleAttributeDefinition simpleAttributeDefinition : Constants.XA_DATASOURCE_ATTRIBUTE) {
                runtimeAttribute = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(simpleAttributeDefinition).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
                resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)runtimeAttribute, (OperationStepHandler)XMLXaDataSourceRuntimeHandler.INSTANCE);
            }
            for (SimpleAttributeDefinition simpleAttributeDefinition : Constants.XA_DATASOURCE_PROPERTIES_ATTRIBUTES) {
                runtimeAttribute = ((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder((PropertiesAttributeDefinition)simpleAttributeDefinition).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.STORAGE_RUNTIME})).build();
                resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)runtimeAttribute, (OperationStepHandler)XMLXaDataSourceRuntimeHandler.INSTANCE);
            }
        } else {
            void var5_13;
            ReloadRequiredWriteAttributeHandler reloadRequiredWriteHandler = new ReloadRequiredWriteAttributeHandler((AttributeDefinition[])Constants.XA_DATASOURCE_ATTRIBUTE);
            SimpleAttributeDefinition[] simpleAttributeDefinitionArray = Constants.XA_DATASOURCE_ATTRIBUTE;
            int n = simpleAttributeDefinitionArray.length;
            boolean bl = false;
            while (var5_13 < n) {
                SimpleAttributeDefinition attribute = simpleAttributeDefinitionArray[var5_13];
                if (PoolConfigurationRWHandler.ATTRIBUTES.contains(attribute.getName())) {
                    resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, (OperationStepHandler)PoolConfigurationRWHandler.PoolConfigurationReadHandler.INSTANCE, (OperationStepHandler)PoolConfigurationRWHandler.LocalAndXaDataSourcePoolConfigurationWriteHandler.INSTANCE);
                } else if (attribute.getName().equals(Constants.ENLISTMENT_TRACE.getName())) {
                    resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, null, (OperationStepHandler)new EnlistmentTraceAttributeWriteHandler());
                } else {
                    resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, null, (OperationStepHandler)reloadRequiredWriteHandler);
                }
                ++var5_13;
            }
            ReloadRequiredWriteAttributeHandler reloadRequiredPropertiesWriteHandler = new ReloadRequiredWriteAttributeHandler((AttributeDefinition[])Constants.XA_DATASOURCE_PROPERTIES_ATTRIBUTES);
            for (PropertiesAttributeDefinition attribute : Constants.XA_DATASOURCE_PROPERTIES_ATTRIBUTES) {
                if (PoolConfigurationRWHandler.ATTRIBUTES.contains(attribute.getName())) {
                    resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, (OperationStepHandler)PoolConfigurationRWHandler.PoolConfigurationReadHandler.INSTANCE, (OperationStepHandler)PoolConfigurationRWHandler.LocalAndXaDataSourcePoolConfigurationWriteHandler.INSTANCE);
                    continue;
                }
                resourceRegistration.registerReadWriteAttribute((AttributeDefinition)attribute, null, (OperationStepHandler)reloadRequiredPropertiesWriteHandler);
            }
        }
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        if (this.deployed) {
            resourceRegistration.registerSubModel((ResourceDefinition)XaDataSourcePropertyDefinition.DEPLOYED_INSTANCE);
        } else {
            resourceRegistration.registerSubModel((ResourceDefinition)XaDataSourcePropertyDefinition.INSTANCE);
        }
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return this.accessConstraints;
    }
}

