/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ra;

import jakarta.resource.ConnectionFactoryDefinition;
import jakarta.resource.ConnectionFactoryDefinitions;
import jakarta.resource.spi.TransactionSupport;
import org.jboss.as.connector.deployers.ra.ConnectionFactoryDefinitionInjectionSource;
import org.jboss.as.ee.resource.definition.ResourceDefinitionAnnotationProcessor;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.DotName;
import org.jboss.metadata.property.PropertyReplacer;

public class ConnectionFactoryDefinitionAnnotationProcessor
extends ResourceDefinitionAnnotationProcessor {
    private static final DotName CONNECTION_FACTORY_DEFINITION = DotName.createSimple((String)ConnectionFactoryDefinition.class.getName());
    private static final DotName CONNECTION_FACTORY_DEFINITIONS = DotName.createSimple((String)ConnectionFactoryDefinitions.class.getName());
    private final boolean legacySecurityAvailable;

    public ConnectionFactoryDefinitionAnnotationProcessor(boolean legacySecurityAvailable) {
        this.legacySecurityAvailable = legacySecurityAvailable;
    }

    protected DotName getAnnotationDotName() {
        return CONNECTION_FACTORY_DEFINITION;
    }

    protected DotName getAnnotationCollectionDotName() {
        return CONNECTION_FACTORY_DEFINITIONS;
    }

    protected ResourceDefinitionInjectionSource processAnnotation(AnnotationInstance annotationInstance, PropertyReplacer propertyReplacer) throws DeploymentUnitProcessingException {
        String name = ResourceDefinitionAnnotationProcessor.AnnotationElement.asRequiredString((AnnotationInstance)annotationInstance, (String)"name");
        String interfaceName = ResourceDefinitionAnnotationProcessor.AnnotationElement.asRequiredString((AnnotationInstance)annotationInstance, (String)"interfaceName");
        String ra = ResourceDefinitionAnnotationProcessor.AnnotationElement.asRequiredString((AnnotationInstance)annotationInstance, (String)"resourceAdapter");
        ConnectionFactoryDefinitionInjectionSource directConnectionFactoryInjectionSource = new ConnectionFactoryDefinitionInjectionSource(name, interfaceName, ra);
        directConnectionFactoryInjectionSource.setDescription(ResourceDefinitionAnnotationProcessor.AnnotationElement.asOptionalString((AnnotationInstance)annotationInstance, (String)"description"));
        directConnectionFactoryInjectionSource.setMaxPoolSize(ResourceDefinitionAnnotationProcessor.AnnotationElement.asOptionalInt((AnnotationInstance)annotationInstance, (String)"maxPoolSize"));
        directConnectionFactoryInjectionSource.setMinPoolSize(ResourceDefinitionAnnotationProcessor.AnnotationElement.asOptionalInt((AnnotationInstance)annotationInstance, (String)"minPoolSize"));
        directConnectionFactoryInjectionSource.addProperties(ResourceDefinitionAnnotationProcessor.AnnotationElement.asOptionalStringArray((AnnotationInstance)annotationInstance, (String)"properties"));
        directConnectionFactoryInjectionSource.setTransactionSupportLevel(this.asTransactionSupportLocal(annotationInstance, "transactionSupport"));
        directConnectionFactoryInjectionSource.setLegacySecurityAvailable(this.legacySecurityAvailable);
        return directConnectionFactoryInjectionSource;
    }

    private TransactionSupport.TransactionSupportLevel asTransactionSupportLocal(AnnotationInstance annotation, String property) {
        AnnotationValue value = annotation.value(property);
        return value == null ? null : TransactionSupport.TransactionSupportLevel.valueOf((String)((String)value.value()));
    }
}

