/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.resourceadapters.deployment;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.services.resourceadapters.ResourceAdapterService;
import org.jboss.as.connector.services.resourceadapters.deployment.AbstractResourceAdapterDeploymentService;
import org.jboss.as.connector.services.resourceadapters.deployment.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.subsystems.resourceadapters.ModifiableResourceAdapter;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.naming.WritableServiceBasedNamingStore;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.metadata.merge.Merger;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.Configuration;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class ResourceAdapterXmlDeploymentService
extends AbstractResourceAdapterDeploymentService
implements Service<ResourceAdapterDeployment> {
    private static final DeployersLogger DEPLOYERS_LOGGER = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)"org.jboss.as.connector.deployers.RaXmlDeployer");
    private final Module module;
    private final ConnectorXmlDescriptor connectorXmlDescriptor;
    private Activation raxml;
    private final String deployment;
    private String raName;
    private ServiceName deploymentServiceName;
    private CommonDeployment raxmlDeployment = null;
    private final ServiceName duServiceName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceAdapterXmlDeploymentService(ConnectorXmlDescriptor connectorXmlDescriptor, Activation raxml, Module module, String deployment, ServiceName deploymentServiceName, ServiceName duServiceName) {
        this.connectorXmlDescriptor = connectorXmlDescriptor;
        ResourceAdapterXmlDeploymentService resourceAdapterXmlDeploymentService = this;
        synchronized (resourceAdapterXmlDeploymentService) {
            this.raxml = raxml;
        }
        this.module = module;
        this.deployment = deployment;
        this.raName = deployment;
        this.deploymentServiceName = deploymentServiceName;
        this.duServiceName = duServiceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        try {
            ServiceName raServiceName;
            Connector cmd = ((AS7MetadataRepository)this.mdr.getValue()).getResourceAdapter(this.deployment);
            File root = ((AS7MetadataRepository)this.mdr.getValue()).getRoot(this.deployment);
            Activation localRaXml = this.getRaxml();
            cmd = new Merger().mergeConnectorWithCommonIronJacamar(localRaXml, cmd);
            String id = ((ModifiableResourceAdapter)this.raxml).getId();
            if (id == null || id.trim().isEmpty()) {
                raServiceName = ConnectorServices.getResourceAdapterServiceName(this.raName);
                this.connectorServicesRegistrationName = this.raName;
            } else {
                raServiceName = ConnectorServices.getResourceAdapterServiceName(id);
                this.connectorServicesRegistrationName = id;
            }
            WildFlyRaXmlDeployer raDeployer = new WildFlyRaXmlDeployer(context.getChildTarget(), this.connectorXmlDescriptor.getUrl(), this.raName, root, (ClassLoader)this.module.getClassLoader(), cmd, localRaXml, this.deploymentServiceName);
            raDeployer.setConfiguration((Configuration)this.config.getValue());
            WritableServiceBasedNamingStore.pushOwner((ServiceName)this.duServiceName);
            ClassLoader old = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
            try {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.module.getClassLoader());
                this.raxmlDeployment = raDeployer.doDeploy();
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
                WritableServiceBasedNamingStore.popOwner();
            }
            this.value = new ResourceAdapterDeployment(this.raxmlDeployment, this.raName, raServiceName);
            ((ManagementRepository)this.managementRepository.getValue()).getConnectors().add(this.value.getDeployment().getConnector());
            ((ResourceAdapterDeploymentRegistry)this.registry.getValue()).registerResourceAdapterDeployment(this.value);
            ServiceBuilder raServiceSB = context.getChildTarget().addService(raServiceName, (Service)new ResourceAdapterService(raServiceName, this.value.getDeployment().getResourceAdapter()));
            raServiceSB.requires(this.deploymentServiceName);
            raServiceSB.setInitialMode(ServiceController.Mode.ACTIVE).install();
        }
        catch (Throwable t) {
            this.cleanupStartAsync(context, this.raName, this.deploymentServiceName, t);
        }
    }

    public void stop(StopContext context) {
        this.stopAsync(context, this.raName, this.deploymentServiceName);
    }

    @Override
    public Collection<String> getJndiAliases() {
        return Collections.emptyList();
    }

    public CommonDeployment getRaxmlDeployment() {
        return this.raxmlDeployment;
    }

    public synchronized void setRaxml(Activation raxml) {
        this.raxml = raxml;
    }

    public synchronized Activation getRaxml() {
        return this.raxml;
    }

    private class WildFlyRaXmlDeployer
    extends AbstractResourceAdapterDeploymentService.AbstractWildFlyRaDeployer {
        private final Activation activation;

        public WildFlyRaXmlDeployer(ServiceTarget serviceTarget, URL url, String deploymentName, File root, ClassLoader cl, Connector cmd, Activation activation, ServiceName deploymentServiceName) {
            super(serviceTarget, url, deploymentName, root, cl, cmd, deploymentServiceName);
            this.activation = activation;
        }

        @Override
        public CommonDeployment doDeploy() throws Throwable {
            this.setConfiguration((Configuration)ResourceAdapterXmlDeploymentService.this.getConfig().getValue());
            this.start();
            CommonDeployment dep = this.createObjectsAndInjectValue(this.url, this.deploymentName, this.root, this.cl, this.cmd, this.activation);
            return dep;
        }

        @Override
        protected boolean checkActivation(Connector cmd, Activation activation) {
            return true;
        }

        protected DeployersLogger getLogger() {
            return DEPLOYERS_LOGGER;
        }

        protected void setRecoveryForResourceAdapterInResourceAdapterRepository(String key, boolean isXA) {
            try {
                ((ResourceAdapterRepository)ResourceAdapterXmlDeploymentService.this.raRepository.getValue()).setRecoveryForResourceAdapter(key, isXA);
            }
            catch (Throwable t) {
                ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.unableToRegisterRecovery(key, isXA);
            }
        }
    }
}

