/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.datasource;

import org.jboss.as.connector.deployers.datasource.DataSourceDefinitionInjectionSource;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.ee.resource.definition.ResourceDefinitionDescriptorProcessor;
import org.jboss.as.ee.resource.definition.ResourceDefinitionInjectionSource;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.metadata.javaee.spec.DataSourceMetaData;
import org.jboss.metadata.javaee.spec.DataSourcesMetaData;
import org.jboss.metadata.javaee.spec.RemoteEnvironment;

public class DataSourceDefinitionDescriptorProcessor
extends ResourceDefinitionDescriptorProcessor {
    protected void processEnvironment(RemoteEnvironment environment, ResourceDefinitionDescriptorProcessor.ResourceDefinitionInjectionSources injectionSources) throws DeploymentUnitProcessingException {
        DataSourcesMetaData metaDatas = environment.getDataSources();
        if (metaDatas != null) {
            for (DataSourceMetaData metaData : metaDatas) {
                injectionSources.addResourceDefinitionInjectionSource(this.getResourceDefinitionInjectionSource(metaData));
            }
        }
    }

    private ResourceDefinitionInjectionSource getResourceDefinitionInjectionSource(DataSourceMetaData metaData) {
        String name = metaData.getName();
        if (name == null || name.isEmpty()) {
            throw EeLogger.ROOT_LOGGER.elementAttributeMissing("<data-source>", "name");
        }
        DataSourceDefinitionInjectionSource resourceDefinitionInjectionSource = new DataSourceDefinitionInjectionSource(name);
        String className = metaData.getClassName();
        if (className == null || className.equals(Object.class.getName())) {
            throw EeLogger.ROOT_LOGGER.elementAttributeMissing("<data-source>", "className");
        }
        resourceDefinitionInjectionSource.setClassName(className);
        resourceDefinitionInjectionSource.setDatabaseName(metaData.getDatabaseName());
        if (metaData.getDescriptions() != null) {
            resourceDefinitionInjectionSource.setDescription(metaData.getDescriptions().toString());
        }
        resourceDefinitionInjectionSource.setInitialPoolSize(metaData.getInitialPoolSize());
        if (metaData.getIsolationLevel() != null) {
            resourceDefinitionInjectionSource.setIsolationLevel(metaData.getIsolationLevel().ordinal());
        }
        resourceDefinitionInjectionSource.setLoginTimeout(metaData.getLoginTimeout());
        resourceDefinitionInjectionSource.setMaxIdleTime(metaData.getMaxIdleTime());
        resourceDefinitionInjectionSource.setMaxStatements(metaData.getMaxStatements());
        resourceDefinitionInjectionSource.setMaxPoolSize(metaData.getMaxPoolSize());
        resourceDefinitionInjectionSource.setMinPoolSize(metaData.getMinPoolSize());
        resourceDefinitionInjectionSource.setInitialPoolSize(metaData.getInitialPoolSize());
        resourceDefinitionInjectionSource.setPassword(metaData.getPassword());
        resourceDefinitionInjectionSource.setPortNumber(metaData.getPortNumber());
        resourceDefinitionInjectionSource.addProperties(metaData.getProperties());
        resourceDefinitionInjectionSource.setServerName(metaData.getServerName());
        resourceDefinitionInjectionSource.setTransactional(metaData.getTransactional());
        resourceDefinitionInjectionSource.setUrl(metaData.getUrl());
        resourceDefinitionInjectionSource.setUser(metaData.getUser());
        return resourceDefinitionInjectionSource;
    }
}

