/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.metadata.common;

import java.lang.invoke.MethodHandles;
import java.util.Objects;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.metadata.api.common.Credential;
import org.jboss.jca.common.CommonBundle;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.logging.Messages;
import org.wildfly.common.function.ExceptionSupplier;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.password.interfaces.ClearPassword;

public class CredentialImpl
implements Credential {
    private static final long serialVersionUID = 7990943957924515091L;
    private static CommonBundle bundle = (CommonBundle)Messages.getBundle((MethodHandles.Lookup)MethodHandles.lookup(), CommonBundle.class);
    private final String userName;
    private final String password;
    private final String securityDomain;
    private final ExceptionSupplier<CredentialSource, Exception> credentialSourceSupplier;

    public CredentialImpl(String userName, String password, String securityContext, ExceptionSupplier<CredentialSource, Exception> credentialSourceSupplier) throws ValidateException {
        this.userName = userName;
        this.password = password;
        this.securityDomain = securityContext;
        this.credentialSourceSupplier = credentialSourceSupplier;
    }

    public void validate() throws ValidateException {
        if (this.userName != null && this.securityDomain != null) {
            throw new ValidateException(bundle.invalidSecurityConfiguration());
        }
    }

    public final String getSecurityDomain() {
        return this.securityDomain;
    }

    public final String resolveSecurityDomain() {
        return this.getSecurityDomain();
    }

    public final String getUserName() {
        return this.userName;
    }

    public final String getPassword() {
        if (this.credentialSourceSupplier != null) {
            try {
                return new String(((ClearPassword)((PasswordCredential)((CredentialSource)this.credentialSourceSupplier.get()).getCredential(PasswordCredential.class)).getPassword(ClearPassword.class)).getPassword());
            }
            catch (Exception e) {
                throw ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.invalidCredentialSourceSupplier(e);
            }
        }
        return this.password;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CredentialImpl that = (CredentialImpl)o;
        return Objects.equals(this.userName, that.userName) && Objects.equals(this.password, that.password) && Objects.equals(this.securityDomain, that.securityDomain) && Objects.equals(this.credentialSourceSupplier, that.credentialSourceSupplier);
    }

    public int hashCode() {
        return Objects.hash(this.userName, this.password, this.securityDomain, this.credentialSourceSupplier);
    }

    public String toString() {
        return "CredentialImpl{userName='" + this.userName + "', password='" + this.password + "', securityDomain='" + this.securityDomain + "', credentialSourceSupplier=" + String.valueOf(this.credentialSourceSupplier) + "}";
    }
}

