/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.ds.processors;

import java.sql.Driver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.jboss.as.connector.deployers.ds.processors.DsXmlDeploymentParsingProcessor;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.logging.ConnectorMessages;
import org.jboss.as.connector.services.driver.registry.DriverRegistry;
import org.jboss.as.connector.subsystems.datasources.AbstractDataSourceService;
import org.jboss.as.connector.subsystems.datasources.DataSourceReferenceFactoryService;
import org.jboss.as.connector.subsystems.datasources.DataSourceStatisticsListener;
import org.jboss.as.connector.subsystems.datasources.DataSourcesSubsystemProviders;
import org.jboss.as.connector.subsystems.datasources.LocalDataSourceService;
import org.jboss.as.connector.subsystems.datasources.ModifiableDataSource;
import org.jboss.as.connector.subsystems.datasources.ModifiableXaDataSource;
import org.jboss.as.connector.subsystems.datasources.Util;
import org.jboss.as.connector.subsystems.datasources.XMLDataSourceRuntimeHandler;
import org.jboss.as.connector.subsystems.datasources.XMLXaDataSourceRuntimeHandler;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceService;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.as.server.deployment.DeploymentModelUtils;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.jca.common.api.metadata.Defaults;
import org.jboss.jca.common.api.metadata.ds.DataSources;
import org.jboss.jca.common.api.metadata.ds.v12.DsXaPool;
import org.jboss.jca.common.api.metadata.ds.v12.XaDataSource;
import org.jboss.jca.common.api.validator.ValidateException;
import org.jboss.jca.common.metadata.ds.v12.DsXaPoolImpl;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.SubjectFactory;

public class DsXmlDeploymentInstallProcessor
implements DeploymentUnitProcessor {
    private static final String DATA_SOURCE = "data-source";
    private static final String XA_DATA_SOURCE = "xa-data-source";
    private static final String CONNECTION_PROPERTIES = "connection-properties";
    private static final String XA_CONNECTION_PROPERTIES = "xa-datasource-properties";
    private static final PathAddress SUBSYSTEM_ADDRESS = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"datasources")});
    private static final PathAddress DATASOURCE_ADDRESS;
    private static final PathAddress XA_DATASOURCE_ADDRESS;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        List dataSourcesList = deploymentUnit.getAttachmentList(DsXmlDeploymentParsingProcessor.DATA_SOURCES_ATTACHMENT_KEY);
        for (DataSources dataSources : dataSourcesList) {
            PathAddress addr;
            String dsName;
            String jndiName;
            int i;
            if (dataSources.getDrivers() != null && dataSources.getDrivers().size() > 0) {
                ConnectorLogger.DS_DEPLOYER_LOGGER.driversElementNotSupported(deploymentUnit.getName());
            }
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
            if (dataSources.getDataSource() != null && dataSources.getDataSource().size() > 0) {
                for (i = 0; i < dataSources.getDataSource().size(); ++i) {
                    org.jboss.jca.common.api.metadata.ds.v12.DataSource ds = (org.jboss.jca.common.api.metadata.ds.v12.DataSource)dataSources.getDataSource().get(i);
                    if (ds.isEnabled().booleanValue() && ds.getDriver() != null) {
                        try {
                            jndiName = Util.cleanJndiName(ds.getJndiName(), ds.isUseJavaContext());
                            LocalDataSourceService lds = new LocalDataSourceService(jndiName);
                            lds.getDataSourceConfigInjector().inject((Object)this.buildDataSource(ds));
                            dsName = ds.getJndiName();
                            addr = DsXmlDeploymentInstallProcessor.getDataSourceAddress(dsName, deploymentUnit, false);
                            this.installManagementModel(ds, deploymentUnit, addr);
                            this.startDataSource(lds, jndiName, ds.getDriver(), serviceTarget, verificationHandler, this.getRegistration(false, deploymentUnit), this.getResource(dsName, false, deploymentUnit), dsName);
                            continue;
                        }
                        catch (Exception e) {
                            throw ConnectorMessages.MESSAGES.exceptionDeployingDatasource(e, ds.getJndiName());
                        }
                    }
                    ConnectorLogger.DS_DEPLOYER_LOGGER.debugf("Ignoring: %s", ds.getJndiName());
                }
            }
            if (dataSources.getXaDataSource() == null || dataSources.getXaDataSource().size() <= 0) continue;
            for (i = 0; i < dataSources.getXaDataSource().size(); ++i) {
                XaDataSource xads = (XaDataSource)dataSources.getXaDataSource().get(i);
                if (xads.isEnabled().booleanValue() && xads.getDriver() != null) {
                    try {
                        jndiName = Util.cleanJndiName(xads.getJndiName(), xads.isUseJavaContext());
                        XaDataSourceService xds = new XaDataSourceService(jndiName);
                        xds.getDataSourceConfigInjector().inject((Object)this.buildXaDataSource(xads));
                        dsName = xads.getJndiName();
                        addr = DsXmlDeploymentInstallProcessor.getDataSourceAddress(dsName, deploymentUnit, true);
                        this.installManagementModel(xads, deploymentUnit, addr);
                        this.startDataSource(xds, jndiName, xads.getDriver(), serviceTarget, verificationHandler, this.getRegistration(true, deploymentUnit), this.getResource(dsName, true, deploymentUnit), dsName);
                        continue;
                    }
                    catch (Exception e) {
                        throw ConnectorMessages.MESSAGES.exceptionDeployingDatasource(e, xads.getJndiName());
                    }
                }
                ConnectorLogger.DS_DEPLOYER_LOGGER.debugf("Ignoring %s", xads.getJndiName());
            }
        }
    }

    private void installManagementModel(org.jboss.jca.common.api.metadata.ds.v12.DataSource ds, DeploymentUnit deploymentUnit, PathAddress addr) {
        XMLDataSourceRuntimeHandler.INSTANCE.registerDataSource(addr, ds);
        deploymentUnit.createDeploymentSubModel("datasources", addr.getLastElement());
        if (ds.getConnectionProperties() != null) {
            for (Map.Entry prop : ds.getConnectionProperties().entrySet()) {
                PathAddress registration = PathAddress.pathAddress((PathElement[])new PathElement[]{addr.getLastElement(), PathElement.pathElement((String)CONNECTION_PROPERTIES, (String)((String)prop.getKey()))});
                DsXmlDeploymentInstallProcessor.createDeploymentSubModel(registration, deploymentUnit);
            }
        }
    }

    private void installManagementModel(XaDataSource ds, DeploymentUnit deploymentUnit, PathAddress addr) {
        XMLXaDataSourceRuntimeHandler.INSTANCE.registerDataSource(addr, ds);
        deploymentUnit.createDeploymentSubModel("datasources", addr.getLastElement());
        if (ds.getXaDataSourceProperty() != null) {
            for (Map.Entry prop : ds.getXaDataSourceProperty().entrySet()) {
                PathAddress registration = PathAddress.pathAddress((PathElement[])new PathElement[]{addr.getLastElement(), PathElement.pathElement((String)XA_CONNECTION_PROPERTIES, (String)((String)prop.getKey()))});
                DsXmlDeploymentInstallProcessor.createDeploymentSubModel(registration, deploymentUnit);
            }
        }
    }

    private void undeployDataSource(org.jboss.jca.common.api.metadata.ds.v12.DataSource ds, DeploymentUnit deploymentUnit) {
        PathAddress addr = DsXmlDeploymentInstallProcessor.getDataSourceAddress(ds.getJndiName(), deploymentUnit, false);
        XMLDataSourceRuntimeHandler.INSTANCE.unregisterDataSource(addr);
    }

    private void undeployXaDataSource(XaDataSource ds, DeploymentUnit deploymentUnit) {
        PathAddress addr = DsXmlDeploymentInstallProcessor.getDataSourceAddress(ds.getJndiName(), deploymentUnit, true);
        XMLXaDataSourceRuntimeHandler.INSTANCE.unregisterDataSource(addr);
    }

    public void undeploy(DeploymentUnit context) {
        List dataSourcesList = context.getAttachmentList(DsXmlDeploymentParsingProcessor.DATA_SOURCES_ATTACHMENT_KEY);
        for (DataSources dataSources : dataSourcesList) {
            int i;
            if (dataSources.getDataSource() != null) {
                for (i = 0; i < dataSources.getDataSource().size(); ++i) {
                    org.jboss.jca.common.api.metadata.ds.v12.DataSource ds = (org.jboss.jca.common.api.metadata.ds.v12.DataSource)dataSources.getDataSource().get(i);
                    this.undeployDataSource(ds, context);
                }
            }
            if (dataSources.getXaDataSource() == null) continue;
            for (i = 0; i < dataSources.getXaDataSource().size(); ++i) {
                XaDataSource xads = (XaDataSource)dataSources.getXaDataSource().get(i);
                this.undeployXaDataSource(xads, context);
            }
        }
    }

    private ModifiableDataSource buildDataSource(org.jboss.jca.common.api.metadata.ds.v12.DataSource ds) throws ValidateException {
        return new ModifiableDataSource(ds.getConnectionUrl(), ds.getDriverClass(), ds.getDataSourceClass(), ds.getDriver(), ds.getTransactionIsolation(), ds.getConnectionProperties(), ds.getTimeOut(), ds.getSecurity(), ds.getStatement(), ds.getValidation(), ds.getUrlDelimiter(), ds.getUrlSelectorStrategyClassName(), ds.getNewConnectionSql(), ds.isUseJavaContext(), ds.getPoolName(), ds.isEnabled(), ds.getJndiName(), ds.isSpy(), ds.isUseCcm(), ds.isJTA(), ds.getPool());
    }

    private ModifiableXaDataSource buildXaDataSource(XaDataSource xads) throws ValidateException {
        DsXaPoolImpl xaPool;
        if (xads.getXaPool() == null) {
            xaPool = new DsXaPoolImpl(Defaults.MIN_POOL_SIZE, Defaults.INITIAL_POOL_SIZE, Defaults.MAX_POOL_SIZE, Defaults.PREFILL, Defaults.USE_STRICT_MIN, Defaults.FLUSH_STRATEGY, Defaults.IS_SAME_RM_OVERRIDE, Defaults.INTERLEAVING, Defaults.PAD_XID, Defaults.WRAP_XA_RESOURCE, Defaults.NO_TX_SEPARATE_POOL, Defaults.ALLOW_MULTIPLE_USERS, null, null);
        } else {
            DsXaPool p = xads.getXaPool();
            xaPool = new DsXaPoolImpl(this.getDef(p.getMinPoolSize(), Defaults.MIN_POOL_SIZE), this.getDef(p.getInitialPoolSize(), Defaults.INITIAL_POOL_SIZE), this.getDef(p.getMaxPoolSize(), Defaults.MAX_POOL_SIZE), this.getDef(p.isPrefill(), Defaults.PREFILL), this.getDef(p.isUseStrictMin(), Defaults.USE_STRICT_MIN), this.getDef(p.getFlushStrategy(), Defaults.FLUSH_STRATEGY), this.getDef(p.isSameRmOverride(), Defaults.IS_SAME_RM_OVERRIDE), this.getDef(p.isInterleaving(), Defaults.INTERLEAVING), this.getDef(p.isPadXid(), Defaults.PAD_XID), this.getDef(p.isWrapXaResource(), Defaults.WRAP_XA_RESOURCE), this.getDef(p.isNoTxSeparatePool(), Defaults.NO_TX_SEPARATE_POOL), this.getDef(p.isAllowMultipleUsers(), Defaults.ALLOW_MULTIPLE_USERS), p.getCapacity(), p.getConnectionListener());
        }
        return new ModifiableXaDataSource(xads.getTransactionIsolation(), xads.getTimeOut(), xads.getSecurity(), xads.getStatement(), xads.getValidation(), xads.getUrlDelimiter(), xads.getUrlProperty(), xads.getUrlSelectorStrategyClassName(), xads.isUseJavaContext(), xads.getPoolName(), xads.isEnabled(), xads.getJndiName(), xads.isSpy(), xads.isUseCcm(), xads.getXaDataSourceProperty(), xads.getXaDataSourceClass(), xads.getDriver(), xads.getNewConnectionSql(), (DsXaPool)xaPool, xads.getRecovery());
    }

    private <T> T getDef(T value, T def) {
        return value != null ? value : def;
    }

    private void startDataSource(AbstractDataSourceService dataSourceService, final String jndiName, String driverName, ServiceTarget serviceTarget, ServiceVerificationHandler verificationHandler, ManagementResourceRegistration registration, Resource resource, String managementName) {
        ServiceName dataSourceServiceName = AbstractDataSourceService.SERVICE_NAME_BASE.append(new String[]{jndiName});
        ServiceBuilder dataSourceServiceBuilder = serviceTarget.addService(dataSourceServiceName, (Service)dataSourceService).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, dataSourceService.getTransactionIntegrationInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSITORY_SERVICE, ManagementRepository.class, dataSourceService.getManagementRepositoryInjector()).addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, dataSourceService.getSubjectFactoryInjector()).addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, dataSourceService.getCcmInjector()).addDependency(ConnectorServices.JDBC_DRIVER_REGISTRY_SERVICE, DriverRegistry.class, dataSourceService.getDriverRegistryInjector()).addDependency(NamingService.SERVICE_NAME);
        if (registration.isAllowsOverride() && registration.getOverrideModel(managementName) == null) {
            registration.registerOverrideModel(managementName, DataSourcesSubsystemProviders.OVERRIDE_DS_DESC);
        }
        dataSourceServiceBuilder.addListener((ServiceListener)new DataSourceStatisticsListener(registration, resource, managementName));
        ServiceName driverServiceName = ServiceName.JBOSS.append(new String[]{"jdbc-driver", driverName.replaceAll("\\.", "_")});
        if (driverServiceName != null) {
            dataSourceServiceBuilder.addDependency(driverServiceName, Driver.class, dataSourceService.getDriverInjector());
        }
        DataSourceReferenceFactoryService referenceFactoryService = new DataSourceReferenceFactoryService();
        ServiceName referenceFactoryServiceName = DataSourceReferenceFactoryService.SERVICE_NAME_BASE.append(new String[]{jndiName});
        ServiceBuilder referenceBuilder = serviceTarget.addService(referenceFactoryServiceName, (Service)referenceFactoryService).addDependency(dataSourceServiceName, DataSource.class, referenceFactoryService.getDataSourceInjector());
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        BinderService binderService = new BinderService(bindInfo.getBindName());
        ServiceBuilder binderBuilder = serviceTarget.addService(bindInfo.getBinderServiceName(), (Service)binderService).addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, binderService.getManagedObjectInjector()).addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector()).addListener((ServiceListener)new AbstractServiceListener<Object>(){

            public void transition(ServiceController<?> controller, ServiceController.Transition transition) {
                switch (transition) {
                    case STARTING_to_UP: {
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.boundDataSource(jndiName);
                        break;
                    }
                    case START_REQUESTED_to_DOWN: {
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.unboundDataSource(jndiName);
                        break;
                    }
                    case REMOVING_to_REMOVED: {
                        ConnectorLogger.SUBSYSTEM_DATASOURCES_LOGGER.debugf("Removed JDBC Data-source [%s]", jndiName);
                    }
                }
            }
        });
        dataSourceServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install();
        referenceBuilder.setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install();
        binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE).addListener((ServiceListener)verificationHandler).install();
    }

    private static PathAddress getDataSourceAddress(String jndiName, DeploymentUnit deploymentUnit, boolean xa) {
        ArrayList<PathElement> elements = new ArrayList<PathElement>();
        if (deploymentUnit.getParent() == null) {
            elements.add(PathElement.pathElement((String)"deployment", (String)deploymentUnit.getName()));
        } else {
            elements.add(PathElement.pathElement((String)"deployment", (String)deploymentUnit.getParent().getName()));
            elements.add(PathElement.pathElement((String)"subdeployment", (String)deploymentUnit.getName()));
        }
        elements.add(PathElement.pathElement((String)"subsystem", (String)"datasources"));
        if (xa) {
            elements.add(PathElement.pathElement((String)XA_DATA_SOURCE, (String)jndiName));
        } else {
            elements.add(PathElement.pathElement((String)DATA_SOURCE, (String)jndiName));
        }
        return PathAddress.pathAddress(elements);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ManagementResourceRegistration createDeploymentSubModel(PathAddress address, DeploymentUnit unit) {
        Resource root;
        Resource resource = root = (Resource)unit.getAttachment(DeploymentModelUtils.DEPLOYMENT_RESOURCE);
        synchronized (resource) {
            ManagementResourceRegistration registration = (ManagementResourceRegistration)unit.getAttachment(DeploymentModelUtils.MUTABLE_REGISTRATION_ATTACHMENT);
            PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"datasources")});
            Resource subsystem = DsXmlDeploymentInstallProcessor.getOrCreate(root, subsystemAddress);
            ManagementResourceRegistration subModel = registration.getSubModel(subsystemAddress.append(address));
            if (subModel == null) {
                throw new IllegalStateException(address.toString());
            }
            DsXmlDeploymentInstallProcessor.getOrCreate(subsystem, address);
            return subModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Resource getOrCreate(Resource parent, PathAddress address) {
        Resource current = parent;
        for (PathElement element : address) {
            Resource resource = current;
            synchronized (resource) {
                if (current.hasChild(element)) {
                    current = current.requireChild(element);
                } else {
                    Resource resource2 = Resource.Factory.create();
                    current.registerChild(element, resource2);
                    current = resource2;
                }
            }
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource getResource(String dsName, boolean xa, DeploymentUnit unit) {
        Resource root = (Resource)unit.getAttachment(DeploymentModelUtils.DEPLOYMENT_RESOURCE);
        String key = xa ? XA_DATA_SOURCE : DATA_SOURCE;
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)key, (String)dsName)});
        Resource resource = root;
        synchronized (resource) {
            Resource subsystem = DsXmlDeploymentInstallProcessor.getOrCreate(root, SUBSYSTEM_ADDRESS);
            return DsXmlDeploymentInstallProcessor.getOrCreate(subsystem, address);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagementResourceRegistration getRegistration(boolean xa, DeploymentUnit unit) {
        Resource root;
        Resource resource = root = (Resource)unit.getAttachment(DeploymentModelUtils.DEPLOYMENT_RESOURCE);
        synchronized (resource) {
            ManagementResourceRegistration registration = (ManagementResourceRegistration)unit.getAttachment(DeploymentModelUtils.MUTABLE_REGISTRATION_ATTACHMENT);
            PathAddress address = xa ? XA_DATASOURCE_ADDRESS : DATASOURCE_ADDRESS;
            ManagementResourceRegistration subModel = registration.getSubModel(address);
            if (subModel == null) {
                throw new IllegalStateException(address.toString());
            }
            return subModel;
        }
    }

    static {
        XA_DATASOURCE_ADDRESS = SUBSYSTEM_ADDRESS.append(new PathElement[]{PathElement.pathElement((String)XA_DATA_SOURCE)});
        DATASOURCE_ADDRESS = SUBSYSTEM_ADDRESS.append(new PathElement[]{PathElement.pathElement((String)DATA_SOURCE)});
    }
}

