/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.resourceadapters;

import java.util.Map;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.subsystems.resourceadapters.Constants;
import org.jboss.as.connector.subsystems.resourceadapters.IronJacamarResource;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.common.api.metadata.common.CommonAdminObject;
import org.jboss.jca.common.api.metadata.common.CommonPool;
import org.jboss.jca.common.api.metadata.common.CommonSecurity;
import org.jboss.jca.common.api.metadata.common.CommonTimeOut;
import org.jboss.jca.common.api.metadata.common.CommonValidation;
import org.jboss.jca.common.api.metadata.common.CommonXaPool;
import org.jboss.jca.common.api.metadata.common.Credential;
import org.jboss.jca.common.api.metadata.common.Extension;
import org.jboss.jca.common.api.metadata.common.Recovery;
import org.jboss.jca.common.api.metadata.common.v11.CommonConnDef;
import org.jboss.jca.common.api.metadata.common.v11.ConnDefPool;
import org.jboss.jca.common.api.metadata.common.v11.WorkManagerSecurity;
import org.jboss.jca.common.api.metadata.ironjacamar.IronJacamar;

public class IronJacamarResourceCreator {
    public static final IronJacamarResourceCreator INSTANCE = new IronJacamarResourceCreator();

    private void setAttribute(ModelNode model, SimpleAttributeDefinition node, String value) {
        if (value != null) {
            model.get(node.getName()).set(value);
        }
    }

    private void setAttribute(ModelNode model, SimpleAttributeDefinition node, Boolean value) {
        if (value != null) {
            model.get(node.getName()).set(value.booleanValue());
        }
    }

    private void setAttribute(ModelNode model, SimpleAttributeDefinition node, Integer value) {
        if (value != null) {
            model.get(node.getName()).set(value.intValue());
        }
    }

    private void setAttribute(ModelNode model, SimpleAttributeDefinition node, Long value) {
        if (value != null) {
            model.get(node.getName()).set(value.longValue());
        }
    }

    private void addConfigProperties(Resource parent, String name, String value) {
        IronJacamarResource.IronJacamarRuntimeResource config = new IronJacamarResource.IronJacamarRuntimeResource();
        ModelNode model = config.getModel();
        model.get(Constants.CONFIG_PROPERTY_VALUE.getName()).set(value);
        PathElement element = PathElement.pathElement((String)Constants.CONFIG_PROPERTIES.getName(), (String)name);
        parent.registerChild(element, (Resource)config);
    }

    private void addConnectionDefinition(Resource parent, org.jboss.jca.common.api.metadata.common.CommonConnDef connDef) {
        Recovery recovery;
        CommonValidation validation;
        CommonTimeOut timeOut;
        CommonSecurity security;
        CommonPool pool;
        IronJacamarResource.IronJacamarRuntimeResource connDefResource = new IronJacamarResource.IronJacamarRuntimeResource();
        ModelNode model = connDefResource.getModel();
        this.setAttribute(model, Constants.JNDINAME, connDef.getJndiName());
        if (connDef.getConfigProperties() != null) {
            for (Map.Entry config : connDef.getConfigProperties().entrySet()) {
                this.addConfigProperties((Resource)connDefResource, (String)config.getKey(), (String)config.getValue());
            }
        }
        this.setAttribute(model, Constants.CLASS_NAME, connDef.getClassName());
        this.setAttribute(model, Constants.JNDINAME, connDef.getJndiName());
        this.setAttribute(model, Constants.USE_JAVA_CONTEXT, connDef.isUseJavaContext());
        this.setAttribute(model, Constants.ENABLED, connDef.isEnabled());
        this.setAttribute(model, Constants.USE_CCM, connDef.isUseCcm());
        if (connDef instanceof CommonConnDef) {
            this.setAttribute(model, Constants.SHARABLE, ((CommonConnDef)connDef).isSharable());
            this.setAttribute(model, Constants.ENLISTMENT, ((CommonConnDef)connDef).isEnlistment());
        }
        if ((pool = connDef.getPool()) != null) {
            this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.MAX_POOL_SIZE, pool.getMaxPoolSize());
            this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.MIN_POOL_SIZE, pool.getMinPoolSize());
            if (pool instanceof ConnDefPool) {
                this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.INITIAL_POOL_SIZE, ((ConnDefPool)pool).getInitialPoolSize());
                if (((ConnDefPool)pool).getCapacity() != null) {
                    if (((ConnDefPool)pool).getCapacity().getIncrementer() != null) {
                        this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_CLASS, ((ConnDefPool)pool).getCapacity().getIncrementer().getClassName());
                        if (((ConnDefPool)pool).getCapacity().getIncrementer().getConfigPropertiesMap() != null) {
                            for (Map.Entry config : ((ConnDefPool)pool).getCapacity().getIncrementer().getConfigPropertiesMap().entrySet()) {
                                model.get(new String[]{org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_INCREMENTER_PROPERTIES.getName(), (String)config.getKey()}).set((String)config.getValue());
                            }
                        }
                    }
                    if (((ConnDefPool)pool).getCapacity().getDecrementer() != null) {
                        this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_CLASS, ((ConnDefPool)pool).getCapacity().getDecrementer().getClassName());
                        if (((ConnDefPool)pool).getCapacity().getDecrementer().getConfigPropertiesMap() != null) {
                            for (Map.Entry config : ((ConnDefPool)pool).getCapacity().getDecrementer().getConfigPropertiesMap().entrySet()) {
                                model.get(new String[]{org.jboss.as.connector.subsystems.common.pool.Constants.CAPACITY_DECREMENTER_PROPERTIES.getName(), (String)config.getKey()}).set((String)config.getValue());
                            }
                        }
                    }
                }
            }
            this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_USE_STRICT_MIN, pool.isUseStrictMin());
            if (pool.getFlushStrategy() != null) {
                this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FLUSH_STRATEGY, pool.getFlushStrategy().name());
            }
            this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.POOL_PREFILL, pool.isPrefill());
            if (connDef.isXa().booleanValue()) {
                assert (connDef.getPool() instanceof CommonXaPool);
                CommonXaPool xaPool = (CommonXaPool)connDef.getPool();
                this.setAttribute(model, Constants.WRAP_XA_RESOURCE, xaPool.isWrapXaResource());
                this.setAttribute(model, Constants.SAME_RM_OVERRIDE, xaPool.isSameRmOverride());
                this.setAttribute(model, Constants.PAD_XID, xaPool.isPadXid());
                this.setAttribute(model, Constants.INTERLEAVING, xaPool.isInterleaving());
                this.setAttribute(model, Constants.NOTXSEPARATEPOOL, xaPool.isNoTxSeparatePool());
            }
        }
        if ((security = connDef.getSecurity()) != null) {
            this.setAttribute(model, Constants.SECURITY_DOMAIN_AND_APPLICATION, security.getSecurityDomainAndApplication());
            this.setAttribute(model, Constants.APPLICATION, security.isApplication());
            this.setAttribute(model, Constants.SECURITY_DOMAIN, security.getSecurityDomain());
        }
        if ((timeOut = connDef.getTimeOut()) != null) {
            this.setAttribute(model, Constants.ALLOCATION_RETRY, timeOut.getAllocationRetry());
            this.setAttribute(model, Constants.ALLOCATION_RETRY_WAIT_MILLIS, timeOut.getAllocationRetryWaitMillis());
            this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.BLOCKING_TIMEOUT_WAIT_MILLIS, timeOut.getBlockingTimeoutMillis());
            this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.IDLETIMEOUTMINUTES, timeOut.getIdleTimeoutMinutes());
            this.setAttribute(model, Constants.XA_RESOURCE_TIMEOUT, timeOut.getXaResourceTimeout());
        }
        if ((validation = connDef.getValidation()) != null) {
            this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATIONMILLIS, validation.getBackgroundValidationMillis());
            this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.BACKGROUNDVALIDATION, validation.isBackgroundValidation());
            this.setAttribute(model, org.jboss.as.connector.subsystems.common.pool.Constants.USE_FAST_FAIL, validation.isUseFastFail());
        }
        if ((recovery = connDef.getRecovery()) != null) {
            Credential recoveryCredential;
            this.setAttribute(model, Constants.NO_RECOVERY, recovery.getNoRecovery());
            Extension recoverPlugin = recovery.getRecoverPlugin();
            if (recoverPlugin != null) {
                this.setAttribute(model, Constants.RECOVERLUGIN_CLASSNAME, recoverPlugin.getClassName());
                if (recoverPlugin.getConfigPropertiesMap() != null) {
                    for (Map.Entry config : recoverPlugin.getConfigPropertiesMap().entrySet()) {
                        model.get(new String[]{Constants.RECOVERLUGIN_PROPERTIES.getName(), (String)config.getKey()}).set((String)config.getValue());
                    }
                }
            }
            if ((recoveryCredential = recovery.getCredential()) != null) {
                this.setAttribute(model, Constants.RECOVERY_PASSWORD, recoveryCredential.getPassword());
                this.setAttribute(model, Constants.RECOVERY_SECURITY_DOMAIN, recoveryCredential.getSecurityDomain());
                this.setAttribute(model, Constants.RECOVERY_USERNAME, recoveryCredential.getUserName());
            }
        }
        PathElement element = PathElement.pathElement((String)"connection-definitions", (String)connDef.getJndiName());
        parent.registerChild(element, (Resource)connDefResource);
    }

    private void addAdminObject(Resource parent, CommonAdminObject adminObject) {
        IronJacamarResource.IronJacamarRuntimeResource adminObjectResource = new IronJacamarResource.IronJacamarRuntimeResource();
        ModelNode model = adminObjectResource.getModel();
        this.setAttribute(model, Constants.CLASS_NAME, adminObject.getClassName());
        this.setAttribute(model, Constants.JNDINAME, adminObject.getJndiName());
        this.setAttribute(model, Constants.USE_JAVA_CONTEXT, adminObject.isUseJavaContext());
        this.setAttribute(model, Constants.ENABLED, adminObject.isEnabled());
        if (adminObject.getConfigProperties() != null) {
            for (Map.Entry config : adminObject.getConfigProperties().entrySet()) {
                this.addConfigProperties((Resource)adminObjectResource, (String)config.getKey(), (String)config.getValue());
            }
        }
        PathElement element = PathElement.pathElement((String)"admin-objects", (String)adminObject.getJndiName());
        parent.registerChild(element, (Resource)adminObjectResource);
    }

    private void addResourceAdapter(Resource parent, String name, IronJacamar ironJacamarMetadata) {
        org.jboss.jca.common.api.metadata.ironjacamar.v11.IronJacamar ij11;
        IronJacamarResource.IronJacamarRuntimeResource ijResourceAdapter = new IronJacamarResource.IronJacamarRuntimeResource();
        ModelNode model = ijResourceAdapter.getModel();
        model.get(Constants.ARCHIVE.getName()).set(name);
        this.setAttribute(model, Constants.BOOTSTRAP_CONTEXT, ironJacamarMetadata.getBootstrapContext());
        if (ironJacamarMetadata.getTransactionSupport() != null) {
            model.get(Constants.TRANSACTION_SUPPORT.getName()).set(ironJacamarMetadata.getTransactionSupport().name());
        }
        if (ironJacamarMetadata instanceof org.jboss.jca.common.api.metadata.ironjacamar.v11.IronJacamar && (ij11 = (org.jboss.jca.common.api.metadata.ironjacamar.v11.IronJacamar)ironJacamarMetadata).getWorkManager() != null && ij11.getWorkManager().getSecurity() != null) {
            PathElement element;
            ModelNode subModel;
            IronJacamarResource.IronJacamarRuntimeResource mapping;
            WorkManagerSecurity workManagerSecurity = ij11.getWorkManager().getSecurity();
            model.get(Constants.WM_SECURITY.getName()).set(true);
            for (String string : workManagerSecurity.getDefaultGroups()) {
                model.get(Constants.WM_SECURITY_DEFAULT_GROUPS.getName()).add(string);
            }
            model.get(Constants.WM_SECURITY_DEFAULT_PRINCIPAL.getName()).set(workManagerSecurity.getDefaultPrincipal());
            model.get(Constants.WM_SECURITY_MAPPING_REQUIRED.getName()).set(workManagerSecurity.isMappingRequired());
            model.get(Constants.WM_SECURITY_DOMAIN.getName()).set(workManagerSecurity.getDomain());
            for (Map.Entry entry : workManagerSecurity.getGroupMappings().entrySet()) {
                mapping = new IronJacamarResource.IronJacamarRuntimeResource();
                subModel = mapping.getModel();
                subModel.get(Constants.WM_SECURITY_MAPPING_FROM.getName()).set((String)entry.getKey());
                subModel.get(Constants.WM_SECURITY_MAPPING_TO.getName()).set((String)entry.getKey());
                element = PathElement.pathElement((String)Constants.WM_SECURITY_MAPPING_GROUPS.getName(), (String)Constants.WM_SECURITY_MAPPING_GROUP.getName());
                ijResourceAdapter.registerChild(element, (Resource)mapping);
            }
            for (Map.Entry entry : workManagerSecurity.getUserMappings().entrySet()) {
                mapping = new IronJacamarResource.IronJacamarRuntimeResource();
                subModel = mapping.getModel();
                subModel.get(Constants.WM_SECURITY_MAPPING_FROM.getName()).set((String)entry.getKey());
                subModel.get(Constants.WM_SECURITY_MAPPING_TO.getName()).set((String)entry.getKey());
                element = PathElement.pathElement((String)Constants.WM_SECURITY_MAPPING_USERS.getName(), (String)Constants.WM_SECURITY_MAPPING_USER.getName());
                ijResourceAdapter.registerChild(element, (Resource)mapping);
            }
        }
        if (ironJacamarMetadata.getBeanValidationGroups() != null) {
            for (String string : ironJacamarMetadata.getBeanValidationGroups()) {
                model.get(Constants.BEANVALIDATION_GROUPS.getName()).add(new ModelNode().set(string));
            }
        }
        if (ironJacamarMetadata.getConfigProperties() != null) {
            for (Map.Entry entry : ironJacamarMetadata.getConfigProperties().entrySet()) {
                this.addConfigProperties((Resource)ijResourceAdapter, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (ironJacamarMetadata.getConnectionDefinitions() != null) {
            for (org.jboss.jca.common.api.metadata.common.CommonConnDef commonConnDef : ironJacamarMetadata.getConnectionDefinitions()) {
                this.addConnectionDefinition((Resource)ijResourceAdapter, commonConnDef);
            }
        }
        if (ironJacamarMetadata.getAdminObjects() != null) {
            for (CommonAdminObject commonAdminObject : ironJacamarMetadata.getAdminObjects()) {
                this.addAdminObject((Resource)ijResourceAdapter, commonAdminObject);
            }
        }
        PathElement element = PathElement.pathElement((String)"resource-adapter", (String)name);
        parent.registerChild(element, (Resource)ijResourceAdapter);
    }

    private Resource getIronJacamarResource(AS7MetadataRepository mdr) {
        Resource resource = Resource.Factory.create();
        for (String name : mdr.getResourceAdaptersWithIronJacamarMetadata()) {
            this.addResourceAdapter(resource, name, mdr.getIronJcamarMetaData(name));
        }
        return resource;
    }

    public void execute(Resource parentResource, AS7MetadataRepository mdr) {
        IronJacamarResource ironJacamarResource = new IronJacamarResource();
        Resource storeModel = this.getIronJacamarResource(mdr);
        ironJacamarResource.update(storeModel);
        PathElement ijPe = PathElement.pathElement((String)"ironjacamar", (String)"ironjacamar");
        if (parentResource.getChild(ijPe) == null) {
            parentResource.registerChild(ijPe, (Resource)ironJacamarResource);
        }
    }
}

