/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.logging;

import java.sql.Driver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;

@MessageLogger(projectCode="JBAS")
public interface ConnectorLogger
extends BasicLogger {
    public static final ConnectorLogger ROOT_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)ConnectorLogger.class.getPackage().getName());
    public static final ConnectorLogger DEPLOYER_JDBC_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.deployers.jdbc");
    public static final ConnectorLogger DEPLOYMENT_CONNECTOR_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.deployment");
    public static final ConnectorLogger DEPLOYMENT_CONNECTOR_REGISTRY_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.deployment.registry");
    public static final ConnectorLogger DS_DEPLOYER_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.deployer.dsdeployer");
    public static final ConnectorLogger MDR_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.services.mdr");
    public static final ConnectorLogger SUBSYSTEM_DATASOURCES_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.subsystems.datasources");
    public static final ConnectorLogger SUBSYSTEM_RA_LOGGER = (ConnectorLogger)Logger.getMessageLogger(ConnectorLogger.class, (String)"org.jboss.as.connector.subsystems.resourceadapters");

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10400, value="Bound data source [%s]")
    public void boundDataSource(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10401, value="Bound JCA %s [%s]")
    public void boundJca(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10402, value="Unable to instantiate driver class \"%s\": %s")
    public void cannotInstantiateDriverClass(String var1, Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10403, value="Deploying JDBC-compliant driver %s (version %d.%d)")
    public void deployingCompliantJdbcDriver(Class<? extends Driver> var1, int var2, int var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10404, value="Deploying non-JDBC-compliant driver %s (version %d.%d)")
    public void deployingNonCompliantJdbcDriver(Class<? extends Driver> var1, int var2, int var3);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10405, value="Registered admin object at %s")
    public void registeredAdminObject(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10406, value="Registered connection factory %s")
    public void registeredConnectionFactory(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10407, value="Starting service %s")
    public void startingService(ServiceName var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10408, value="Starting %s Subsystem (%s)")
    public void startingSubsystem(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10409, value="Unbound data source [%s]")
    public void unboundDataSource(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10410, value="Unbound JCA %s [%s]")
    public void unboundJca(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10411, value="<drivers/> in standalone -ds.xml deployments aren't supported: Ignoring %s")
    public void driversElementNotSupported(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10415, value="Method %s on DataSource class %s not found. Ignoring")
    public void methodNotFoundOnDataSource(String var1, Class<?> var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=10416, value="Forcing ironjacamar.xml descriptor to null")
    public void forceIJToNull();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10417, value="Started Driver service with driver-name = %s")
    public void startedDriverService(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=10418, value="Stopped Driver service with driver-name = %s")
    public void stoppeddDriverService(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10419, value="Unsupported selector's option: %s")
    public void unsupportedSelectorOption(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10420, value="Unsupported policy's option: %s")
    public void unsupportedPolicyOption(String var1);

    @Message(id=10421, value="Failed to start JGroups channel %s for distributed workmanager %s")
    public StartException failedToStartJGroupsChannel(String var1, String var2);

    @Message(id=10422, value="Cannot find WorkManager %s or it isn't a distributed workmanager. Only DWM can override configurations")
    public OperationFailedException failedToFindDistributedWorkManager(String var1);

    @Message(id=10423, value="Failed to start JGroups transport for distributed workmanager %s")
    public StartException failedToStartDWMTransport(String var1);

    @Message(id=10424, value="Unsupported selector's option: %s")
    public OperationFailedException unsupportedSelector(String var1);

    @Message(id=10425, value="Unsupported policy's option: %s")
    public OperationFailedException unsupportedPolicy(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10426, value="No ironjacamar.security defined for %s")
    public void noSecurityDefined(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10427, value="@ConnectionFactoryDefinition will have limited management: %s")
    public void connectionFactoryAnnotation(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10428, value="@AdministeredObjectDefinition will have limited management: %s")
    public void adminObjectAnnotation(String var1);
}

