/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.resourceadapters.deployment;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.services.resourceadapters.ResourceAdapterService;
import org.jboss.as.connector.services.resourceadapters.deployment.AbstractResourceAdapterDeploymentService;
import org.jboss.as.connector.services.resourceadapters.deployment.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.subsystems.resourceadapters.RaOperationUtil;
import org.jboss.as.connector.util.ConnectorServices;
import org.jboss.as.naming.WritableServiceBasedNamingStore;
import org.jboss.jca.common.api.metadata.resourceadapter.Activation;
import org.jboss.jca.common.api.metadata.resourceadapter.ConnectionDefinition;
import org.jboss.jca.common.api.metadata.spec.AdminObject;
import org.jboss.jca.common.api.metadata.spec.Connector;
import org.jboss.jca.common.api.metadata.spec.ResourceAdapter;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.deployers.DeployersLogger;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.jca.deployers.common.Configuration;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.security.manager.WildFlySecurityManager;

public final class ResourceAdapterDeploymentService
extends AbstractResourceAdapterDeploymentService
implements Service<ResourceAdapterDeployment> {
    private static final DeployersLogger DEPLOYERS_LOGGER = (DeployersLogger)Logger.getMessageLogger(DeployersLogger.class, (String)"org.jboss.as.connector.deployers.RADeployer");
    private final ClassLoader classLoader;
    private final ConnectorXmlDescriptor connectorXmlDescriptor;
    private final Connector cmd;
    private final Activation activation;
    private CommonDeployment raDeployment = null;
    private String deploymentName;
    private ServiceName deploymentServiceName;
    private final ServiceName duServiceName;

    public ResourceAdapterDeploymentService(ConnectorXmlDescriptor connectorXmlDescriptor, Connector cmd, Activation activation, ClassLoader classLoader, ServiceName deploymentServiceName, ServiceName duServiceName) {
        this.connectorXmlDescriptor = connectorXmlDescriptor;
        this.cmd = cmd;
        this.activation = activation;
        this.classLoader = classLoader;
        this.deploymentServiceName = deploymentServiceName;
        this.duServiceName = duServiceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(StartContext context) throws StartException {
        URL url = this.connectorXmlDescriptor == null ? null : this.connectorXmlDescriptor.getUrl();
        this.connectorServicesRegistrationName = this.deploymentName = this.connectorXmlDescriptor == null ? null : this.connectorXmlDescriptor.getDeploymentName();
        File root = this.connectorXmlDescriptor == null ? null : this.connectorXmlDescriptor.getRoot();
        ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debugf("DEPLOYMENT name = %s", this.deploymentName);
        boolean fromModule = this.duServiceName.getParent().equals(RaOperationUtil.RAR_MODULE);
        AS7RaDeployer raDeployer = new AS7RaDeployer(context.getChildTarget(), url, this.deploymentName, root, this.classLoader, this.cmd, this.activation, this.deploymentServiceName, fromModule);
        raDeployer.setConfiguration((Configuration)this.config.getValue());
        ClassLoader old = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            try {
                WritableServiceBasedNamingStore.pushOwner((ServiceName)this.duServiceName);
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)this.classLoader);
                this.raDeployment = raDeployer.doDeploy();
                this.deploymentName = this.raDeployment.getDeploymentName();
            }
            finally {
                WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
                WritableServiceBasedNamingStore.popOwner();
            }
            if (raDeployer.checkActivation(this.cmd, this.activation)) {
                ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debugf("Activating: %s", this.deploymentName);
                ServiceName raServiceName = ConnectorServices.getResourceAdapterServiceName(this.deploymentName);
                this.value = new ResourceAdapterDeployment(this.raDeployment, this.deploymentName, raServiceName);
                ((ManagementRepository)this.managementRepository.getValue()).getConnectors().add(this.value.getDeployment().getConnector());
                ((ResourceAdapterDeploymentRegistry)this.registry.getValue()).registerResourceAdapterDeployment(this.value);
                context.getChildTarget().addService(raServiceName, (Service)new ResourceAdapterService(this.deploymentName, raServiceName, this.value.getDeployment().getResourceAdapter())).setInitialMode(ServiceController.Mode.ACTIVE).install();
            } else {
                ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.debugf("Not activating: %s", this.deploymentName);
            }
        }
        catch (Throwable t) {
            this.cleanupStartAsync(context, this.deploymentName, t, this.duServiceName, this.classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupStartAsync(final StartContext context, final String deploymentName, final Throwable cause, final ServiceName duServiceName, final ClassLoader toUse) {
        ExecutorService executorService = this.getLifecycleExecutorService();
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ClassLoader old = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
                try {
                    WritableServiceBasedNamingStore.pushOwner((ServiceName)duServiceName);
                    WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)toUse);
                    ResourceAdapterDeploymentService.this.unregisterAll(deploymentName);
                }
                finally {
                    try {
                        context.failed(ConnectorLogger.ROOT_LOGGER.failedToStartRaDeployment(cause, deploymentName));
                    }
                    finally {
                        WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)old);
                        WritableServiceBasedNamingStore.popOwner();
                    }
                }
            }
        };
        try {
            executorService.execute(r);
        }
        catch (RejectedExecutionException e) {
            r.run();
        }
        finally {
            context.asynchronous();
        }
    }

    public void stop(StopContext context) {
        this.stopAsync(context, this.deploymentName, this.deploymentServiceName);
    }

    public CommonDeployment getRaDeployment() {
        return this.raDeployment;
    }

    public AS7MetadataRepository getMdr() {
        return (AS7MetadataRepository)this.mdr.getValue();
    }

    private class AS7RaDeployer
    extends AbstractResourceAdapterDeploymentService.AbstractAS7RaDeployer {
        private final Activation activation;
        private final boolean fromModule;

        public AS7RaDeployer(ServiceTarget serviceContainer, URL url, String deploymentName, File root, ClassLoader cl, Connector cmd, Activation activation, ServiceName deploymentServiceName, boolean fromModule) {
            super(serviceContainer, url, deploymentName, root, cl, cmd, deploymentServiceName);
            this.activation = activation;
            this.fromModule = fromModule;
        }

        @Override
        public CommonDeployment doDeploy() throws Throwable {
            this.setConfiguration((Configuration)ResourceAdapterDeploymentService.this.getConfig().getValue());
            this.start();
            CommonDeployment dep = this.createObjectsAndInjectValue(this.url, this.deploymentName, this.root, this.cl, this.cmd, this.activation);
            return dep;
        }

        @Override
        protected boolean checkActivation(Connector cmd, Activation activation) {
            if (cmd != null) {
                List aoMetas;
                List cdMetas;
                HashSet<String> raMcfClasses = new HashSet<String>();
                HashSet<String> raAoClasses = new HashSet<String>();
                ResourceAdapter ra = cmd.getResourceadapter();
                if (ra != null && ra.getOutboundResourceadapter() != null && ra.getOutboundResourceadapter().getConnectionDefinitions() != null && (cdMetas = ra.getOutboundResourceadapter().getConnectionDefinitions()).size() > 0) {
                    for (org.jboss.jca.common.api.metadata.spec.ConnectionDefinition cdMeta : cdMetas) {
                        raMcfClasses.add(cdMeta.getManagedConnectionFactoryClass().getValue());
                    }
                }
                if (ra != null && ra.getAdminObjects() != null && (aoMetas = ra.getAdminObjects()).size() > 0) {
                    for (AdminObject aoMeta : aoMetas) {
                        raAoClasses.add(aoMeta.getAdminobjectClass().getValue());
                    }
                }
                if (raMcfClasses.size() == 0 && raAoClasses.size() == 0 && !this.fromModule) {
                    return true;
                }
                if (activation != null) {
                    String clz;
                    if (activation.getConnectionDefinitions() != null) {
                        for (ConnectionDefinition def : activation.getConnectionDefinitions()) {
                            clz = def.getClassName();
                            if (!raMcfClasses.contains(clz)) continue;
                            return true;
                        }
                    }
                    if (activation.getAdminObjects() != null) {
                        for (ConnectionDefinition def : activation.getAdminObjects()) {
                            clz = def.getClassName();
                            if (!raAoClasses.contains(clz)) continue;
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        protected DeployersLogger getLogger() {
            return DEPLOYERS_LOGGER;
        }

        protected void setRecoveryForResourceAdapterInResourceAdapterRepository(String key, boolean isXA) {
            try {
                ((ResourceAdapterRepository)ResourceAdapterDeploymentService.this.raRepository.getValue()).setRecoveryForResourceAdapter(key, isXA);
            }
            catch (Throwable t) {
                ConnectorLogger.DEPLOYMENT_CONNECTOR_LOGGER.unableToRegisterRecovery(key, isXA);
            }
        }
    }
}

