/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.plugins.providers.multipart.AbstractMultipartWriter;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataOutput;
import org.jboss.resteasy.plugins.providers.multipart.MultipartOutput;
import org.jboss.resteasy.plugins.providers.multipart.OutputPart;
import org.jboss.resteasy.plugins.providers.multipart.i18n.Messages;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;

public class AbstractMultipartFormDataWriter
extends AbstractMultipartWriter {
    @Override
    protected void writeParts(MultipartOutput multipartOutput, OutputStream entityStream, byte[] boundaryBytes) throws IOException {
        if (!(multipartOutput instanceof MultipartFormDataOutput)) {
            throw new IllegalArgumentException(Messages.MESSAGES.hadToWriteMultipartOutput(multipartOutput, this, MultipartFormDataOutput.class));
        }
        MultipartFormDataOutput form = (MultipartFormDataOutput)multipartOutput;
        for (Map.Entry<String, List<OutputPart>> entry : form.getFormDataMap().entrySet()) {
            for (OutputPart outputPart : entry.getValue()) {
                if (outputPart.getEntity() == null) continue;
                MultivaluedMapImpl headers = new MultivaluedMapImpl();
                headers.putSingle((Object)"Content-Disposition", (Object)("form-data; name=\"" + entry.getKey() + "\"" + this.getFilename(outputPart)));
                this.writePart(entityStream, boundaryBytes, outputPart, (MultivaluedMap<String, Object>)headers);
            }
        }
    }

    private String getFilename(OutputPart part) {
        String filename = part.getFilename();
        if (filename == null) {
            return "";
        }
        String encodedFilename = filename;
        try {
            encodedFilename = URLEncoder.encode(filename, "UTF-8");
            if (!encodedFilename.equals(filename)) {
                return "; filename*=utf-8''" + encodedFilename.replaceAll("\\+", "%20");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return "; filename=\"" + filename + "\"";
    }
}

