/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.claims;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.cxf.sts.claims.ClaimsUtils;
import org.apache.cxf.sts.claims.ProcessedClaim;
import org.apache.cxf.sts.claims.ProcessedClaimCollection;
import org.apache.cxf.sts.token.provider.AttributeStatementProvider;
import org.apache.cxf.sts.token.provider.TokenProviderParameters;
import org.apache.wss4j.common.saml.bean.AttributeBean;
import org.apache.wss4j.common.saml.bean.AttributeStatementBean;

public class CombinedClaimsAttributeStatementProvider
implements AttributeStatementProvider {
    private String nameFormat = "urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified";

    @Override
    public AttributeStatementBean getStatement(TokenProviderParameters providerParameters) {
        boolean saml2;
        ProcessedClaimCollection retrievedClaims = ClaimsUtils.processClaims(providerParameters);
        if (retrievedClaims == null) {
            return null;
        }
        Iterator claimIterator = retrievedClaims.iterator();
        if (!claimIterator.hasNext()) {
            return null;
        }
        LinkedHashMap<AttributeKey, AttributeBean> attributeMap = new LinkedHashMap<AttributeKey, AttributeBean>();
        String tokenType = providerParameters.getTokenRequirements().getTokenType();
        boolean bl = saml2 = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0".equals(tokenType) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(tokenType);
        while (claimIterator.hasNext()) {
            ProcessedClaim claim = (ProcessedClaim)((Object)claimIterator.next());
            AttributeKey attributeKey = this.createAttributeKey(claim, saml2);
            attributeMap.merge(attributeKey, this.createAttributeBean(attributeKey, claim.getValues()), (v1, v2) -> {
                v1.getAttributeValues().addAll(claim.getValues());
                return v1;
            });
        }
        AttributeStatementBean attrBean = new AttributeStatementBean();
        attrBean.setSamlAttributes(new ArrayList(attributeMap.values()));
        return attrBean;
    }

    private AttributeBean createAttributeBean(AttributeKey attributeKey, List<Object> claimValues) {
        AttributeBean attributeBean = new AttributeBean(attributeKey.getSimpleName(), attributeKey.getQualifiedName(), claimValues);
        attributeBean.setNameFormat(attributeKey.getNameFormat());
        return attributeBean;
    }

    private AttributeKey createAttributeKey(ProcessedClaim claim, boolean saml2) {
        URI claimType = claim.getClaimType();
        if (saml2) {
            return new AttributeKey(claimType.toString(), this.nameFormat, null);
        }
        String uri = claimType.toString();
        int lastSlash = uri.lastIndexOf("/");
        if (lastSlash == uri.length() - 1) {
            uri = uri.substring(0, lastSlash);
            lastSlash = uri.lastIndexOf("/");
        }
        String namespace = uri.substring(0, lastSlash);
        String name = uri.substring(lastSlash + 1, uri.length());
        return new AttributeKey(namespace, null, name);
    }

    public String getNameFormat() {
        return this.nameFormat;
    }

    public void setNameFormat(String nameFormat) {
        this.nameFormat = nameFormat;
    }

    private static class AttributeKey {
        private final String qualifiedName;
        private final String simpleName;
        private final String nameFormat;

        AttributeKey(String qualifiedName, String nameFormat, String simpleName) {
            this.qualifiedName = qualifiedName;
            this.nameFormat = nameFormat;
            this.simpleName = simpleName;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        public String getSimpleName() {
            return this.simpleName;
        }

        public String getNameFormat() {
            return this.nameFormat;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AttributeKey)) {
                return false;
            }
            AttributeKey that = (AttributeKey)o;
            if (this.qualifiedName == null && that.qualifiedName != null || this.qualifiedName != null && !this.qualifiedName.equals(that.qualifiedName)) {
                return false;
            }
            if (this.simpleName == null && that.simpleName != null || this.simpleName != null && !this.simpleName.equals(that.simpleName)) {
                return false;
            }
            return !(this.nameFormat == null && that.nameFormat != null || this.nameFormat != null && !this.nameFormat.equals(that.nameFormat));
        }

        public int hashCode() {
            int result = 0;
            if (this.qualifiedName != null) {
                result = 31 * result + this.qualifiedName.hashCode();
            }
            if (this.simpleName != null) {
                result = 31 * result + this.simpleName.hashCode();
            }
            if (this.nameFormat != null) {
                result = 31 * result + this.nameFormat.hashCode();
            }
            return result;
        }
    }
}

