/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.qpid.proton.codec.AbstractPrimitiveType;
import org.apache.qpid.proton.codec.DecoderImpl;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.FixedSizePrimitiveTypeEncoding;
import org.apache.qpid.proton.codec.TypeEncoding;

public class TimestampType
extends AbstractPrimitiveType<Date> {
    private TimestampEncoding _timestampEncoding;

    TimestampType(EncoderImpl encoder, DecoderImpl decoder) {
        this._timestampEncoding = new TimestampEncoding(encoder, decoder);
        encoder.register(Date.class, this);
        decoder.register(this);
    }

    @Override
    public Class<Date> getTypeClass() {
        return Date.class;
    }

    public TimestampEncoding getEncoding(Date val) {
        return this._timestampEncoding;
    }

    public void fastWrite(EncoderImpl encoder, long timestamp) {
        encoder.writeRaw((byte)-125);
        encoder.writeRaw(timestamp);
    }

    public TimestampEncoding getCanonicalEncoding() {
        return this._timestampEncoding;
    }

    @Override
    public Collection<TimestampEncoding> getAllEncodings() {
        return Collections.singleton(this._timestampEncoding);
    }

    @Override
    public void write(long l) {
        this._timestampEncoding.write(l);
    }

    private class TimestampEncoding
    extends FixedSizePrimitiveTypeEncoding<Date> {
        public TimestampEncoding(EncoderImpl encoder, DecoderImpl decoder) {
            super(encoder, decoder);
        }

        @Override
        protected int getFixedSize() {
            return 8;
        }

        @Override
        public byte getEncodingCode() {
            return -125;
        }

        public TimestampType getType() {
            return TimestampType.this;
        }

        @Override
        public void writeValue(Date val) {
            this.getEncoder().writeRaw(val.getTime());
        }

        public void write(long l) {
            this.writeConstructor();
            this.getEncoder().writeRaw(l);
        }

        @Override
        public boolean encodesSuperset(TypeEncoding<Date> encoding) {
            return this.getType() == encoding.getType();
        }

        @Override
        public Date readValue() {
            return new Date(this.getDecoder().readRawLong());
        }
    }
}

