/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.HashMap;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.simple.SimpleQueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.impl.FieldContext;
import org.hibernate.search.query.dsl.impl.FieldsContext;

public class ConnectedSimpleQueryParser
extends SimpleQueryParser {
    protected final List<FieldsContext> fieldsContexts;

    public ConnectedSimpleQueryParser(Analyzer analyzer, List<FieldsContext> fieldsContexts) {
        this(analyzer, fieldsContexts, -1);
    }

    public ConnectedSimpleQueryParser(Analyzer analyzer, List<FieldsContext> fieldsContexts, int flags) {
        super(analyzer, new HashMap(0), flags);
        this.fieldsContexts = fieldsContexts;
    }

    protected Query newDefaultQuery(String text) {
        BooleanQuery.Builder bqb = new BooleanQuery.Builder().setDisableCoord(true);
        for (FieldsContext fieldsContext : this.fieldsContexts) {
            for (FieldContext fieldContext : fieldsContext) {
                Query q = this.createBooleanQuery(fieldContext.getField(), text, this.getDefaultOperator());
                if (q == null) continue;
                bqb.add(fieldContext.getFieldCustomizer().setWrappedQuery(q).createQuery(), BooleanClause.Occur.SHOULD);
            }
        }
        return this.simplify(bqb.build());
    }

    protected Query newFuzzyQuery(String text, int fuzziness) {
        BooleanQuery.Builder bqb = new BooleanQuery.Builder().setDisableCoord(true);
        for (FieldsContext fieldsContext : this.fieldsContexts) {
            for (FieldContext fieldContext : fieldsContext) {
                FuzzyQuery q = new FuzzyQuery(new Term(fieldContext.getField(), text), fuzziness);
                if (q == null) continue;
                bqb.add(fieldContext.getFieldCustomizer().setWrappedQuery((Query)q).createQuery(), BooleanClause.Occur.SHOULD);
            }
        }
        return this.simplify(bqb.build());
    }

    protected Query newPhraseQuery(String text, int slop) {
        BooleanQuery.Builder bqb = new BooleanQuery.Builder().setDisableCoord(true);
        for (FieldsContext fieldsContext : this.fieldsContexts) {
            for (FieldContext fieldContext : fieldsContext) {
                Query q = this.createPhraseQuery(fieldContext.getField(), text, slop);
                if (q == null) continue;
                bqb.add(fieldContext.getFieldCustomizer().setWrappedQuery(q).createQuery(), BooleanClause.Occur.SHOULD);
            }
        }
        return this.simplify(bqb.build());
    }

    protected Query newPrefixQuery(String text) {
        BooleanQuery.Builder bqb = new BooleanQuery.Builder().setDisableCoord(true);
        for (FieldsContext fieldsContext : this.fieldsContexts) {
            for (FieldContext fieldContext : fieldsContext) {
                PrefixQuery prefix = new PrefixQuery(new Term(fieldContext.getField(), text));
                bqb.add(fieldContext.getFieldCustomizer().setWrappedQuery((Query)prefix).createQuery(), BooleanClause.Occur.SHOULD);
            }
        }
        return this.simplify(bqb.build());
    }
}

