/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.time;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.Month;
import java.time.YearMonth;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.spi.DefaultExternalizer;

public class YearMonthExternalizer
implements Externalizer<YearMonth> {
    public void writeObject(ObjectOutput output, YearMonth value) throws IOException {
        output.writeInt(value.getYear());
        DefaultExternalizer.MONTH.cast(Month.class).writeObject(output, (Object)value.getMonth());
    }

    public YearMonth readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        int year = input.readInt();
        Month month = (Month)DefaultExternalizer.MONTH.cast(Month.class).readObject(input);
        return YearMonth.of(year, month);
    }

    public Class<YearMonth> getTargetClass() {
        return YearMonth.class;
    }
}

